/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.path;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.path.PathBrowser;
import com.mathworks.mlwidgets.path.PathUtils;
import com.mathworks.mlwidgets.util.MatlabFileIconUtils;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.recordlist.AbstractRecordlistModel;
import com.mathworks.widgets.recordlist.IDeletionObserver;
import com.mathworks.widgets.recordlist.IRecordDeleter;
import com.mathworks.widgets.recordlist.IRecordIconProvider;
import com.mathworks.widgets.recordlist.RecordlistModelEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PathModel
extends AbstractRecordlistModel
implements IRecordIconProvider,
IRecordDeleter {
    private Matlab fMatlab = null;
    private ActionListener fLocalActionListener = null;
    private static final int ICON_WIDTH = 16;
    private static final Object[] EOA = new Object[0];
    private List<MatlabPath.PathEntry> fCurrentPath = null;
    private List<MatlabPath.PathEntry> fOrigPath = null;
    private boolean fShowConfirmations = true;
    protected final Object fSemaphore = new Object();
    private static ResourceBundle fRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.path.resources.RES_PathBrowser");
    private PathModelActionListener fPathModelActionListener;

    public PathModel() {
        this.fMatlab = new Matlab();
        this.fCurrentPath = MatlabPath.getPathEntries();
        this.fPathModelActionListener = new PathModelActionListener();
        MatlabPath.addActionListener((ActionListener)this.fPathModelActionListener);
    }

    public void removeAllListeners() {
        MatlabPath.removeActionListener((ActionListener)this.fPathModelActionListener);
    }

    public String getFieldName(int n) {
        return "Directory";
    }

    public int getRecordCount() {
        return this.fCurrentPath.size();
    }

    public Object getValueAt(int n, int n2) {
        return this.fCurrentPath.get(n).getDisplayValue();
    }

    public int getFieldCount() {
        return 1;
    }

    public Class<String> getFieldClass(int n) {
        return String.class;
    }

    public int getPrimaryFieldIndex() {
        return 0;
    }

    public int getPresortFieldOrder() {
        return 0;
    }

    public int getPresortFieldIndex() {
        return 0;
    }

    public Object getSemaphore() {
        return this.fSemaphore;
    }

    public Icon getRecordIcon(int n) {
        return MatlabFileIconUtils.getFileIcon(this.fCurrentPath.get(n).getCurrentlyResolvedPath(), true);
    }

    public int getMaxIconHeight() {
        return 16;
    }

    public boolean areRecordsDeletable(int[] nArray) {
        return nArray.length > 0;
    }

    public void deleteRecords(int[] nArray, IDeletionObserver iDeletionObserver) {
        int n = iDeletionObserver.deletionStarted(nArray);
        if (n == 0) {
            MatlabPath.remove(this.getPathSubset(nArray), (CompletionObserver)new ChangeCallback());
        }
        iDeletionObserver.deletionCompleted(n, fRes.getString("listbox.delete.message"));
        this.fireAction("DELETED");
    }

    private List<MatlabPath.PathEntry> getPathSubset(int[] nArray) {
        int n = this.fCurrentPath.size();
        ArrayList<MatlabPath.PathEntry> arrayList = new ArrayList<MatlabPath.PathEntry>(nArray.length);
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            arrayList.add(this.fCurrentPath.get(n2));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPathBrowserPath() {
        Object object = this.fSemaphore;
        synchronized (object) {
            this.fCurrentPath = MatlabPath.getPathEntries();
        }
        this.fireRecordlistModelEvent(new RecordlistModelEvent());
    }

    private static boolean allValid(String[] stringArray) {
        for (String string : stringArray) {
            if (MatlabPath.isValidPathEntry((String)string)) continue;
            return false;
        }
        return true;
    }

    public void prepend(String[] stringArray) {
        if (PathModel.allValid(stringArray)) {
            MatlabPath.prepend((String[])stringArray, (CompletionObserver)new ChangeCallback());
        } else {
            this.displayChangeNotPossibleDialog();
        }
    }

    public void prependRecursively(String[] stringArray) {
        if (PathModel.allValid(stringArray)) {
            MatlabPath.prependRecursively((String[])stringArray, (CompletionObserver)new ChangeCallback());
        } else {
            this.displayChangeNotPossibleDialog();
        }
    }

    public void append(String[] stringArray) {
        if (PathModel.allValid(stringArray)) {
            MatlabPath.append((String[])stringArray, (CompletionObserver)new ChangeCallback());
        } else {
            this.displayChangeNotPossibleDialog();
        }
    }

    private static void rearrangePath(List<MatlabPath.PathEntry> list, int[] nArray, CompletionObserver completionObserver) {
        ArrayList<MatlabPath.PathEntry> arrayList = new ArrayList<MatlabPath.PathEntry>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get(nArray[i]));
        }
        MatlabPath.setPath(arrayList, (CompletionObserver)completionObserver);
    }

    public void promote(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.getRecordCount()];
        for (n = 0; n < this.getRecordCount(); ++n) {
            nArray2[n] = n;
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray2[nArray[n]];
            nArray2[nArray[n]] = nArray2[nArray[n] - 1];
            nArray2[nArray[n] - 1] = n2;
        }
        PathModel.rearrangePath(MatlabPath.getPathEntries(), nArray2, new ChangeCallback());
    }

    public void demote(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.getRecordCount()];
        for (n = 0; n < this.getRecordCount(); ++n) {
            nArray2[n] = n;
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            int n2 = nArray2[nArray[n]];
            nArray2[nArray[n]] = nArray2[nArray[n] + 1];
            nArray2[nArray[n] + 1] = n2;
        }
        PathModel.rearrangePath(MatlabPath.getPathEntries(), nArray2, new ChangeCallback());
    }

    public void revertAllChanges() {
        MatlabPath.setPath(this.fOrigPath, (CompletionObserver)new ChangeCallback());
    }

    private void evaluateSaveResults(boolean bl, ChangeListener changeListener) {
        if (bl) {
            this.fOrigPath = this.fCurrentPath;
            this.fireAction("DISABLE_SAVE");
            if (changeListener != null) {
                changeListener.stateChanged(new ChangeEvent((Object)this));
            }
        } else {
            Object[] objectArray = new String[]{fRes.getString("listbox.dialog.save.alternate.yes"), fRes.getString("listbox.dialog.save.alternate.no"), fRes.getString("listbox.dialog.save.alternate.help")};
            int n = MJOptionPane.showOptionDialog((Component)PathBrowser.getFrame(), (Object)fRes.getString("listbox.dialog.save.alternate.message"), (String)fRes.getString("listbox.dialog.generic.title"), (int)-1, (int)3, null, (Object[])objectArray, (Object)objectArray[0]);
            switch (n) {
                case 0: {
                    this.fireAction("FREE_CURSOR");
                    MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform(MatlabPath.getCWD());
                    mJFileChooserPerPlatform.setDialogTitle(fRes.getString("listbox.dialog.select.title"));
                    mJFileChooserPerPlatform.setSelectedFile(new File("pathdef.m"));
                    mJFileChooserPerPlatform.showSaveDialog((Component)PathBrowser.getFrame());
                    if (mJFileChooserPerPlatform.getState() != 0 || mJFileChooserPerPlatform.getSelectedFile() == null) break;
                    File file = mJFileChooserPerPlatform.getSelectedFile();
                    String string = file.getName();
                    File file2 = new File(file.getParent());
                    file = string == null || string.length() == 0 ? new File(file2, "pathdef.m") : new File(file2, string);
                    this.saveAs(FileUtils.fromJavaPath((String)file.getAbsolutePath()), changeListener);
                    break;
                }
                case 1: {
                    this.fireAction("FREE_CURSOR");
                    break;
                }
                case 2: {
                    MLHelpServices.displayTopic((String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), (String)"matlab_env_savepath");
                }
            }
        }
    }

    public void saveAs(String string) {
        this.saveAs(string, null);
    }

    public void saveAs(String string, ChangeListener changeListener) {
        Object[] objectArray = string != null ? new Object[]{string} : EOA;
        if (this.fMatlab == null) {
            this.fMatlab = new Matlab();
        }
        this.fireAction("BUSY_CURSOR");
        this.fMatlab.feval("savepath", objectArray, 1, (MatlabListener)new SaveCallback(changeListener));
    }

    public void restoreDefaultPath() {
        int n = 0;
        if (this.fShowConfirmations) {
            n = MJOptionPane.showConfirmDialog((Component)PathBrowser.getFrame(), (Object)fRes.getString("listbox.dialog.restore.message"), (String)fRes.getString("listbox.dialog.generic.title"), (int)0, (int)-1);
        }
        if (n == 0) {
            MatlabPath.restoreDefaultPath((CompletionObserver)new ChangeCallback());
        } else {
            this.fireAction("FREE_CURSOR");
        }
    }

    private void displayChangeNotPossibleDialog() {
        this.fireAction("FREE_CURSOR");
        if (this.fShowConfirmations) {
            PathUtils.showInvalidPathEntryDialog((Component)PathBrowser.getFrame(), fRes.getString("listbox.dialog.generic.title"));
        }
    }

    boolean isOriginalPath() {
        return this.fOrigPath.equals(this.fCurrentPath);
    }

    private void fireAction(String string) {
        this.processActionEvent(new ActionEvent((Object)this, 0, string));
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.fLocalActionListener = AWTEventMulticaster.add(this.fLocalActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.fLocalActionListener = AWTEventMulticaster.remove(this.fLocalActionListener, actionListener);
    }

    public synchronized void processActionEvent(ActionEvent actionEvent) {
        if (this.fLocalActionListener != null) {
            this.fLocalActionListener.actionPerformed(actionEvent);
        }
    }

    public void setShowConfirm(boolean bl) {
        this.fShowConfirmations = bl;
    }

    private class SaveCallback
    implements MatlabListener {
        private ChangeListener iListener;

        SaveCallback(ChangeListener changeListener) {
            this.iListener = changeListener;
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            boolean bl = false;
            Object object = matlabEvent.getResult();
            if (object instanceof double[]) {
                boolean bl2 = bl = ((double[])object)[0] == 0.0;
            }
            if (object instanceof boolean[]) {
                bl = !((boolean[])object)[0];
            }
            PathModel.this.evaluateSaveResults(bl, this.iListener);
            PathModel.this.fireAction("FREE_CURSOR");
        }
    }

    private class ChangeCallback
    implements CompletionObserver {
        private ChangeCallback() {
        }

        public void completed(int n, Object object) {
            PathModel.this.fireAction("FREE_CURSOR");
            if (PathUtils.changeNotificationWarningThrown(object)) {
                PathModel.this.fireAction("CHANGE_NOTIFICATION_WARNING");
            }
        }
    }

    private class PathModelActionListener
    implements ActionListener {
        private PathModelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("PATH_CHANGE")) {
                PathModel.this.fCurrentPath = MatlabPath.getPathEntries();
                if (PathModel.this.fOrigPath == null) {
                    PathModel.this.fOrigPath = PathModel.this.fCurrentPath;
                }
                PathModel.this.setPathBrowserPath();
            }
        }
    }
}

