/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.instutil.PlatformImpl;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.AdjacentButton;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.services.Prefs;
import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.PromptingTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;

public class GeneralPrefsPanel
extends MJPanel {
    private MJCheckBox fUsePathCache;
    private MJCheckBox fUsePathCacheDiag;
    private MJButton fUpdatePathCache;
    private static final boolean DEFAULT_TOOLBOX_CACHE = true;
    private static final boolean DEFAULT_TOOLBOX_CACHE_DIAG = false;
    private static PlatformImpl platform = new PlatformImpl();
    private MJRadioButton fRecycle;
    private MJRadioButton fPermanent;
    private MJPanel startupGroupBox;
    public static MJRadioButton fDefaultFolder;
    public static MJRadioButton fCustomFolder;
    public static MJRadioButton fLastFolder;
    public static PromptingTextField fCustomFolderTextField;
    private AdjacentButton fFolderBrowseButton;
    private ButtonGroup startupExclusiveGroup;
    private static Boolean isCustomFolderSelected;
    private static Boolean isLastFolderSelected;
    private static Boolean isDefaultFolderSelected;
    public static final SettingPath matlabNode;
    Setting<Boolean> deleteSetting = GeneralPrefsPanel.createBooleanSetting(matlabNode, "DeleteFilesPermanently");
    private static Matlab sMatlab;
    private static ResourceBundle sRes;
    private static GeneralPrefsPanel sPrefsPanel;
    private GPListener fGPListener;

    private static Setting<Boolean> createBooleanSetting(SettingPath settingPath, String string) {
        try {
            return new Setting(settingPath, Boolean.class, string);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    public static String getStringSettingValue(SettingPath settingPath, String string) {
        try {
            SettingPath settingPath2 = new SettingPath(settingPath, new String[]{"workingfolder"});
            Setting setting = new Setting(settingPath2, String.class, string);
            return (String)setting.get();
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private static void setStringSettingValue(SettingPath settingPath, String string, String string2) {
        try {
            SettingPath settingPath2 = new SettingPath(settingPath, new String[]{"workingfolder"});
            Setting setting = new Setting(settingPath2, String.class, string);
            setting.set((Object)string2);
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    public static int getToolboxCacheLevel() {
        if (!Prefs.getBooleanPref((String)"GeneralUseToolboxCache", (boolean)true)) {
            return 0;
        }
        if (Prefs.getBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)false)) {
            return 2;
        }
        return 1;
    }

    public static void setToolboxCache(boolean bl) {
        Prefs.setBooleanPref((String)"GeneralUseToolboxCache", (boolean)bl);
        if (sPrefsPanel != null) {
            GeneralPrefsPanel.sPrefsPanel.fUsePathCache.setSelected(bl);
            sPrefsPanel.enablePathCacheItems();
        }
    }

    private GeneralPrefsPanel() {
        this.setName("GeneralPrefsPanel");
        this.fUsePathCache = new MJCheckBox(sRes.getString("gtlp.usetoolboxcache"));
        this.fUsePathCache.setName("gtlp.usetoolboxcache");
        this.fUsePathCacheDiag = new MJCheckBox(sRes.getString("gtlp.usetoolboxcachediag"));
        this.fUsePathCacheDiag.setName("gtlp.usetoolboxcachediag");
        this.fUpdatePathCache = new MJButton(sRes.getString("gtlp.updatetoolboxcache"));
        this.fUpdatePathCache.setName("gtlp.updatetoolboxcache");
        this.fUpdatePathCache.setActionCommand("UpdateCache");
        this.fGPListener = new GPListener();
        this.fUpdatePathCache.addActionListener((ActionListener)this.fGPListener);
        this.fUsePathCache.setSelected(Prefs.getBooleanPref((String)"GeneralUseToolboxCache", (boolean)true));
        this.fUsePathCacheDiag.setSelected(Prefs.getBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)false));
        this.enablePathCacheItems();
        this.fUsePathCache.addItemListener((ItemListener)this.fGPListener);
        MJPanel mJPanel = new MJPanel();
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("gtlp.toolboxcachepanel")));
        MJPanel mJPanel2 = new MJPanel();
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(0, 18, 0, 0));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel3.add((Component)this.fUpdatePathCache, (Object)"West");
        mJPanel.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 2, 196608));
        mJPanel2.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 2, 196608));
        mJPanel.add((Component)this.fUsePathCache);
        mJPanel2.add((Component)this.fUsePathCacheDiag);
        mJPanel2.add((Component)mJPanel3);
        mJPanel.add((Component)mJPanel2);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel4.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 2, 196608));
        mJPanel4.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("gtlp.deletepanel")));
        String string = "";
        if (PlatformInfo.isWindows()) {
            mJPanel4.add((Component)new MJMultilineLabel(sRes.getString("gtlp.explanation.windows")));
            string = sRes.getString("gtlp.recycle.windows");
        } else {
            mJPanel4.add((Component)new MJLabel(sRes.getString("gtlp.explanation.macunix")));
            string = PlatformInfo.isMacintosh() ? sRes.getString("gtlp.recycle.macintosh") : sRes.getString("gtlp.recycle.unix");
        }
        this.fRecycle = new MJRadioButton(string);
        this.fRecycle.setName("gtlp.recycle.platform");
        this.fPermanent = new MJRadioButton(sRes.getString("gtlp.recycle.permanent"));
        this.fPermanent.setName("gtlp.recycle.permanent");
        mJPanel4.add((Component)this.fRecycle);
        mJPanel4.add((Component)this.fPermanent);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fRecycle);
        buttonGroup.add((AbstractButton)this.fPermanent);
        try {
            if (((Boolean)this.deleteSetting.get()).booleanValue()) {
                this.fPermanent.setSelected(true);
            } else {
                this.fRecycle.setSelected(true);
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
        String string2 = GeneralPrefsPanel.getStringSettingValue(matlabNode, "InitialWorkingFolder");
        isCustomFolderSelected = string2.equals("custom_folder");
        isLastFolderSelected = string2.equals("last_folder");
        isDefaultFolderSelected = string2.equals("") || string2.equals("default_folder");
        this.startupGroupBox = new MJPanel((LayoutManager)new GridBagLayout());
        this.startupGroupBox.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("gtlp.startuppanel")));
        fDefaultFolder = new MJRadioButton(sRes.getString("gtlp.defaultfolderoption"), isDefaultFolderSelected.booleanValue());
        fDefaultFolder.setName("gtlp.defaultfolderoption");
        fLastFolder = new MJRadioButton(sRes.getString("gtlp.lastfolderoption"), isLastFolderSelected.booleanValue());
        fLastFolder.setName("gtlp.lastfolderoption");
        fCustomFolder = new MJRadioButton("", isCustomFolderSelected.booleanValue());
        fCustomFolder.setName("gtlp.customfolderoption");
        fCustomFolderTextField = new PromptingTextField(sRes.getString("gtlp.placeholder"));
        fCustomFolderTextField.setEnabled(fCustomFolder.isSelected());
        fCustomFolderTextField.setName("CustomFolderTextField");
        String string3 = GeneralPrefsPanel.getStringSettingValue(matlabNode, "CustomFolderPath");
        File file = new File(string3);
        if (file.exists()) {
            fCustomFolderTextField.setText(string3);
        }
        this.fFolderBrowseButton = new AdjacentButton(sRes.getString("gtlp.folderbrowsebutton"), (Component)fCustomFolderTextField);
        this.fFolderBrowseButton.addActionListener((ActionListener)new FileChooserButtonListener());
        this.fFolderBrowseButton.setName("InstallFolderBrowseButton");
        this.fFolderBrowseButton.setEnabled(fCustomFolder.isSelected());
        BuiltinItemListener builtinItemListener = new BuiltinItemListener();
        fCustomFolder.addItemListener((ItemListener)builtinItemListener);
        fLastFolder.addItemListener((ItemListener)builtinItemListener);
        fDefaultFolder.addItemListener((ItemListener)builtinItemListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        int n = 4;
        int n2 = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, n2, n);
        this.startupGroupBox.add((Component)new MJMultilineLabel(sRes.getString("gtlp.explanation.startupdescription")), (Object)gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        this.startupGroupBox.add((Component)fDefaultFolder, (Object)gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.startupGroupBox.add((Component)fLastFolder, (Object)gridBagConstraints);
        n = 0;
        gridBagConstraints.insets = new Insets(0, 0, n2, n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.startupGroupBox.add((Component)fCustomFolder, (Object)gridBagConstraints);
        n = 4;
        gridBagConstraints.insets = new Insets(0, 0, n2, n);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.startupGroupBox.add((Component)fCustomFolderTextField, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.startupGroupBox.add((Component)this.fFolderBrowseButton, (Object)gridBagConstraints);
        this.startupExclusiveGroup = new ButtonGroup();
        this.startupExclusiveGroup.add((AbstractButton)fDefaultFolder);
        this.startupExclusiveGroup.add((AbstractButton)fCustomFolder);
        this.startupExclusiveGroup.add((AbstractButton)fLastFolder);
        this.setLayout((LayoutManager)new MGridLayout(4, 1, n, n2, 131072));
        this.add((Component)this.startupGroupBox);
        this.add((Component)mJPanel4);
        this.add((Component)mJPanel);
    }

    public static String returnSelectedRadio() {
        if (isCustomFolderSelected.booleanValue()) {
            return "custom";
        }
        if (isLastFolderSelected.booleanValue()) {
            return "last";
        }
        return "default";
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new GeneralPrefsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.savePrefs();
        }
    }

    public static synchronized boolean validatePrefsPanel() {
        return sPrefsPanel == null || sPrefsPanel.validateOptions();
    }

    private boolean validateOptions() {
        boolean bl = true;
        String string = null;
        String string2 = fCustomFolderTextField.getText();
        File file = new File(string2);
        if (fCustomFolder.isSelected()) {
            String string3 = GeneralPrefsPanel.getStringSettingValue(matlabNode, "CustomFolderPath");
            GeneralPrefsPanel.setStringSettingValue(matlabNode, "CustomFolderPath", string2);
            String string4 = GeneralPrefsPanel.getStringSettingValue(matlabNode, "CustomFolderPath");
            File file2 = new File(string4);
            if (!file2.exists()) {
                string = MessageFormat.format(sRes.getString("startup.error.invalidSetting.path"), string2);
                bl = false;
            }
            GeneralPrefsPanel.setStringSettingValue(matlabNode, "CustomFolderPath", string3);
            if (!file.exists()) {
                string = MessageFormat.format(sRes.getString("startup.error.invalid.path"), string2);
                bl = false;
            }
            if (string != null) {
                MJOptionPane.showMessageDialog((Component)this.startupGroupBox, (Object)string, (String)sRes.getString("startup.error.title"), (int)0);
                bl = false;
            }
        }
        return bl;
    }

    private void savePrefs() {
        Prefs.setBooleanPref((String)"GeneralUseToolboxCache", (boolean)this.fUsePathCache.isSelected());
        Prefs.setBooleanPref((String)"GeneralUseToolboxCacheDiag", (boolean)this.fUsePathCacheDiag.isSelected());
        GeneralPrefsPanel.setStringSettingValue(matlabNode, "CustomFolderPath", fCustomFolderTextField.getText());
        if (fCustomFolder.isSelected()) {
            GeneralPrefsPanel.setStringSettingValue(matlabNode, "InitialWorkingFolder", "custom_folder");
        } else if (fDefaultFolder.isSelected()) {
            GeneralPrefsPanel.setStringSettingValue(matlabNode, "InitialWorkingFolder", "default_folder");
        } else if (fLastFolder.isSelected()) {
            GeneralPrefsPanel.setStringSettingValue(matlabNode, "InitialWorkingFolder", "last_folder");
        } else {
            GeneralPrefsPanel.setStringSettingValue(matlabNode, "InitialWorkingFolder", "default_folder");
        }
        try {
            if (((Boolean)this.deleteSetting.get()).booleanValue() == this.fRecycle.isSelected()) {
                if (this.fRecycle.isSelected()) {
                    sMatlab.evalNoOutput("recycle on");
                } else {
                    sMatlab.evalNoOutput("recycle off");
                }
                this.deleteSetting.set((Object)(!this.fRecycle.isSelected() ? 1 : 0));
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
    }

    private void rehashToolboxCache() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        sMatlab.eval("rehash toolboxcache;", (CompletionObserver)this.fGPListener);
    }

    private void enablePathCacheItems() {
        this.fUsePathCacheDiag.setEnabled(this.fUsePathCache.isSelected());
        this.fUpdatePathCache.setEnabled(this.fUsePathCache.isSelected());
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_general_prefs"};
    }

    static {
        matlabNode = new SettingPath(new String[]{"matlab"});
        sMatlab = new Matlab();
        sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
        sPrefsPanel = null;
    }

    private class GPListener
    implements ItemListener,
    CompletionObserver,
    ActionListener {
        private GPListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            GeneralPrefsPanel.this.enablePathCacheItems();
        }

        public void completed(int n, Object object) {
            GeneralPrefsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            if (Matlab.getExecutionStatus((int)n) != 0) {
                MJOptionPane.showMessageDialog((Component)GeneralPrefsPanel.this.fUsePathCache, (Object)sRes.getString("gtlpcd.createfailed"), (String)sRes.getString("gtlpcd.title"), (int)2);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("UpdateCache")) {
                GeneralPrefsPanel.this.rehashToolboxCache();
            }
        }
    }

    private class FileChooserButtonListener
    implements ActionListener {
        private FileChooserButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
            File file2 = new File(fCustomFolderTextField.getText());
            if (file2.exists()) {
                mJFileChooserPerPlatform.setCurrentDirectory(file2);
            }
            mJFileChooserPerPlatform.setDialogTitle(sRes.getString("gtlp.startuppaneldialog"));
            mJFileChooserPerPlatform.setFileSelectionMode(1);
            mJFileChooserPerPlatform.showOpenDialog((Component)((Object)GeneralPrefsPanel.this));
            if (mJFileChooserPerPlatform.getState() == 0 && (file = mJFileChooserPerPlatform.getSelectedFile()) != null) {
                fCustomFolderTextField.setText(file.getAbsolutePath());
            }
        }
    }

    private class BuiltinItemListener
    implements ItemListener {
        private BuiltinItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Boolean bl = fCustomFolder.isSelected();
            fCustomFolderTextField.setEnabled(bl.booleanValue());
            GeneralPrefsPanel.this.fFolderBrowseButton.setEnabled(bl.booleanValue());
        }
    }
}

