/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TransferableTreePathList
implements Transferable {
    public static final DataFlavor TREE_PATH_FLAVOR = new DataFlavor(TreePath.class, "Tree Path");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{TREE_PATH_FLAVOR};
    private final Object[][] fPaths;

    public TransferableTreePathList(TreePath[] treePathArray) {
        this.fPaths = new Object[treePathArray.length][];
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            this.fPaths[i] = new Object[treePath.getPathCount()];
            for (int j = 0; j < treePath.getPathCount(); ++j) {
                Object object = treePath.getPathComponent(j);
                this.fPaths[i][j] = object instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)object).getUserObject().toString() : object;
            }
        }
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.getRepresentationClass() == TreePath.class;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            Object[] objectArray = new Object[this.fPaths.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.fPaths[i].clone();
            }
            return objectArray;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

