/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.tabcompletion;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.UniqueList;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.tabcompletion.TabCompletionResults;
import com.mathworks.mlwidgets.tabcompletion.MatlabTabContext;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionPrefs;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionResult;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class TabCompletionModel
extends AbstractListModel {
    private static List<MessageCompletionResult> sNoCompletionMessage;
    private static List<MessageCompletionResult> sTooManyResultsMessage;
    private static final ResourceBundle BUNDLE;
    private static final UniqueResultComparator RESULT_UNIQUER;
    private static final SortResultComparator RESULT_SORTER;
    private final List<TabCompletionResult> fAllData;

    public TabCompletionModel() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public TabCompletionModel(List<? extends TabCompletionResult> list, List<? extends TabCompletionResult> list2) {
        BasicEventList basicEventList = new BasicEventList();
        basicEventList.addAll(list);
        basicEventList.addAll(list2);
        this.fAllData = new SortedList((EventList)new UniqueList((EventList)basicEventList, (Comparator)RESULT_UNIQUER), (Comparator)RESULT_SORTER);
    }

    @Override
    public int getSize() {
        return this.showingErrorMessage() ? this.getErrorMessage().size() : this.fAllData.size();
    }

    @Override
    public TabCompletionResult getElementAt(int n) {
        return this.showingErrorMessage() ? (TabCompletionResult)this.getErrorMessage().get(n) : this.fAllData.get(n);
    }

    public boolean showingErrorMessage() {
        return this.hasNoMatches() || this.tooManyMatches();
    }

    public boolean hasMoreThanOneMatch() {
        return this.getTotalNumberOfMatches() > 0;
    }

    private int getTotalNumberOfMatches() {
        return this.fAllData.size();
    }

    public boolean hasNoMatches() {
        return MatlabTabContext.getStatus() == TabCompletionResults.Status.NO_MATCHES && this.fAllData.isEmpty();
    }

    private boolean tooManyMatches() {
        return MatlabTabContext.getStatus() == TabCompletionResults.Status.TOO_MANY_MATCHES || this.fAllData.size() > TabCompletionPrefs.getTooManyTabResultsWarning();
    }

    private List<MessageCompletionResult> getErrorMessage() {
        List<Object> list = Collections.emptyList();
        if (this.hasNoMatches()) {
            list = TabCompletionModel.getNoCompletionMessage();
        } else if (this.tooManyMatches()) {
            list = TabCompletionModel.getTooManyMessage();
        }
        assert (!list.isEmpty()) : "getErrorMessage should only be called when there is an error message.";
        return list;
    }

    private static synchronized List<MessageCompletionResult> getNoCompletionMessage() {
        if (sNoCompletionMessage == null) {
            sNoCompletionMessage = Collections.singletonList(new MessageCompletionResult(BUNDLE.getString("cwtc.nocompletes")));
        }
        return sNoCompletionMessage;
    }

    private static synchronized List<MessageCompletionResult> getTooManyMessage() {
        if (sTooManyResultsMessage == null) {
            sTooManyResultsMessage = new Vector<MessageCompletionResult>();
            for (String string : Arrays.asList(MessageFormat.format(BUNDLE.getString("cwtc.toomany"), TabCompletionPrefs.getTooManyTabResultsWarning()).split("\n"))) {
                sTooManyResultsMessage.add(new MessageCompletionResult(string));
            }
        }
        return sTooManyResultsMessage;
    }

    public boolean allMatchesHaveCommonPrefix() {
        return !this.fAllData.isEmpty() && this.getCommonPrefix().length() != 0;
    }

    public boolean hasUniqueMatch() {
        return this.fAllData.size() == 1;
    }

    public String getCommonPrefix() {
        String string = null;
        for (TabCompletionResult tabCompletionResult : this.fAllData) {
            String string2 = tabCompletionResult.getRestOfWord();
            if (string2 == null) continue;
            if (string == null) {
                string = string2;
                continue;
            }
            if ((string = TabCompletionModel.overlap(string2, string)).length() != 0) continue;
            break;
        }
        return string == null ? "" : string;
    }

    public void completeString(CompletionObserver completionObserver, int n) {
        TabCompletionResult tabCompletionResult = this.fAllData.get(n);
        tabCompletionResult.complete(completionObserver);
    }

    private static String overlap(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        int n2 = 0;
        for (int i = 0; i < n && string.charAt(i) == string2.charAt(i); ++i) {
            n2 = i + 1;
        }
        return string.substring(0, n2);
    }

    public String getUpperCaseString(int n) {
        return this.getElementAt(n).getString().toUpperCase(Locale.US);
    }

    static {
        BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.tabcompletion.resources.RES_TabComp");
        RESULT_UNIQUER = new UniqueResultComparator();
        RESULT_SORTER = new SortResultComparator();
    }

    private static class MessageCompletionResult
    extends TabCompletionResult {
        private MessageCompletionResult(String string) {
            super(string);
        }

        @Override
        public void complete(CompletionObserver completionObserver) {
            assert (false) : "Should not try to complete an error message.";
        }

        @Override
        public String getRestOfWord() {
            return "";
        }
    }

    private static class SortResultComparator
    implements Comparator<TabCompletionResult> {
        private SortResultComparator() {
        }

        @Override
        public int compare(TabCompletionResult tabCompletionResult, TabCompletionResult tabCompletionResult2) {
            return tabCompletionResult.getString().toUpperCase(Locale.US).compareTo(tabCompletionResult2.getString().toUpperCase(Locale.US));
        }
    }

    private static class UniqueResultComparator
    implements Comparator<TabCompletionResult> {
        private UniqueResultComparator() {
        }

        @Override
        public int compare(TabCompletionResult tabCompletionResult, TabCompletionResult tabCompletionResult2) {
            return tabCompletionResult.getString().compareTo(tabCompletionResult2.getString());
        }
    }
}

