/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.text.mcode;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.swing.SearchEngineTextMatcherEditor;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlwidgets.text.mcode.MLintPrefsHelper;
import com.mathworks.mlwidgets.text.mcode.MLintTable;
import com.mathworks.mlwidgets.text.mcode.MLintTableRow;
import com.mathworks.mwswing.ComboBoxItem;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.Prefs;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.FileComboBox;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.SearchTextField;
import com.mathworks.widgets.SettingsChooser;
import com.mathworks.widgets.prefs.PrefsEditorPanelV1;
import com.mathworks.widgets.prefs.PrefsHelp;
import com.mathworks.widgets.prefs.PrefsNode;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MLintPrefsPanel
extends MJPanel
implements PrefsEditorPanelV1 {
    private static final ResourceBundle BUNDLE = MLintPrefsHelper.getBundle();
    private final FileComboBox fConfigurationCombo;
    private final MJCheckBox fEnableInEditor;
    private final MJComboBox fUnderlining;
    private final MLintPrefsHelper fHelper;
    private final MJLabel fTableTitle;
    private final HyperlinkTextLabel fColorPanelHyperlink;
    private final MJAbstractAction fRestoreDefaults;
    private final SearchTextField fSearchTextField = this.buildSearchTextField();
    private MLintTable fTable;
    private SortedList<MLintTableRow> fSortedList;
    private FilterList<MLintTableRow> fFilterList;
    private SearchEngineTextMatcherEditor<MLintTableRow> fSearchEngineTextMatcherEditor;
    public static final String NAME_ENABLE_MLINT = "MLintEnableInEditorCheckBox";
    public static final String NAME_PANEL = "MLintPrefsPanel";
    public static final String NAME_CONFIGURATION_TREE = "MLintConfigurationTreeTitle";
    public static final String NAME_UNDERLINING_OPTIONS = "MLintUnderliningComboBox";
    public static final String NAME_ACTIVE_SETTINGS = "MLintSettingsComboBox";
    public static final String NAME_SETTINGS_TABLE = "MLintConfigurationTable";
    public static final String NAME_SETTINGS_SCROLLPANE = "MLintConfigurationScrollPane";
    public static final String NAME_RESTORE_DEFAULTS = "RestoreDefaultsButton";
    public static final String NAME_SEARCH = "MLintSearchTextField";
    private final BusyAffordance fLoadingBusyAffordance;

    private boolean doValidate() {
        boolean bl = true;
        if (this.fHelper.isModified() && this.fHelper.getConfiguration().isReadOnly()) {
            this.showDialog("mlint.msg.fileReadOnly", this.fHelper.getConfiguration().getFile(), null);
            bl = false;
        }
        return bl;
    }

    public MLintPrefsPanel(Dimension dimension) {
        this(new MLintPrefsHelper(), dimension);
    }

    public MLintPrefsPanel(MLintPrefsHelper mLintPrefsHelper, Dimension dimension) {
        if (mLintPrefsHelper == null) {
            throw new IllegalArgumentException("MLintPrefsHelper cannot be null.");
        }
        this.setName(NAME_PANEL);
        this.setSize(dimension);
        this.fHelper = mLintPrefsHelper;
        this.fConfigurationCombo = this.buildConfigurationCombo();
        this.fTableTitle = MLintPrefsPanel.buildTableTitle();
        this.fLoadingBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_32x32);
        this.fUnderlining = MLintPrefsPanel.buildUnderliningComboBox();
        this.fEnableInEditor = this.buildEnableInEditorCheckBox();
        this.fRestoreDefaults = new MJAbstractAction(BUNDLE.getString("mlint.button.restoreDefaults")){

            public void actionPerformed(ActionEvent actionEvent) {
                MLintPrefsPanel.this.fSearchTextField.setSearchText(null);
                MLintPrefsPanel.this.fHelper.restoreDefaults();
                MLintPrefsPanel.this.refresh();
                MLintPrefsPanel.this.fTable.requestFocus();
            }
        };
        this.fRestoreDefaults.setComponentName(NAME_RESTORE_DEFAULTS);
        this.fColorPanelHyperlink = new HyperlinkTextLabel(MessageFormat.format("<a href=\".\">{0}</a>", BUNDLE.getString("mlint.hyperlink.autofixColor")), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
                MLPrefsDialogServices.showPrefsDialog((String)(resourceBundle.getString("area.colors") + "." + resourceBundle.getString("area.colorsCodeTools")));
            }
        }, false, "autofixHyperlink", BUNDLE.getString("mlint.hyperlink.autofixAccessible"));
        this.setLayout(new BorderLayout());
        this.add(this.buildDecoratorPanel(), "North");
        this.add(this.buildGlazedTreePanel(), "Center");
        this.fConfigurationCombo.setSelectedItem((Object)this.fHelper.getConfiguration().getFile());
        this.refreshRestoreComboBox();
        this.fTableTitle.setText("");
        this.fTableTitle.setEnabled(false);
        this.fHelper.addMessagesUpdatedListeners(new MLintPrefsHelper.MessagesUpdatedListener(){

            @Override
            public void messagesUpdated() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MLintPrefsPanel.this.fLoadingBusyAffordance.stop();
                        MLintPrefsPanel.this.refresh();
                        MLintPrefsPanel.this.fSearchTextField.setEnabled(true);
                    }
                });
            }
        });
        this.fHelper.setBusyAffordance(this.fLoadingBusyAffordance);
        this.fLoadingBusyAffordance.start();
    }

    private MJCheckBox buildEnableInEditorCheckBox() {
        final MJCheckBox mJCheckBox = new MJCheckBox(BUNDLE.getString("mlint.checkbox.enableInEditor"));
        mJCheckBox.setName(NAME_ENABLE_MLINT);
        mJCheckBox.setSelected(EditorPrefsAccessor.isMLintEnabled());
        mJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLintPrefsPanel.this.fUnderlining.setEnabled(mJCheckBox.isSelected());
            }
        });
        this.fUnderlining.setEnabled(mJCheckBox.isSelected());
        return mJCheckBox;
    }

    private static MJLabel buildTableTitle() {
        MJLabel mJLabel = new MJLabel();
        mJLabel.setName(NAME_CONFIGURATION_TREE);
        mJLabel.setBackground(UIManager.getColor("Table.background"));
        mJLabel.setOpaque(true);
        mJLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mJLabel.setFont(mJLabel.getFont().deriveFont(1));
        return mJLabel;
    }

    private static MJComboBox buildUnderliningComboBox() {
        MJComboBox mJComboBox = new MJComboBox();
        mJComboBox.setName(NAME_UNDERLINING_OPTIONS);
        mJComboBox.getAccessibleContext().setAccessibleName(BUNDLE.getString("mlint.acc.underline"));
        mJComboBox.addItem((Object)new ComboBoxItem(BUNDLE.getString("mlint.underline.all"), (Object)2));
        mJComboBox.addItem((Object)new ComboBoxItem(BUNDLE.getString("mlint.underline.errors"), (Object)1));
        mJComboBox.addItem((Object)new ComboBoxItem(BUNDLE.getString("mlint.underline.none"), (Object)0));
        ComboBoxItem.select((MJComboBox)mJComboBox, (Object)EditorPrefsAccessor.getMLintUnderlining());
        return mJComboBox;
    }

    private boolean askUserToSaveChanges(Object object) {
        boolean bl;
        boolean bl2 = object.equals(MLintPrefsUtils.DEFAULT_SETTINGS_FILE);
        String string = bl2 ? MLintPrefsUtils.DEFAULT_SETTINGS : ((File)object).getName();
        int n = Dialogs.showSaveDirtyFile((Component)((Object)this), (String)string, (String)BUNDLE.getString("mlint.dialogTitle"));
        switch (n) {
            case 0: {
                if (bl2) {
                    bl = this.saveFile(MLintPrefsUtils.DEFAULT_SETTINGS_FILE);
                    break;
                }
                bl = this.saveFile(null);
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private FileComboBox buildConfigurationCombo() {
        FileComboBox.FileChosenCallback fileChosenCallback = new FileComboBox.FileChosenCallback(){

            public boolean saveAs(File file) {
                return MLintPrefsPanel.this.saveFile(file);
            }

            public boolean acceptChange(Object object, Object object2) {
                boolean bl = true;
                if (MLintPrefsPanel.this.fHelper.isModified()) {
                    bl = MLintPrefsPanel.this.askUserToSaveChanges(object);
                }
                return bl;
            }

            public boolean fileChosen(File file) {
                return MLintPrefsPanel.this.loadFile(file);
            }

            public void otherItemChosen(Object object) {
                assert (false);
            }
        };
        final FilePatternFilter filePatternFilter = new FilePatternFilter(){

            public String getDescription() {
                return BUNDLE.getString("mlint.chooser.textDocuments");
            }

            public String[] getPatterns() {
                return new String[]{"*.txt"};
            }
        };
        FileComboBox.FilenameCellRenderer filenameCellRenderer = new FileComboBox.FilenameCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (object.equals(MLintPrefsUtils.DEFAULT_SETTINGS_FILE)) {
                    this.setText(MLintPrefsPanel.this.fHelper.areDefaultsChanged() ? MLintPrefsUtils.DEFAULT_SETTINGS_MODIFIED : MLintPrefsUtils.DEFAULT_SETTINGS);
                }
                return this;
            }
        };
        FileComboBox fileComboBox = new FileComboBox(fileChosenCallback, new Object[]{MLintPrefsUtils.DEFAULT_SETTINGS_FILE}){

            protected void prepareChooser(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
                mJFileChooserPerPlatform.addChoosableFileFilter(filePatternFilter);
            }
        };
        fileComboBox.setRenderer(filenameCellRenderer);
        fileComboBox.addFilesFromPrefs(MLintPrefsUtils.getConfigurationFileListPrefKey());
        fileComboBox.setNewFileStartPosition(1);
        fileComboBox.getComboBox().setName(NAME_ACTIVE_SETTINGS);
        return fileComboBox;
    }

    private boolean saveFile(File file) {
        boolean bl = false;
        try {
            if (file == null) {
                this.fHelper.doSave();
            } else {
                this.fHelper.doSaveAs(file);
            }
            bl = true;
        }
        catch (Exception exception) {
            this.showDialog("mlint.msg.problemSaving", file, exception);
        }
        return bl;
    }

    private boolean loadFile(File file) {
        boolean bl = false;
        if (file.equals(MLintPrefsUtils.DEFAULT_SETTINGS_FILE)) {
            bl = true;
        }
        if (!file.exists()) {
            this.showDialog("mlint.msg.fileNoLongerExists", file, null);
        } else {
            try {
                MLintConfiguration mLintConfiguration = MLintConfiguration.read((File)file);
                this.fHelper.setConfiguration(mLintConfiguration);
                this.refresh();
                bl = true;
            }
            catch (Exception exception) {
                this.showDialog("mlint.msg.problemReading", file, exception);
            }
            this.refreshRestoreComboBox();
        }
        return bl;
    }

    private void showDialog(final String string, final File file, final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeAnalyzerUtils.showErrorDialog((Component)((Object)MLintPrefsPanel.this), (String)string, (File)file, (Exception)exception);
            }
        });
    }

    private void doCommit(boolean bl) {
        this.fConfigurationCombo.saveFilesToPrefs(MLintPrefsUtils.getConfigurationFileListPrefKey());
        if (bl) {
            Prefs.setBooleanPref((String)"Editormlint-display", (boolean)this.fEnableInEditor.isSelected());
            Integer n = (Integer)((ComboBoxItem)this.fUnderlining.getSelectedItem()).getValue();
            Prefs.setIntegerPref((String)"Editormlint-underlining", (int)n);
            try {
                this.fHelper.commitFile(this.fConfigurationCombo.getSelectedFile());
            }
            catch (Exception exception) {
                this.showDialog("mlint.msg.problemSaving", this.fConfigurationCombo.getSelectedFile(), exception);
            }
        }
    }

    private void refresh() {
        this.refreshRestoreComboBox();
        this.fTableTitle.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.fTable.refresh();
        this.fSearchTextField.setSearchText(this.fSearchTextField.getSearchText());
    }

    private void refreshRestoreComboBox() {
        boolean bl = this.fConfigurationCombo.getSelectedItem().equals(MLintPrefsUtils.DEFAULT_SETTINGS_FILE);
        boolean bl2 = bl && this.fHelper.areDefaultsChanged();
        boolean bl3 = this.fHelper.getConfiguration().isReadOnly();
        this.fRestoreDefaults.setEnabled(bl2 && !bl3);
        if (bl2) {
            this.fTableTitle.setText(MLintPrefsUtils.DEFAULT_SETTINGS_MODIFIED);
        } else if (bl) {
            this.fTableTitle.setText(MLintPrefsUtils.DEFAULT_SETTINGS);
        } else {
            String string = this.fConfigurationCombo.getSelectedItem().toString();
            this.fTableTitle.setText(FileUtils.truncatePathname((String)string, (int)50));
            this.fTableTitle.setToolTipText(string);
        }
        if (bl3) {
            this.fTableTitle.setText(MessageFormat.format(BUNDLE.getString("mlint.readOnly"), this.fTableTitle.getText()));
        }
        this.fTableTitle.setEnabled(true);
        this.fConfigurationCombo.getComboBox().repaint();
    }

    private JComponent buildDecoratorPanel() {
        FormLayout formLayout = new FormLayout(MJUtilities.getCheckBoxIndent() + "px, pref, 3dlu, p:grow", "p, 4dlu, p, 3dlu, p, 6dlu, p, 3dlu, p, 12dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fEnableInEditor, cellConstraints.xywh(1, 1, 4, 1));
        panelBuilder.add((Component)new MJLabel(BUNDLE.getString("mlint.label.underlining")), cellConstraints.xy(2, 3));
        panelBuilder.add((Component)this.fUnderlining, cellConstraints.xy(4, 3));
        panelBuilder.add((Component)new MJLabel(BUNDLE.getString("mlint.label.autofix")), cellConstraints.xy(2, 5));
        panelBuilder.add((Component)this.fColorPanelHyperlink.getComponent(), cellConstraints.xy(4, 5));
        panelBuilder.add((Component)new SettingsChooser(this.fConfigurationCombo, new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                jPopupMenu.add((Action)MLintPrefsPanel.this.fRestoreDefaults);
            }
        }).getPanel(), cellConstraints.xywh(1, 9, 4, 1));
        return panelBuilder.getPanel();
    }

    private JComponent buildGlazedTreePanel() {
        EventList<MLintTableRow> eventList = this.fHelper.getMessageDefinitions();
        eventList.getReadWriteLock().writeLock().lock();
        this.fSortedList = this.buildFilterList(eventList);
        eventList.getReadWriteLock().writeLock().unlock();
        this.fTable = new MLintTable((EventList<MLintTableRow>)this.fSortedList, this.fHelper);
        this.fTable.setName(NAME_SETTINGS_TABLE);
        this.fTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                MLintPrefsPanel.this.refreshRestoreComboBox();
            }
        });
        ScrollablePanel scrollablePanel = new ScrollablePanel((JComponent)this.fTableTitle, (JTable)((Object)this.fTable));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)scrollablePanel);
        mJScrollPane.setPreferredSize(new Dimension(1, 1));
        mJScrollPane.setName(NAME_SETTINGS_SCROLLPANE);
        mJScrollPane.getViewport().setBackground(this.fTable.getBackground());
        mJScrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MLintPrefsPanel.this.fTable.hideExtendedHelp();
            }
        });
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("fill:p:grow", "p, 2dlu, fill:p:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)this.fLoadingBusyAffordance.getComponent(), (Object)cellConstraints.xy(1, 3));
        mJPanel.add(this.buildSearchFieldPanel(), (Object)cellConstraints.xy(1, 1));
        mJPanel.add((Component)mJScrollPane, (Object)cellConstraints.xy(1, 3));
        return mJPanel;
    }

    private SortedList<MLintTableRow> buildFilterList(EventList<MLintTableRow> eventList) {
        TextFilterator<MLintTableRow> textFilterator = new TextFilterator<MLintTableRow>(){

            public void getFilterStrings(List<String> list, MLintTableRow mLintTableRow) {
                if (mLintTableRow.isChangedFromDefault().booleanValue()) {
                    list.add(BUNDLE.getString("mlint.keyword.true"));
                } else {
                    list.add(BUNDLE.getString("mlint.keyword.false"));
                }
            }
        };
        TextFilterator<MLintTableRow> textFilterator2 = new TextFilterator<MLintTableRow>(){

            public void getFilterStrings(List<String> list, MLintTableRow mLintTableRow) {
                list.add(mLintTableRow.getCategoryTag());
            }
        };
        TextFilterator<MLintTableRow> textFilterator3 = new TextFilterator<MLintTableRow>(){

            public void getFilterStrings(List<String> list, MLintTableRow mLintTableRow) {
                if (CodeAnalyzerUtils.isWarning((Integer)mLintTableRow.getSeverity())) {
                    list.add(BUNDLE.getString("mlint.keyword.warning"));
                } else {
                    list.add(BUNDLE.getString("mlint.keyword.error"));
                }
            }
        };
        TextFilterator<MLintTableRow> textFilterator4 = new TextFilterator<MLintTableRow>(){

            public void getFilterStrings(List<String> list, MLintTableRow mLintTableRow) {
                if (mLintTableRow.isEnabled().booleanValue()) {
                    list.add(BUNDLE.getString("mlint.keyword.true"));
                } else {
                    list.add(BUNDLE.getString("mlint.keyword.false"));
                }
            }
        };
        TextFilterator<MLintTableRow> textFilterator5 = new TextFilterator<MLintTableRow>(){

            public void getFilterStrings(List<String> list, MLintTableRow mLintTableRow) {
                list.add(mLintTableRow.getTag());
            }
        };
        HashSet<SearchEngineTextMatcherEditor.Field> hashSet = new HashSet<SearchEngineTextMatcherEditor.Field>(2);
        hashSet.add(new SearchEngineTextMatcherEditor.Field(BUNDLE.getString("mlint.keyword.modified"), (TextFilterator)textFilterator));
        hashSet.add(new SearchEngineTextMatcherEditor.Field(BUNDLE.getString("mlint.keyword.category"), (TextFilterator)textFilterator2));
        hashSet.add(new SearchEngineTextMatcherEditor.Field(BUNDLE.getString("mlint.keyword.severity"), (TextFilterator)textFilterator3));
        hashSet.add(new SearchEngineTextMatcherEditor.Field(BUNDLE.getString("mlint.keyword.enabled"), (TextFilterator)textFilterator4));
        hashSet.add(new SearchEngineTextMatcherEditor.Field(BUNDLE.getString("mlint.keyword.messageId"), (TextFilterator)textFilterator5));
        this.fSearchEngineTextMatcherEditor = this.fSearchTextField.createSearchEngineTextMatcherEditor((TextFilterator)new ProxyFilterator(), hashSet);
        this.fFilterList = new FilterList(eventList);
        this.fFilterList.setMatcherEditor(this.fSearchEngineTextMatcherEditor);
        SortedList sortedList = new SortedList(this.fFilterList, MLintPrefsHelper.getMessageComparator());
        sortedList.setMode(1);
        return sortedList;
    }

    public void commitChanges(PrefsNode prefsNode) {
        this.doCommit(true);
    }

    public boolean validateChanges(PrefsNode prefsNode) {
        return this.doValidate();
    }

    public void cancelChanges(PrefsNode prefsNode) {
        this.doCommit(false);
    }

    public boolean canDetectPendingEdits(PrefsNode prefsNode) {
        return false;
    }

    public boolean hasPendingEdits(PrefsNode prefsNode) {
        assert (false) : "should not be called because canDetectPendingEdits is false";
        return true;
    }

    public JComponent getComponent(PrefsNode prefsNode) {
        return this;
    }

    public PrefsHelp getHelp() {
        return new PrefsHelp(MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_mlint_prefs");
    }

    public void doHelp() {
        PrefsHelp prefsHelp = this.getHelp();
        MLHelpServices.displayTopic((String)prefsHelp.getHelpMapPath(), (String)prefsHelp.getHelpTopicKey());
    }

    public void dispose() {
        this.fTable.dispose();
        this.fSearchEngineTextMatcherEditor.dispose();
        this.fSortedList.dispose();
        this.fFilterList.dispose();
    }

    private Component buildSearchFieldPanel() {
        MJPanel mJPanel = new MJPanel();
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p:grow", "p"), (JPanel)mJPanel);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fSearchTextField.getComponent(), cellConstraints.xyw(1, 1, 1));
        return mJPanel;
    }

    private SearchTextField buildSearchTextField() {
        SearchTextField searchTextField = new SearchTextField(BUNDLE.getString("mlint.search.prompt"), new PopupMenuCustomizer(){

            private void appendKeyword(String string, String string2) {
                String string3;
                String string4 = MLintPrefsPanel.this.fSearchTextField.getSearchText();
                if (string4.contains(string3 = string + ":")) {
                    string4 = string4.replaceFirst(string3 + "[^\\s]+", string3 + string2);
                } else {
                    StringBuilder stringBuilder = new StringBuilder(string4);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    string4 = stringBuilder.append(string3).append(string2).toString();
                }
                MLintPrefsPanel.this.fSearchTextField.setSearchText(string4);
            }

            public void customize(JPopupMenu jPopupMenu) {
                jPopupMenu.removeAll();
                jPopupMenu.add((JMenuItem)new MJMenuItem((Action)new AbstractAction(BUNDLE.getString("mlint.action.showAll")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MLintPrefsPanel.this.fSearchTextField.setSearchText(null);
                    }
                }));
                jPopupMenu.add((JMenuItem)new MJMenuItem((Action)new AbstractAction(BUNDLE.getString("mlint.action.searchForModified")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.appendKeyword(BUNDLE.getString("mlint.keyword.modified"), BUNDLE.getString("mlint.keyword.true"));
                    }
                }));
                MJMenu mJMenu = new MJMenu(BUNDLE.getString("mlint.action.searchForCategory"));
                jPopupMenu.add((JMenuItem)mJMenu);
                for (MLint.Category category : MLintPrefsPanel.this.fHelper.getCategoryList()) {
                    final MLint.Category category2 = category;
                    if (MLintPrefsUtils.isInternalCategory((MLint.Category)category2)) continue;
                    mJMenu.add((JMenuItem)new MJMenuItem((Action)new AbstractAction(category2.getName()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.appendKeyword(BUNDLE.getString("mlint.keyword.category"), category2.getTag());
                        }
                    }));
                }
                jPopupMenu.add((JMenuItem)new MJMenuItem((Action)new AbstractAction(BUNDLE.getString("mlint.action.searchForWarnings")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.appendKeyword(BUNDLE.getString("mlint.keyword.severity"), BUNDLE.getString("mlint.keyword.warning"));
                    }
                }));
                jPopupMenu.add((JMenuItem)new MJMenuItem((Action)new AbstractAction(BUNDLE.getString("mlint.action.searchForErrors")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.appendKeyword(BUNDLE.getString("mlint.keyword.severity"), BUNDLE.getString("mlint.keyword.error"));
                    }
                }));
                jPopupMenu.add((JMenuItem)new MJMenuItem((Action)new AbstractAction(BUNDLE.getString("mlint.action.searchForDisabled")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.appendKeyword(BUNDLE.getString("mlint.keyword.enabled"), BUNDLE.getString("mlint.keyword.false"));
                    }
                }));
            }
        });
        searchTextField.addSearchTextFieldListener(new SearchTextField.Listener(){

            public void search(String string) {
                MLintPrefsPanel.this.fTable.setSearchText(string.trim());
            }

            public void searchTextChanged(String string) {
                MLintPrefsPanel.this.fTable.setSearchText(string.trim());
            }

            public void searchCleared() {
                MLintPrefsPanel.this.fTable.setSearchText(null);
            }
        });
        searchTextField.setEnabled(false);
        searchTextField.getComponent().setName(NAME_SEARCH);
        return searchTextField;
    }

    private SearchTextField getSearchTextField() {
        return this.fSearchTextField;
    }

    private MLintPrefsHelper getHelper() {
        return this.fHelper;
    }

    private static class ProxyFilterator
    implements TextFilterator<MLintTableRow> {
        private ProxyFilterator() {
        }

        public void getFilterStrings(List<String> list, MLintTableRow mLintTableRow) {
            list.add(mLintTableRow.getCategoryTag());
            list.add(mLintTableRow.getMessage());
            list.add(mLintTableRow.getTag());
            list.add(mLintTableRow.getCategoryName());
            if (mLintTableRow.hasExtendedHelp().booleanValue()) {
                assert (mLintTableRow.getExtendedHelp() != null) : "ext help is null";
                list.add(mLintTableRow.getExtendedHelp().replaceAll("<[^>]+>", ""));
            }
        }
    }

    private static class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private final JTable fTable;

        private ScrollablePanel(JComponent jComponent, JTable jTable) {
            super(new BorderLayout());
            this.add((Component)jComponent, "North");
            this.add(jTable);
            this.fTable = jTable;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.fTable.getScrollableTracksViewportHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return this.fTable.getScrollableTracksViewportWidth();
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.fTable.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.fTable.getScrollableBlockIncrement(rectangle, n, n2);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return this.fTable.getScrollableUnitIncrement(rectangle, n, n2);
        }
    }
}

