/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.util.productinfo;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.jmi.Matlab;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ProductIcon {
    private static final String UNKNOWN = "UNKNOWN";
    private static Map<String, Icon> sIconMap = new HashMap<String, Icon>();
    private static MatlabDependencyProvider sDependencyProvider = new DefaultDependencyProvider();

    private ProductIcon() {
    }

    public static Icon getIcon(String string) {
        return ProductIcon.getIcon(string, ProductIcon.getDependencyProvider().matlabRoot());
    }

    public static ImageIcon getIcon(String string, String string2) {
        ImageIcon imageIcon = ProductIcon.findIcon(string, string2);
        if (imageIcon == null) {
            return ProductIcon.getUnknownIcon();
        }
        return imageIcon;
    }

    private static ImageIcon findIcon(String string, String string2) {
        ImageIcon imageIcon;
        String string3 = ProductIcon.resolveImageName(string);
        if (sIconMap.containsKey(string3)) {
            return (ImageIcon)sIconMap.get(string3);
        }
        int n = Math.max(string3.lastIndexOf(47), string3.lastIndexOf(92));
        String string4 = string3.substring(n + 1);
        if (IconEnumerationUtils.isValidCommonKey((String)string4)) {
            imageIcon = IconEnumerationUtils.findCommonIcon((String)string4);
            sIconMap.put(string3, imageIcon);
        } else {
            imageIcon = new ImageIcon(string3);
            if (imageIcon.getImageLoadStatus() == 8) {
                sIconMap.put(string3, imageIcon);
            } else {
                string3 = string2 + "/" + string3;
                imageIcon = new ImageIcon(string3);
                if (imageIcon.getImageLoadStatus() == 8) {
                    sIconMap.put(string3, imageIcon);
                } else {
                    return null;
                }
            }
        }
        imageIcon.setDescription(string4);
        return imageIcon;
    }

    private static String resolveImageName(String string) {
        String string2 = string;
        String string3 = ProductIcon.getDependencyProvider().matlabRoot().replaceFirst("[\\\\/]$", "") + File.separator;
        if (string2.startsWith("$toolbox")) {
            string2 = string3 + string2.substring(1);
        }
        if (string2.startsWith("$matlabroot")) {
            String string4 = string2.replaceFirst("^\\$matlabroot[\\/]", "");
            string2 = string3 + string4;
        }
        return string2;
    }

    public static ImageIcon getUnknownIcon() {
        if (sIconMap.containsKey(UNKNOWN)) {
            return (ImageIcon)sIconMap.get(UNKNOWN);
        }
        ImageIcon imageIcon = ProductIcon.findIcon(ProductIcon.getDependencyProvider().getUnknownImagePath(), ProductIcon.getDependencyProvider().matlabRoot());
        sIconMap.put(UNKNOWN, imageIcon);
        return imageIcon;
    }

    static void setDependencyProvider(MatlabDependencyProvider matlabDependencyProvider) {
        sDependencyProvider = matlabDependencyProvider;
    }

    private static MatlabDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    private static void clear() {
        sIconMap.clear();
    }

    public static class DefaultDependencyProvider
    implements MatlabDependencyProvider {
        private static final String UNKNOWN_IMAGE_PATH = "$toolbox/matlab/icons/unknownicon.gif";

        @Override
        public String matlabRoot() {
            return Matlab.matlabRoot();
        }

        @Override
        public String getUnknownImagePath() {
            return UNKNOWN_IMAGE_PATH;
        }
    }

    public static interface MatlabDependencyProvider {
        public String matlabRoot();

        public String getUnknownImagePath();
    }
}

