/*
 * Decompiled with CFR 0.152.
 */
package ice.dombase;

import ice.debug.Debug;
import ice.dombase.LexCallbackBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class LexBase
extends InputStream {
    protected static final char[] EMPTY_CHAR_ARRAY = new char[0];
    protected LexCallbackBase callback;
    protected static final IOException lexer_eof = new IOException();
    protected InputStream sourceInputStream;
    protected int inputReadProgress;
    protected Reader reader;
    protected char[] char_buf;
    protected int mark;
    protected int bufEnd;
    protected static final int TEXT_STATE = 0;
    protected static final int MARKUP_START_STATE = 1;
    protected static final int META_MARKUP_START_STATE = 2;
    protected static final int IN_XML_COMMENTS_STATE = 3;
    protected static final int SCRIPT_STATE = 4;
    protected static final int TEXTAREA_STATE = 5;
    protected static final int CDATA_STATE = 6;
    protected static final int EMBEDDED_XML_STATE = 7;
    protected int lexerState;
    private int OEAB;
    protected boolean done;
    protected int lexerNestingLevel;
    protected int memoryCheckCounter;
    public int lineNumber;

    protected LexBase(LexCallbackBase lexCallbackBase) {
        this.callback = lexCallbackBase;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void reqCdata() {
        this.lexerState = 6;
    }

    public void reqEmbeddedXml() {
        this.lexerState = 7;
    }

    public void reqScriptCdata() {
        this.lexerState = 4;
    }

    public void reqTextareaCdata() {
        this.lexerState = 5;
    }

    protected void restoreBuffer(char[] cArray, int n, int n2) {
        if (this.mark != this.bufEnd) {
            int n3 = this.bufEnd - this.mark;
            if (n3 <= n) {
                System.arraycopy(this.char_buf, this.mark, cArray, n -= n3, n3);
            } else {
                int n4 = n2 - n;
                int n5 = n3 + n4;
                int n6 = this.char_buf.length;
                if (n5 <= n6) {
                    System.arraycopy(cArray, n, cArray, n3, n4);
                    System.arraycopy(this.char_buf, this.mark, cArray, 0, n3);
                } else {
                    if (n5 > (n6 *= 2)) {
                        n6 = n5;
                    }
                    char[] cArray2 = new char[n6];
                    System.arraycopy(cArray, n, cArray2, n3, n4);
                    System.arraycopy(this.char_buf, this.mark, cArray2, 0, n3);
                    cArray = cArray2;
                }
                n = 0;
                n2 = n5;
            }
        }
        this.char_buf = cArray;
        this.mark = n;
        this.bufEnd = n2;
    }

    private int EMPTY_CHAR_ARRAY(int n) throws IOException {
        return this.OEAB(n, 1);
    }

    private int OEAB(int n, int n2) throws IOException {
        int n3 = n + n2 - this.bufEnd;
        if (n3 > 0) {
            if (this.lexerNestingLevel > 1 || this.sourceInputStream == null && this.reader == null) {
                throw lexer_eof;
            }
            if (this.mark != 0) {
                System.arraycopy(this.char_buf, this.mark, this.char_buf, 0, this.bufEnd - this.mark);
                n -= this.mark;
                this.bufEnd -= this.mark;
                this.mark = 0;
            }
            this.readAtLeast(n3);
        }
        return n;
    }

    protected void readAtLeast(int n) throws IOException {
        int n2;
        int n3 = this.bufEnd + n;
        int n4 = this.char_buf.length;
        if (n3 > n4) {
            if (n3 > (n4 *= 2)) {
                n4 = n3;
            }
            char[] cArray = new char[n4];
            System.arraycopy(this.char_buf, 0, cArray, 0, this.bufEnd);
            this.char_buf = cArray;
        }
        do {
            if ((n2 = this.reader.read(this.char_buf, this.bufEnd, n4 - this.bufEnd)) < 0) {
                throw lexer_eof;
            }
            this.bufEnd += n2;
            this.inputReadProgress += n2;
        } while ((n -= n2) > 0);
    }

    void stopParsing() {
        this.done = true;
    }

    public final void parse() throws IOException {
        this.parse(true, true);
    }

    public void parse(boolean bl, boolean bl2) throws IOException {
        try {
            ++this.lexerNestingLevel;
            if (this.lexerNestingLevel == 1 && bl) {
                this.callback.startDocument();
            }
            this.arraycopy(bl2);
            if (this.done && this.lexerNestingLevel == 1 && bl2) {
                this.callback.endDocument();
            }
            Object var4_3 = null;
            --this.lexerNestingLevel;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            --this.lexerNestingLevel;
            throw throwable;
        }
    }

    private void arraycopy(boolean bl) throws IOException {
        block13: {
            try {
                while (!this.done) {
                    if (!this.callback.isStopRequested()) {
                        this.checkMemory();
                        switch (this.lexerState) {
                            case 0: {
                                this.callback();
                                break;
                            }
                            case 1: {
                                this.char_buf();
                                break;
                            }
                            case 2: {
                                this.done();
                                break;
                            }
                            case 3: {
                                this.endDocument();
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                this.charAt();
                            }
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                if (iOException != lexer_eof) {
                    Debug.ex((Throwable)iOException);
                    throw iOException;
                }
                if (this.lexerNestingLevel != 1 || !bl) break block13;
                if (this.lexerState != 3) {
                    this.cdataBody(this.char_buf, this.mark, this.bufEnd, 0);
                }
                this.done = true;
            }
        }
    }

    protected void checkMemory() throws IOException {
    }

    private int bufEnd(int n, int n2) throws IOException {
        if (this.lexerNestingLevel == 1) {
            if (n == 13) {
                if (n2 + 1 == this.bufEnd) {
                    n2 = this.OEAB(n2, 2);
                }
                if (this.char_buf[n2 + 1] == '\n') {
                    return n2;
                }
            }
            ++this.lineNumber;
        }
        return n2;
    }

    private void callback() throws IOException {
        int n;
        int n2 = this.mark;
        int n3 = -1;
        while (true) {
            if (n2 == this.bufEnd) {
                n2 = this.EMPTY_CHAR_ARRAY(n2);
            }
            if ((n = this.char_buf[n2]) == 13 || n == 10) {
                n2 = this.bufEnd(n, n2);
            }
            ++n2;
            if (n == 60) {
                if (n2 == this.bufEnd) {
                    n2 = this.EMPTY_CHAR_ARRAY(n2);
                }
                if ((n = this.char_buf[n2]) == 13 || n == 10) {
                    n2 = this.bufEnd(n, n2);
                }
                if (!LexBase.isStopRequested(n) && n != 37 && n != 45 && n != 60) break;
                continue;
            }
            if (n != 38 || n3 >= 0) continue;
            n3 = n2 - this.mark - 1;
        }
        n = this.mark;
        int n4 = n2 - 1;
        this.mark = n2;
        this.lexerState = 1;
        this.cdataBody(this.char_buf, n, n4, n3);
    }

    private void cdataBody(char[] cArray, int n, int n2, int n3) {
        if (n != n2) {
            if (n3 >= 0) {
                n2 = this.lexerState(cArray, n + n3, n2);
            }
            this.callback.textCharacters(cArray, n, n2 - n);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void charAt() throws IOException {
        var1_1 = this.mark;
        var2_2 = false;
        var3_3 = true;
        var4_4 = 2;
        var5_5 = 3;
        var6_6 = 4;
        var7_7 = 5;
        var8_8 = 6;
        var9_9 = 0;
        block9: while (true) {
            if (var1_1 == this.bufEnd) {
                var1_1 = this.EMPTY_CHAR_ARRAY(var1_1);
            }
            if ((var10_10 = this.char_buf[var1_1]) == 13 || var10_10 == 10) {
                var1_1 = this.bufEnd(var10_10, var1_1);
            }
            ++var1_1;
            switch (var9_9) {
                case 0: {
                    if (var10_10 == 60) {
                        var9_9 = 1;
                    }
                    ** GOTO lbl84
                }
                case 1: {
                    if (var10_10 == 47) {
                        var11_11 = 1;
                        var12_12 = null;
                        if (this.lexerState == 7) {
                            var12_12 = "xml";
                        } else if (this.lexerState == 4) {
                            var12_12 = "script";
                        } else if (this.lexerState == 5) {
                            var12_12 = "textarea";
                        }
                        if (var12_12 != null) {
                            var13_13 = var12_12.length();
                            var1_1 = this.OEAB(var1_1, var13_13 + 1);
                            var14_14 = this.char_buf;
                            var15_15 = 0;
                            while (var15_15 != var13_13) {
                                var10_10 = var14_14[var1_1 + var15_15];
                                var16_16 = var12_12.charAt(var15_15);
                                if (var10_10 != var16_16 && var10_10 != var16_16 + -32) {
                                    var11_11 = 0;
                                    break;
                                }
                                ++var15_15;
                            }
                            if (var11_11 != 0 && (var10_10 = var14_14[var1_1 + var13_13]) != 62 && !LexBase.isStopRequested(var10_10)) {
                                var11_11 = 0;
                            }
                        }
                        if (var11_11 != 0) {
                            break block9;
                        }
                    } else if (var10_10 == 33) {
                        var9_9 = 2;
                    } else {
                        --var1_1;
                        var9_9 = 0;
                    }
                    ** GOTO lbl84
                }
                case 2: {
                    if (var10_10 == 45) {
                        var9_9 = 3;
                    } else {
                        --var1_1;
                        var9_9 = 0;
                    }
                    ** GOTO lbl84
                }
                case 3: {
                    if (var10_10 == 45) {
                        var9_9 = 4;
                    } else {
                        --var1_1;
                        var9_9 = 0;
                    }
                    ** GOTO lbl84
                }
                case 4: {
                    if (var10_10 == 45) {
                        var9_9 = 5;
                    }
                    ** GOTO lbl84
                }
                case 5: {
                    var9_9 = var10_10 == 45 ? 6 : 4;
                    ** GOTO lbl84
                }
                case 6: {
                    if (var10_10 != 62) ** GOTO lbl82
                    var9_9 = 0;
                    ** GOTO lbl84
lbl82:
                    // 1 sources

                    if (var10_10 != 45) {
                        var9_9 = 4;
                    }
                }
lbl84:
                // 15 sources

                default: {
                    continue block9;
                }
            }
            break;
        }
        var10_10 = this.mark;
        var11_11 = var1_1 -= 2;
        if (this.lexerState == 5) {
            var11_11 = this.lexerState(this.char_buf, var10_10, var11_11);
            var11_11 = LexBase.lexerNestingLevel(this.char_buf, var10_10, var11_11);
        }
        this.lexerState = 0;
        this.mark = var1_1;
        this.callback.cdataBody(this.char_buf, var10_10, var11_11 - var10_10);
    }

    private void char_buf() throws IOException {
        char c;
        int n = this.mark;
        if (n == this.bufEnd) {
            n = this.EMPTY_CHAR_ARRAY(n);
        }
        if ((c = this.char_buf[n]) == '!') {
            this.mark = n + 1;
            this.lexerState = 2;
        } else {
            this.endElement();
        }
    }

    private void done() throws IOException {
        int n = this.OEAB(this.mark, 2);
        if (this.char_buf[n] == '-' && this.char_buf[n + 1] == '-') {
            this.mark = n + 2;
            this.lexerState = 3;
            this.OEAB = 0;
        } else {
            this.mark = n = this.elementAttribute(n);
            this.lexerState = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int elementAttribute(int n) throws IOException {
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 2;
        int n3 = 3;
        int n4 = 4;
        int n5 = 5;
        int n6 = 0;
        boolean bl3 = false;
        while (true) {
            char c;
            if (n == this.bufEnd) {
                n = this.EMPTY_CHAR_ARRAY(n);
            }
            if ((c = this.char_buf[n]) == '\r' || c == '\n') {
                n = this.bufEnd(c, n);
            }
            ++n;
            switch (n6) {
                case 0: {
                    if (c == '>' && !bl3) {
                        return n;
                    }
                    if (c != '-') break;
                    n6 = 1;
                    break;
                }
                case 1: {
                    if (c == '>' && !bl3) {
                        return n;
                    }
                    if (c == '-') {
                        n6 = 2;
                        break;
                    }
                    n6 = 0;
                    break;
                }
                case 2: {
                    if (c == '>' && !bl3) {
                        return n;
                    }
                    if (c == '-') break;
                    n6 = 3;
                    break;
                }
                case 3: {
                    if (c != '-') break;
                    n6 = 4;
                    break;
                }
                case 4: {
                    if (c == '-') {
                        n6 = 5;
                        break;
                    }
                    n6 = 3;
                    break;
                }
                case 5: {
                    if (c == '>' && !bl3) {
                        return n;
                    }
                    if (c == '-') break;
                    n6 = 0;
                }
            }
            if (n6 == 3) continue;
            if (c == '[') {
                bl3 = true;
                continue;
            }
            if (c != ']') continue;
            bl3 = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void endDocument() throws IOException {
        int n = this.mark;
        int n2 = -1;
        int n3 = 0;
        try {
            block12: while (true) {
                char c;
                if (n == this.bufEnd) {
                    Object var5_7;
                    try {
                        n3 = this.mark;
                        n = this.EMPTY_CHAR_ARRAY(n);
                        var5_7 = null;
                        if (n2 != -1 && this.mark != n3) {
                            n2 -= n3 - this.mark;
                        }
                    }
                    catch (Throwable throwable) {
                        var5_7 = null;
                        if (n2 != -1 && this.mark != n3) {
                            n2 -= n3 - this.mark;
                        }
                        throw throwable;
                    }
                }
                if ((c = this.char_buf[n]) == '\r' || c == '\n') {
                    Object var7_8;
                    try {
                        n3 = this.mark;
                        n = this.bufEnd(c, n);
                        var7_8 = null;
                        if (n2 != -1 && this.mark != n3) {
                            n2 -= n3 - this.mark;
                        }
                    }
                    catch (Throwable throwable) {
                        var7_8 = null;
                        if (n2 != -1 && this.mark != n3) {
                            n2 -= n3 - this.mark;
                        }
                        throw throwable;
                    }
                }
                ++n;
                switch (this.OEAB) {
                    case 0: {
                        if (c == '>') break block12;
                        if (c == '-') break;
                        this.OEAB = 1;
                        break;
                    }
                    case 1: {
                        if (c == '-') {
                            this.OEAB = 2;
                            break;
                        }
                        if (c != '>' || n2 != -1) break;
                        n2 = n;
                        break;
                    }
                    case 2: {
                        if (c == '-') {
                            this.OEAB = 3;
                            break;
                        }
                        if (c == '>' && n2 == -1) {
                            n2 = n;
                        }
                        this.OEAB = 1;
                        break;
                    }
                    case 3: {
                        if (c == '>') break block12;
                        if (c == '-') break;
                        this.OEAB = 1;
                    }
                }
            }
        }
        catch (IOException iOException) {
            if (iOException != lexer_eof) {
                throw iOException;
            }
            if (n2 == -1) {
                throw iOException;
            }
            n = n2;
        }
        this.mark = n;
        this.lexerState = 0;
    }

    private void endElement() throws IOException {
        int n;
        int n2 = this.mark;
        int n3 = 0;
        while (true) {
            if (n2 == this.bufEnd) {
                n2 = this.EMPTY_CHAR_ARRAY(n2);
            }
            if ((n = this.char_buf[n2]) == 13 || n == 10) {
                n2 = this.bufEnd(n, n2);
            }
            if (n == 39 || n == 34) {
                char c;
                if (n3 == n) {
                    n3 = 0;
                } else if (n3 == 0 && (LexBase.isStopRequested(c = this.char_buf[n2 - 1]) || c == '=')) {
                    n3 = n;
                }
            } else if (n == 62 && n3 == 0) break;
            ++n2;
        }
        n = this.mark;
        this.mark = ++n2;
        this.lexerState = 0;
        char[] cArray = this.char_buf;
        int n4 = this.mark;
        int n5 = this.bufEnd;
        this.char_buf = EMPTY_CHAR_ARRAY;
        this.mark = 0;
        this.bufEnd = 0;
        try {
            if (cArray[n] != '/') {
                this.ex(cArray, n, n2 - n - 1);
            } else {
                int n6 = 0;
                int n7 = ++n;
                while (n7 < n2) {
                    char c = cArray[n7];
                    ++n7;
                    if (c == ':') {
                        n6 = n7 - n;
                    }
                    if (LexBase.isStopRequested(c)) break;
                }
                this.callback.endElement(this, cArray, n, n7 - n - 1, n6);
            }
            Object var11_11 = null;
            this.restoreBuffer(cArray, n4, n5);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.restoreBuffer(cArray, n4, n5);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void ex(char[] var1_1, int var2_2, int var3_3) {
        block32: {
            var4_4 = '\u0000';
            var5_5 = false;
            var4_4 = var1_1[var2_2 + var3_3 - 1];
            if (var4_4 == '/') {
                var5_5 = true;
                --var3_3;
                var4_4 = var1_1[var2_2];
                var6_6 = var1_1[var2_2 + 1];
                if (!((var4_4 != 'a' && var4_4 != 'A' || var6_6 != 32) && (var4_4 != 'b' && var4_4 != 'B' || var6_6 != 97 && var6_6 != 65 || var1_1[var2_2 + 4] != ' ') && (var4_4 != 'o' && var4_4 != 'O' || var6_6 != 112 && var6_6 != 80 || var1_1[var2_2 + 6] != ' ') && (var4_4 != 'f' && var4_4 != 'F' || var6_6 != 111 && var6_6 != 79 || var1_1[var2_2 + 4] != ' '))) {
                    var5_5 = false;
                    ++var3_3;
                }
            } else if (var4_4 == '?') {
                --var3_3;
            }
            var6_6 = var2_2;
            var7_7 = var2_2 + var3_3;
            var8_8 = 0;
            while (var6_6 < var7_7) {
                var4_4 = var1_1[var6_6];
                if (LexBase.isStopRequested(var4_4)) break;
                if (var4_4 == ':') {
                    var8_8 = var6_6 - var2_2 + 1;
                }
                ++var6_6;
            }
            var9_9 = var2_2;
            var10_10 = var6_6 - var2_2;
            break block32;
            while (LexBase.isStopRequested(var4_4 = var1_1[var6_6])) {
                ++var6_6;
lbl30:
                // 2 sources

                ** while (var6_6 >= var7_7)
lbl31:
                // 1 sources

            }
lbl32:
            // 2 sources

            var11_11 = var6_6;
            var12_12 = 0;
            while (var6_6 < var7_7) {
                var4_4 = var1_1[var6_6];
                if (LexBase.isStopRequested(var4_4) || var4_4 == '=') break;
                if (var4_4 == ':') {
                    var12_12 = var6_6 - var11_11 + 1;
                }
                ++var6_6;
            }
            var13_13 = var6_6 - var11_11;
            var14_14 = false;
            while (var6_6 < var7_7) {
                var4_4 = var1_1[var6_6];
                if (var4_4 == '=') {
                    var14_14 = true;
                } else if (!LexBase.isStopRequested(var4_4)) break;
                ++var6_6;
            }
            if (!var14_14) {
                if (var13_13 > 0) {
                    this.callback.elementAttribute(var1_1, var11_11, var13_13, var12_12, var11_11, var13_13);
                }
            } else {
                var15_15 = var6_6;
                var16_16 = 0;
                var17_17 = '\u0000';
                if (var4_4 == '\'' || var4_4 == '\"') {
                    var17_17 = var4_4;
                }
                if (var17_17 == '\u0000') {
                    while (var6_6 < var7_7) {
                        var4_4 = var1_1[var6_6];
                        if (!LexBase.isStopRequested(var4_4)) {
                            if (var4_4 == '&') {
                                var16_16 = 1;
                            }
                            ++var6_6;
                            continue;
                        }
                        break;
                    }
                } else {
                    ++var6_6;
                    while (var6_6 < var7_7) {
                        var4_4 = var1_1[var6_6];
                        if (var4_4 == var17_17) {
                            ++var6_6;
                            break;
                        }
                        if (var4_4 == '&' || var4_4 == '\n' || var4_4 == '\r' || var4_4 == '\t') {
                            var16_16 = 1;
                        }
                        ++var6_6;
                    }
                }
                var18_18 = false;
                if (!(var16_16 <= 0 || var13_13 <= 2 || var1_1[var11_11] != 'o' && var1_1[var11_11] != 'O' || var1_1[var11_11 + 1] != 'n' && var1_1[var11_11 + 1] != 'N')) {
                    var18_18 = true;
                }
                var19_19 = var6_6 - var15_15;
                if (var17_17 != '\u0000') {
                    if (var19_19 >= 2) {
                        if (var16_16 > 0) {
                            var16_16 = this.inputReadProgress(var1_1, var15_15 + 1, var19_19 - 2, var18_18);
                        }
                        this.callback.elementAttribute(var1_1, var11_11, var13_13, var12_12, var15_15 + 1, var19_19 - 2 - var16_16);
                    }
                } else {
                    if (var16_16 > 0) {
                        var16_16 = this.inputReadProgress(var1_1, var15_15, var19_19, var18_18);
                    }
                    this.callback.elementAttribute(var1_1, var11_11, var13_13, var12_12, var15_15, var19_19 - var16_16);
                }
            }
        }
        if (var6_6 < var7_7) ** GOTO lbl30
        this.callback.startElement(this, var1_1, var9_9, var10_10, var8_8, var5_5);
    }

    /*
     * Unable to fully structure code
     */
    private int inputReadProgress(char[] var1_1, int var2_2, int var3_3, boolean var4_4) {
        var5_5 = new char[var3_3];
        System.arraycopy(var1_1, var2_2, var5_5, 0, var3_3);
        var6_6 = 0;
        var7_7 = 0;
        while (var7_7 < var3_3) {
            var8_8 = var5_5[var7_7];
            if (var4_4) ** GOTO lbl-1000
            if (var8_8 == '\r' || var8_8 == '\n') {
                ++var6_6;
            } else if (var8_8 == '\t') {
                var1_1[var2_2++] = 32;
            } else if (var8_8 == '&') {
                var9_9 = var7_7 + 1;
                while (var9_9 <= var3_3) {
                    if ((var9_9 == var3_3 || var5_5[var9_9] == ';') && (var11_11 = this.lexer_eof(var5_5, var7_7 + 1, var10_10 = var9_9 - var7_7 - 1)) >= 0) {
                        var7_7 = var9_9;
                        var1_1[var2_2++] = (char)var11_11;
                        var6_6 += var10_10;
                        if (var9_9 >= var3_3) break;
                        ++var6_6;
                        break;
                    }
                    ++var9_9;
                }
                if (var9_9 > var3_3) {
                    var1_1[var2_2++] = var8_8;
                }
            } else {
                var1_1[var2_2++] = var8_8;
            }
            ++var7_7;
        }
        return var6_6;
    }

    private static boolean isStopRequested(int n) {
        return n == 32 || n == 9 || n == 10 || n == 13 || n == 12;
    }

    private boolean length(int n) {
        return LexBase.isStopRequested(n) || n == 38 || n == 60 || n == 34 || n == 39 || n == 40 || n == 41;
    }

    private static int lexerNestingLevel(char[] cArray, int n, int n2) {
        int n3 = n;
        int n4 = -2;
        int n5 = n;
        while (n5 < n2) {
            int n6 = cArray[n5];
            if (n6 == 12) {
                n6 = 10;
            } else if (n6 == 13) {
                n6 = 10;
                n4 = n5;
            }
            if (!(n6 == 10 && n5 == n || n6 == 10 && n4 + 1 == n5)) {
                cArray[n3] = (char)n6;
                ++n3;
            }
            ++n5;
        }
        return n3;
    }

    private int lexerState(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = -1;
        int n7 = -1;
        int n8 = n;
        while (n8 != n2) {
            n5 = cArray[n8];
            ++n8;
            if (n5 != 38) continue;
            n4 = n2;
            n3 = n8;
            while (n3 != n2) {
                n5 = cArray[n3];
                if (n5 == 59) {
                    n4 = n3++;
                    break;
                }
                if (this.length(n5)) {
                    n4 = n3;
                    break;
                }
                ++n3;
            }
            n7 = this.lexer_eof(cArray, n8, n4 - n8);
            if (n7 < 0) continue;
            n6 = n8 - 1;
            n8 = n3;
            break;
        }
        if (n7 >= 0) {
            cArray[n6] = (char)n7;
            ++n6;
            while (n8 != n2) {
                n5 = cArray[n8];
                ++n8;
                if (n5 == 38) {
                    n4 = n2;
                    n3 = n8;
                    while (n3 != n2) {
                        n5 = cArray[n3];
                        if (n5 == 59) {
                            n4 = n3++;
                            break;
                        }
                        if (this.length(n5)) {
                            n4 = n3;
                            break;
                        }
                        ++n3;
                    }
                    n5 = this.lexer_eof(cArray, n8, n4 - n8);
                    if (n5 < 0) {
                        n5 = 38;
                    } else {
                        n8 = n3;
                    }
                }
                cArray[n6] = (char)n5;
                ++n6;
            }
            n2 = n6;
        }
        return n2;
    }

    private int lexer_eof(char[] cArray, int n, int n2) {
        int n3 = -1;
        if (n2 >= 2) {
            if (cArray[n] != '#') {
                n3 = LexBase.mark(cArray, n, n2);
            } else {
                char c;
                --n2;
                int n4 = 10;
                if ((c = cArray[++n]) == 'X' || c == 'x') {
                    n4 = 16;
                    ++n;
                    --n2;
                }
                String string = new String(cArray, n, n2);
                try {
                    n3 = Integer.parseInt(string, n4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (128 <= n3 && n3 <= 159) {
                    n3 = LexBase.lineNumber(n3);
                } else if (n3 == 9) {
                    n3 = 32;
                }
            }
        }
        return n3;
    }

    private static int lineNumber(int n) {
        String string = "\u20ac\u0081\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\u0160\u2039\u0152\u008d\u017d\u008f\u0090\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\u0161\u203a\u0153\u009d\u017e\u0178";
        return string.charAt(n - 128);
    }

    private static int mark(char[] cArray, int n, int n2) {
        block0 : switch (n2) {
            case 2: {
                char c = cArray[n + 1];
                switch (cArray[n]) {
                    case 'M': {
                        if (c != 'u') break block0;
                        return 924;
                    }
                    case 'N': {
                        if (c != 'u') break block0;
                        return 925;
                    }
                    case 'P': {
                        if (c != 'i') break block0;
                        return 928;
                    }
                    case 'X': {
                        if (c != 'i') break block0;
                        return 926;
                    }
                    case 'g': {
                        if (c == 'e') {
                            return 8805;
                        }
                        if (c != 't') break block0;
                        return 62;
                    }
                    case 'l': {
                        if (c == 'e') {
                            return 8804;
                        }
                        if (c != 't') break block0;
                        return 60;
                    }
                    case 'm': {
                        if (c != 'u') break block0;
                        return 956;
                    }
                    case 'n': {
                        if (c == 'e') {
                            return 8800;
                        }
                        if (c == 'i') {
                            return 8715;
                        }
                        if (c != 'u') break block0;
                        return 957;
                    }
                    case 'o': {
                        if (c != 'r') break block0;
                        return 8744;
                    }
                    case 'p': {
                        if (c != 'i') break block0;
                        return 960;
                    }
                    case 'x': {
                        if (c != 'i') break block0;
                        return 958;
                    }
                }
                break;
            }
            case 3: {
                char c = cArray[n + 1];
                char c2 = cArray[n + 2];
                switch (cArray[n]) {
                    case 'C': {
                        if (0 != (c ^ 0x68 | c2 ^ 0x69)) break block0;
                        return 935;
                    }
                    case 'E': {
                        if (c == 'T') {
                            if (c2 != 'H') break block0;
                            return 208;
                        }
                        if (c != 't' || c2 != 'a') break block0;
                        return 919;
                    }
                    case 'P': {
                        if (c2 != 'i') break block0;
                        if (c == 'h') {
                            return 934;
                        }
                        if (c != 's') break block0;
                        return 936;
                    }
                    case 'R': {
                        if (0 != (c ^ 0x68 | c2 ^ 0x6F)) break block0;
                        return 929;
                    }
                    case 'T': {
                        if (0 != (c ^ 0x61 | c2 ^ 0x75)) break block0;
                        return 932;
                    }
                    case 'a': {
                        if (c2 == 'p') {
                            if (c != 'm') break block0;
                            return 38;
                        }
                        if (c2 == 'd') {
                            if (c != 'n') break block0;
                            return 8743;
                        }
                        if (c2 != 'g' || c != 'n') break block0;
                        return 8736;
                    }
                    case 'c': {
                        if (c == 'a') {
                            if (c2 != 'p') break block0;
                            return 8745;
                        }
                        if (c == 'h') {
                            if (c2 != 'i') break block0;
                            return 967;
                        }
                        if (c != 'u' || c2 != 'p') break block0;
                        return 8746;
                    }
                    case 'd': {
                        if (0 != (c ^ 0x65 | c2 ^ 0x67)) break block0;
                        return 176;
                    }
                    case 'e': {
                        if (c != 't') break block0;
                        if (c2 == 'a') {
                            return 951;
                        }
                        if (c2 != 'h') break block0;
                        return 240;
                    }
                    case 'i': {
                        if (0 != (c ^ 0x6E | c2 ^ 0x74)) break block0;
                        return 8747;
                    }
                    case 'l': {
                        if (c == 'o') {
                            if (c2 != 'z') break block0;
                            return 9674;
                        }
                        if (c != 'r' || c2 != 'm') break block0;
                        return 8206;
                    }
                    case 'n': {
                        if (0 != (c ^ 0x6F | c2 ^ 0x74)) break block0;
                        return 172;
                    }
                    case 'p': {
                        if (c == 'h') {
                            if (c2 != 'i') break block0;
                            return 966;
                        }
                        if (c == 'i') {
                            if (c2 != 'v') break block0;
                            return 982;
                        }
                        if (c != 's' || c2 != 'i') break block0;
                        return 968;
                    }
                    case 'r': {
                        if (c == 'e') {
                            if (c2 != 'g') break block0;
                            return 174;
                        }
                        if (c == 'h') {
                            if (c2 != 'o') break block0;
                            return 961;
                        }
                        if (c != 'l' || c2 != 'm') break block0;
                        return 8207;
                    }
                    case 's': {
                        if (c == 'h') {
                            if (c2 != 'y') break block0;
                            return 173;
                        }
                        if (c == 'i') {
                            if (c2 != 'm') break block0;
                            return 8764;
                        }
                        if (c != 'u') break block0;
                        if (c2 == 'b') {
                            return 8834;
                        }
                        if (c2 == 'm') {
                            return 8721;
                        }
                        if (c2 != 'p') break block0;
                        return 8835;
                    }
                    case 't': {
                        if (0 != (c ^ 0x61 | c2 ^ 0x75)) break block0;
                        return 964;
                    }
                    case 'u': {
                        if (0 != (c ^ 0x6D | c2 ^ 0x6C)) break block0;
                        return 168;
                    }
                    case 'y': {
                        if (0 != (c ^ 0x65 | c2 ^ 0x6E)) break block0;
                        return 165;
                    }
                    case 'z': {
                        if (0 != (c ^ 0x77 | c2 ^ 0x6A)) break block0;
                        return 8205;
                    }
                }
                break;
            }
            case 4: {
                char c = cArray[n + 1];
                char c3 = cArray[n + 2];
                char c4 = cArray[n + 3];
                switch (cArray[n]) {
                    case 'A': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 196;
                    }
                    case 'B': {
                        if (0 != (c ^ 0x65 | c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                        return 914;
                    }
                    case 'E': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 203;
                    }
                    case 'I': {
                        if (c == 'o') {
                            if (0 != (c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                            return 921;
                        }
                        if (c != 'u' || 0 != (c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 207;
                    }
                    case 'O': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 214;
                    }
                    case 'U': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 220;
                    }
                    case 'Y': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 376;
                    }
                    case 'Z': {
                        if (0 != (c ^ 0x65 | c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                        return 918;
                    }
                    case 'a': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 228;
                    }
                    case 'b': {
                        if (c == 'e') {
                            if (0 != (c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                            return 946;
                        }
                        if (c != 'u' || 0 != (c3 ^ 0x6C | c4 ^ 0x6C)) break block0;
                        return 8226;
                    }
                    case 'c': {
                        switch (c4) {
                            case 't': {
                                if (0 != (c ^ 0x65 | c3 ^ 0x6E)) break block0;
                                return 162;
                            }
                            case 'c': {
                                if (0 != (c ^ 0x69 | c3 ^ 0x72)) break block0;
                                return 710;
                            }
                            case 'g': {
                                if (0 != (c ^ 0x6F | c3 ^ 0x6E)) break block0;
                                return 8773;
                            }
                            case 'y': {
                                if (0 != (c ^ 0x6F | c3 ^ 0x70)) break block0;
                                return 169;
                            }
                        }
                        break block0;
                    }
                    case 'd': {
                        if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) break block0;
                        if (c == 'A') {
                            return 8659;
                        }
                        if (c != 'a') break block0;
                        return 8595;
                    }
                    case 'e': {
                        if (c == 'm') {
                            if (0 != (c3 ^ 0x73 | c4 ^ 0x70)) break block0;
                            return 8195;
                        }
                        if (c == 'n') {
                            if (0 != (c3 ^ 0x73 | c4 ^ 0x70)) break block0;
                            return 8194;
                        }
                        if (c != 'u') break block0;
                        if (c3 == 'm') {
                            if (c4 != 'l') break block0;
                            return 235;
                        }
                        if (c3 != 'r' || c4 != 'o') break block0;
                        return 8364;
                    }
                    case 'f': {
                        if (0 != (c ^ 0x6E | c3 ^ 0x6F | c4 ^ 0x66)) break block0;
                        return 402;
                    }
                    case 'h': {
                        if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) break block0;
                        if (c == 'A') {
                            return 8660;
                        }
                        if (c != 'a') break block0;
                        return 8596;
                    }
                    case 'i': {
                        if (c == 'o') {
                            if (0 != (c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                            return 953;
                        }
                        if (c == 's') {
                            if (0 != (c3 ^ 0x69 | c4 ^ 0x6E)) break block0;
                            return 8712;
                        }
                        if (c != 'u' || 0 != (c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 239;
                    }
                    case 'l': {
                        if (c4 == 'r') {
                            if (c3 != 'r') break block0;
                            if (c == 'A') {
                                return 8656;
                            }
                            if (c != 'a') break block0;
                            return 8592;
                        }
                        if (c4 != 'g' || 0 != (c ^ 0x61 | c3 ^ 0x6E)) break block0;
                        return 9001;
                    }
                    case 'm': {
                        if (0 != (c ^ 0x61 | c3 ^ 0x63 | c4 ^ 0x72)) break block0;
                        return 175;
                    }
                    case 'n': {
                        if (c == 'b') {
                            if (0 != (c3 ^ 0x73 | c4 ^ 0x70)) break block0;
                            return 160;
                        }
                        if (c != 's' || 0 != (c3 ^ 0x75 | c4 ^ 0x62)) break block0;
                        return 8836;
                    }
                    case 'o': {
                        if (c4 == 'f') {
                            if (0 != (c ^ 0x72 | c3 ^ 0x64)) break block0;
                            return 170;
                        }
                        if (c4 == 'l') {
                            if (0 != (c ^ 0x75 | c3 ^ 0x6D)) break block0;
                            return 246;
                        }
                        if (c4 != 'm' || 0 != (c ^ 0x72 | c3 ^ 0x64)) break block0;
                        return 186;
                    }
                    case 'p': {
                        if (c == 'a') {
                            if (c3 != 'r') break block0;
                            if (c4 == 'a') {
                                return 182;
                            }
                            if (c4 != 't') break block0;
                            return 8706;
                        }
                        if (c == 'e') {
                            if (0 != (c3 ^ 0x72 | c4 ^ 0x70)) break block0;
                            return 8869;
                        }
                        if (c != 'r' || c3 != 'o') break block0;
                        if (c4 == 'd') {
                            return 8719;
                        }
                        if (c4 != 'p') break block0;
                        return 8733;
                    }
                    case 'q': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6F | c4 ^ 0x74)) break block0;
                        return 34;
                    }
                    case 'r': {
                        if (c == 'A') {
                            if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) break block0;
                            return 8658;
                        }
                        if (c == 'a') {
                            if (c3 == 'n') {
                                if (c4 != 'g') break block0;
                                return 9002;
                            }
                            if (c3 != 'r' || c4 != 'r') break block0;
                            return 8594;
                        }
                        if (c != 'e' || 0 != (c3 ^ 0x61 | c4 ^ 0x6C)) break block0;
                        return 8476;
                    }
                    case 's': {
                        switch (c3) {
                            case 'o': {
                                if (0 != (c ^ 0x64 | c4 ^ 0x74)) break block0;
                                return 8901;
                            }
                            case 'c': {
                                if (0 != (c ^ 0x65 | c4 ^ 0x74)) break block0;
                                return 167;
                            }
                            case 'b': {
                                if (0 != (c ^ 0x75 | c4 ^ 0x65)) break block0;
                                return 8838;
                            }
                            case 'p': {
                                if (c != 'u') break block0;
                                switch (c4) {
                                    case '1': {
                                        return 185;
                                    }
                                    case '2': {
                                        return 178;
                                    }
                                    case '3': {
                                        return 179;
                                    }
                                    case 'e': {
                                        return 8839;
                                    }
                                }
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 'u': {
                        if (c == 'A') {
                            if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) break block0;
                            return 8657;
                        }
                        if (c == 'a') {
                            if (0 != (c3 ^ 0x72 | c4 ^ 0x72)) break block0;
                            return 8593;
                        }
                        if (c != 'u' || 0 != (c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 252;
                    }
                    case 'y': {
                        if (0 != (c ^ 0x75 | c3 ^ 0x6D | c4 ^ 0x6C)) break block0;
                        return 255;
                    }
                    case 'z': {
                        if (c == 'e') {
                            if (0 != (c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                            return 950;
                        }
                        if (c != 'w' || 0 != (c3 ^ 0x6E | c4 ^ 0x6A)) break block0;
                        return 8204;
                    }
                }
                break;
            }
            case 5: {
                char c = cArray[n + 1];
                char c5 = cArray[n + 2];
                char c6 = cArray[n + 3];
                char c7 = cArray[n + 4];
                switch (cArray[n]) {
                    case 'A': {
                        switch (c) {
                            case 'E': {
                                if (0 != (c5 ^ 0x6C | c6 ^ 0x69 | c7 ^ 0x67)) break block0;
                                return 198;
                            }
                            case 'c': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                                return 194;
                            }
                            case 'l': {
                                if (0 != (c5 ^ 0x70 | c6 ^ 0x68 | c7 ^ 0x61)) break block0;
                                return 913;
                            }
                            case 'r': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x6E | c7 ^ 0x67)) break block0;
                                return 197;
                            }
                        }
                        break block0;
                    }
                    case 'D': {
                        if (0 != (c ^ 0x65 | c5 ^ 0x6C | c6 ^ 0x74 | c7 ^ 0x61)) break block0;
                        return 916;
                    }
                    case 'E': {
                        if (0 != (c ^ 0x63 | c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                        return 202;
                    }
                    case 'G': {
                        if (0 != (c ^ 0x61 | c5 ^ 0x6D | c6 ^ 0x6D | c7 ^ 0x61)) break block0;
                        return 915;
                    }
                    case 'I': {
                        if (0 != (c ^ 0x63 | c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                        return 206;
                    }
                    case 'K': {
                        if (0 != (c ^ 0x61 | c5 ^ 0x70 | c6 ^ 0x70 | c7 ^ 0x61)) break block0;
                        return 922;
                    }
                    case 'O': {
                        if (c == 'E') {
                            if (0 != (c5 ^ 0x6C | c6 ^ 0x69 | c7 ^ 0x67)) break block0;
                            return 338;
                        }
                        if (c == 'c') {
                            if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                            return 212;
                        }
                        if (c != 'm' || 0 != (c5 ^ 0x65 | c6 ^ 0x67 | c7 ^ 0x61)) break block0;
                        return 937;
                    }
                    case 'P': {
                        if (0 != (c ^ 0x72 | c5 ^ 0x69 | c6 ^ 0x6D | c7 ^ 0x65)) break block0;
                        return 8243;
                    }
                    case 'S': {
                        if (0 != (c ^ 0x69 | c5 ^ 0x67 | c6 ^ 0x6D | c7 ^ 0x61)) break block0;
                        return 931;
                    }
                    case 'T': {
                        if (c == 'H') {
                            if (0 != (c5 ^ 0x4F | c6 ^ 0x52 | c7 ^ 0x4E)) break block0;
                            return 222;
                        }
                        if (c != 'h' || 0 != (c5 ^ 0x65 | c6 ^ 0x74 | c7 ^ 0x61)) break block0;
                        return 920;
                    }
                    case 'U': {
                        if (0 != (c ^ 0x63 | c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                        return 219;
                    }
                    case 'a': {
                        switch (c6) {
                            case 'i': {
                                if (0 != (c ^ 0x65 | c5 ^ 0x6C | c7 ^ 0x67)) break block0;
                                return 230;
                            }
                            case 'h': {
                                if (0 != (c ^ 0x6C | c5 ^ 0x70 | c7 ^ 0x61)) break block0;
                                return 945;
                            }
                            case 'n': {
                                if (0 != (c ^ 0x72 | c5 ^ 0x69 | c7 ^ 0x67)) break block0;
                                return 229;
                            }
                            case 'r': {
                                if (0 != (c ^ 0x63 | c5 ^ 0x69 | c7 ^ 0x63)) break block0;
                                return 226;
                            }
                            case 'm': {
                                if (0 != (c ^ 0x73 | c5 ^ 0x79 | c7 ^ 0x70)) break block0;
                                return 8776;
                            }
                            case 't': {
                                if (0 != (c ^ 0x63 | c5 ^ 0x75 | c7 ^ 0x65)) break block0;
                                return 180;
                            }
                        }
                        break block0;
                    }
                    case 'b': {
                        if (0 != (c ^ 0x64 | c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) break block0;
                        return 8222;
                    }
                    case 'c': {
                        if (c == 'e') {
                            if (0 != (c5 ^ 0x64 | c6 ^ 0x69 | c7 ^ 0x6C)) break block0;
                            return 184;
                        }
                        if (c == 'l') {
                            if (0 != (c5 ^ 0x75 | c6 ^ 0x62 | c7 ^ 0x73)) break block0;
                            return 9827;
                        }
                        if (c != 'r' || 0 != (c5 ^ 0x61 | c6 ^ 0x72 | c7 ^ 0x72)) break block0;
                        return 8629;
                    }
                    case 'd': {
                        if (c == 'e' && 0 == (c5 ^ 0x6C | c6 ^ 0x74 | c7 ^ 0x61)) {
                            return 948;
                        }
                        if (c != 'i' || 0 != (c5 ^ 0x61 | c6 ^ 0x6D | c7 ^ 0x73)) break block0;
                        return 9830;
                    }
                    case 'e': {
                        switch (c) {
                            case 'c': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                                return 234;
                            }
                            case 'm': {
                                if (0 != (c5 ^ 0x70 | c6 ^ 0x74 | c7 ^ 0x79)) break block0;
                                return 8709;
                            }
                            case 'q': {
                                if (0 != (c5 ^ 0x75 | c6 ^ 0x69 | c7 ^ 0x76)) break block0;
                                return 8801;
                            }
                            case 'x': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x73 | c7 ^ 0x74)) break block0;
                                return 8707;
                            }
                        }
                        break block0;
                    }
                    case 'f': {
                        if (0 != (c ^ 0x72 | c5 ^ 0x61 | c6 ^ 0x73 | c7 ^ 0x6C)) break block0;
                        return 8260;
                    }
                    case 'g': {
                        if (0 != (c ^ 0x61 | c5 ^ 0x6D | c6 ^ 0x6D | c7 ^ 0x61)) break block0;
                        return 947;
                    }
                    case 'i': {
                        switch (c) {
                            case 'c': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                                return 238;
                            }
                            case 'e': {
                                if (0 != (c5 ^ 0x78 | c6 ^ 0x63 | c7 ^ 0x6C)) break block0;
                                return 161;
                            }
                            case 'm': {
                                if (0 != (c5 ^ 0x61 | c6 ^ 0x67 | c7 ^ 0x65)) break block0;
                                return 8465;
                            }
                            case 'n': {
                                if (0 != (c5 ^ 0x66 | c6 ^ 0x69 | c7 ^ 0x6E)) break block0;
                                return 8734;
                            }
                        }
                        break block0;
                    }
                    case 'k': {
                        if (0 != (c ^ 0x61 | c5 ^ 0x70 | c6 ^ 0x70 | c7 ^ 0x61)) break block0;
                        return 954;
                    }
                    case 'l': {
                        switch (c) {
                            case 'a': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) break block0;
                                return 171;
                            }
                            case 'c': {
                                if (0 != (c5 ^ 0x65 | c6 ^ 0x69 | c7 ^ 0x6C)) break block0;
                                return 8968;
                            }
                            case 'd': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) break block0;
                                return 8220;
                            }
                            case 's': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) break block0;
                                return 8216;
                            }
                        }
                        break block0;
                    }
                    case 'm': {
                        if (c5 == 'a') {
                            if (0 != (c ^ 0x64 | c6 ^ 0x73 | c7 ^ 0x68)) break block0;
                            return 8212;
                        }
                        if (c5 == 'c') {
                            if (0 != (c ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x6F)) break block0;
                            return 181;
                        }
                        if (c5 != 'n' || 0 != (c ^ 0x69 | c6 ^ 0x75 | c7 ^ 0x73)) break block0;
                        return 8722;
                    }
                    case 'n': {
                        if (c == 'a') {
                            if (0 != (c5 ^ 0x62 | c6 ^ 0x6C | c7 ^ 0x61)) break block0;
                            return 8711;
                        }
                        if (c == 'd') {
                            if (0 != (c5 ^ 0x61 | c6 ^ 0x73 | c7 ^ 0x68)) break block0;
                            return 8211;
                        }
                        if (c != 'o' || 0 != (c5 ^ 0x74 | c6 ^ 0x69 | c7 ^ 0x6E)) break block0;
                        return 8713;
                    }
                    case 'o': {
                        switch (c) {
                            case 'c': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                                return 244;
                            }
                            case 'e': {
                                if (0 != (c5 ^ 0x6C | c6 ^ 0x69 | c7 ^ 0x67)) break block0;
                                return 339;
                            }
                            case 'l': {
                                if (0 != (c5 ^ 0x69 | c6 ^ 0x6E | c7 ^ 0x65)) break block0;
                                return 8254;
                            }
                            case 'm': {
                                if (0 != (c5 ^ 0x65 | c6 ^ 0x67 | c7 ^ 0x61)) break block0;
                                return 969;
                            }
                            case 'p': {
                                if (0 != (c5 ^ 0x6C | c6 ^ 0x75 | c7 ^ 0x73)) break block0;
                                return 8853;
                            }
                        }
                        break block0;
                    }
                    case 'p': {
                        if (c == 'o') {
                            if (0 != (c5 ^ 0x75 | c6 ^ 0x6E | c7 ^ 0x64)) break block0;
                            return 163;
                        }
                        if (c != 'r' || 0 != (c5 ^ 0x69 | c6 ^ 0x6D | c7 ^ 0x65)) break block0;
                        return 8242;
                    }
                    case 'r': {
                        switch (c) {
                            case 'a': {
                                if (c5 == 'q') {
                                    if (0 != (c6 ^ 0x75 | c7 ^ 0x6F)) break block0;
                                    return 187;
                                }
                                if (c5 != 'd' || 0 != (c6 ^ 0x69 | c7 ^ 0x63)) break block0;
                                return 8730;
                            }
                            case 'c': {
                                if (0 != (c5 ^ 0x65 | c6 ^ 0x69 | c7 ^ 0x6C)) break block0;
                                return 8969;
                            }
                            case 'd': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) break block0;
                                return 8221;
                            }
                            case 's': {
                                if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) break block0;
                                return 8217;
                            }
                        }
                        break block0;
                    }
                    case 's': {
                        if (c == 'b') {
                            if (0 != (c5 ^ 0x71 | c6 ^ 0x75 | c7 ^ 0x6F)) break block0;
                            return 8218;
                        }
                        if (c == 'i') {
                            if (0 != (c5 ^ 0x67 | c6 ^ 0x6D | c7 ^ 0x61)) break block0;
                            return 963;
                        }
                        if (c != 'z' || 0 != (c5 ^ 0x6C | c6 ^ 0x69 | c7 ^ 0x67)) break block0;
                        return 223;
                    }
                    case 't': {
                        switch (c5) {
                            case 'e': {
                                if (0 != (c ^ 0x68 | c6 ^ 0x74 | c7 ^ 0x61)) break block0;
                                return 952;
                            }
                            case 'o': {
                                if (0 != (c ^ 0x68 | c6 ^ 0x72 | c7 ^ 0x6E)) break block0;
                                return 254;
                            }
                            case 'l': {
                                if (0 != (c ^ 0x69 | c6 ^ 0x64 | c7 ^ 0x65)) break block0;
                                return 732;
                            }
                            case 'm': {
                                if (0 != (c ^ 0x69 | c6 ^ 0x65 | c7 ^ 0x73)) break block0;
                                return 215;
                            }
                            case 'a': {
                                if (0 != (c ^ 0x72 | c6 ^ 0x64 | c7 ^ 0x65)) break block0;
                                return 8482;
                            }
                        }
                        break block0;
                    }
                    case 'u': {
                        if (c == 'c') {
                            if (0 != (c5 ^ 0x69 | c6 ^ 0x72 | c7 ^ 0x63)) break block0;
                            return 251;
                        }
                        if (c != 'p' || 0 != (c5 ^ 0x73 | c6 ^ 0x69 | c7 ^ 0x68)) break block0;
                        return 978;
                    }
                }
                break;
            }
            case 6: {
                char c = cArray[n + 1];
                char c8 = cArray[n + 2];
                char c9 = cArray[n + 3];
                char c10 = cArray[n + 4];
                char c11 = cArray[n + 5];
                switch (cArray[n]) {
                    case 'A': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                            return 193;
                        }
                        if (c == 'g') {
                            if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                            return 192;
                        }
                        if (c != 't' || 0 != (c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) break block0;
                        return 195;
                    }
                    case 'C': {
                        if (0 != (c ^ 0x63 | c8 ^ 0x65 | c9 ^ 0x64 | c10 ^ 0x69 | c11 ^ 0x6C)) break block0;
                        return 199;
                    }
                    case 'D': {
                        if (0 != (c ^ 0x61 | c8 ^ 0x67 | c9 ^ 0x67 | c10 ^ 0x65 | c11 ^ 0x72)) break block0;
                        return 8225;
                    }
                    case 'E': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                            return 201;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                        return 200;
                    }
                    case 'I': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                            return 205;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                        return 204;
                    }
                    case 'L': {
                        if (0 != (c ^ 0x61 | c8 ^ 0x6D | c9 ^ 0x62 | c10 ^ 0x64 | c11 ^ 0x61)) break block0;
                        return 923;
                    }
                    case 'N': {
                        if (0 != (c ^ 0x74 | c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) break block0;
                        return 209;
                    }
                    case 'O': {
                        switch (c) {
                            case 'a': {
                                if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                                return 211;
                            }
                            case 'g': {
                                if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                                return 210;
                            }
                            case 's': {
                                if (0 != (c8 ^ 0x6C | c9 ^ 0x61 | c10 ^ 0x73 | c11 ^ 0x68)) break block0;
                                return 216;
                            }
                            case 't': {
                                if (0 != (c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) break block0;
                                return 213;
                            }
                        }
                        break block0;
                    }
                    case 'S': {
                        if (0 != (c ^ 0x63 | c8 ^ 0x61 | c9 ^ 0x72 | c10 ^ 0x6F | c11 ^ 0x6E)) break block0;
                        return 352;
                    }
                    case 'U': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                            return 218;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                        return 217;
                    }
                    case 'Y': {
                        if (0 != (c ^ 0x61 | c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                        return 221;
                    }
                    case 'a': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                            return 225;
                        }
                        if (c == 'g') {
                            if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                            return 224;
                        }
                        if (c != 't' || 0 != (c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) break block0;
                        return 227;
                    }
                    case 'b': {
                        if (0 != (c ^ 0x72 | c8 ^ 0x76 | c9 ^ 0x62 | c10 ^ 0x61 | c11 ^ 0x72)) break block0;
                        return 166;
                    }
                    case 'c': {
                        if (c == 'c') {
                            if (0 != (c8 ^ 0x65 | c9 ^ 0x64 | c10 ^ 0x69 | c11 ^ 0x6C)) break block0;
                            return 231;
                        }
                        if (c != 'u' || 0 != (c8 ^ 0x72 | c9 ^ 0x72 | c10 ^ 0x65 | c11 ^ 0x6E)) break block0;
                        return 164;
                    }
                    case 'd': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x67 | c9 ^ 0x67 | c10 ^ 0x65 | c11 ^ 0x72)) break block0;
                            return 8224;
                        }
                        if (c != 'i' || 0 != (c8 ^ 0x76 | c9 ^ 0x69 | c10 ^ 0x64 | c11 ^ 0x65)) break block0;
                        return 247;
                    }
                    case 'e': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                            return 233;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                        return 232;
                    }
                    case 'f': {
                        if (c11 == 'l') {
                            if (0 != (c ^ 0x6F | c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x6C)) break block0;
                            return 8704;
                        }
                        if (c11 == '2') {
                            if (0 != (c ^ 0x72 | c8 ^ 0x61 | c9 ^ 0x63 | c10 ^ 0x31)) break block0;
                            return 189;
                        }
                        if (c11 != '4' || 0 != (c ^ 0x72 | c8 ^ 0x61 | c9 ^ 0x63)) break block0;
                        if (c10 == '1') {
                            return 188;
                        }
                        if (c10 != '3') break block0;
                        return 190;
                    }
                    case 'h': {
                        if (c8 == 'a') {
                            if (0 != (c ^ 0x65 | c9 ^ 0x72 | c10 ^ 0x74 | c11 ^ 0x73)) break block0;
                            return 9829;
                        }
                        if (c8 != 'l' || 0 != (c ^ 0x65 | c9 ^ 0x6C | c10 ^ 0x69 | c11 ^ 0x70)) break block0;
                        return 8230;
                    }
                    case 'i': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                            return 237;
                        }
                        if (c == 'g') {
                            if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                            return 236;
                        }
                        if (c != 'q' || 0 != (c8 ^ 0x75 | c9 ^ 0x65 | c10 ^ 0x73 | c11 ^ 0x74)) break block0;
                        return 191;
                    }
                    case 'l': {
                        switch (c) {
                            case 'a': {
                                if (0 != (c8 ^ 0x6D | c9 ^ 0x62 | c10 ^ 0x64 | c11 ^ 0x61)) break block0;
                                return 955;
                            }
                            case 'f': {
                                if (0 != (c8 ^ 0x6C | c9 ^ 0x6F | c10 ^ 0x6F | c11 ^ 0x72)) break block0;
                                return 8970;
                            }
                            case 'o': {
                                if (0 != (c8 ^ 0x77 | c9 ^ 0x61 | c10 ^ 0x73 | c11 ^ 0x74)) break block0;
                                return 8727;
                            }
                            case 's': {
                                if (0 != (c8 ^ 0x61 | c9 ^ 0x71 | c10 ^ 0x75 | c11 ^ 0x6F)) break block0;
                                return 8249;
                            }
                        }
                        break block0;
                    }
                    case 'm': {
                        if (0 != (c ^ 0x69 | c8 ^ 0x64 | c9 ^ 0x64 | c10 ^ 0x6F | c11 ^ 0x74)) break block0;
                        return 183;
                    }
                    case 'n': {
                        if (0 != (c ^ 0x74 | c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64 | c11 ^ 0x65)) break block0;
                        return 241;
                    }
                    case 'o': {
                        switch (c) {
                            case 'a': {
                                if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                                return 243;
                            }
                            case 'g': {
                                if (0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                                return 242;
                            }
                            case 's': {
                                if (0 != (c8 ^ 0x6C | c9 ^ 0x61 | c10 ^ 0x73 | c11 ^ 0x68)) break block0;
                                return 248;
                            }
                            case 't': {
                                if (c11 == 'e') {
                                    if (0 != (c8 ^ 0x69 | c9 ^ 0x6C | c10 ^ 0x64)) break block0;
                                    return 245;
                                }
                                if (c11 != 's' || 0 != (c8 ^ 0x69 | c9 ^ 0x6D | c10 ^ 0x65)) break block0;
                                return 8855;
                            }
                        }
                        break block0;
                    }
                    case 'p': {
                        if (c == 'e') {
                            if (0 != (c8 ^ 0x72 | c9 ^ 0x6D | c10 ^ 0x69 | c11 ^ 0x6C)) break block0;
                            return 8240;
                        }
                        if (c != 'l' || 0 != (c8 ^ 0x75 | c9 ^ 0x73 | c10 ^ 0x6D | c11 ^ 0x6E)) break block0;
                        return 177;
                    }
                    case 'r': {
                        if (c == 'f') {
                            if (0 != (c8 ^ 0x6C | c9 ^ 0x6F | c10 ^ 0x6F | c11 ^ 0x72)) break block0;
                            return 8971;
                        }
                        if (c != 's' || 0 != (c8 ^ 0x61 | c9 ^ 0x71 | c10 ^ 0x75 | c11 ^ 0x6F)) break block0;
                        return 8250;
                    }
                    case 's': {
                        if (c == 'c') {
                            if (0 != (c8 ^ 0x61 | c9 ^ 0x72 | c10 ^ 0x6F | c11 ^ 0x6E)) break block0;
                            return 353;
                        }
                        if (c == 'i') {
                            if (0 != (c8 ^ 0x67 | c9 ^ 0x6D | c10 ^ 0x61 | c11 ^ 0x66)) break block0;
                            return 962;
                        }
                        if (c != 'p' || 0 != (c8 ^ 0x61 | c9 ^ 0x64 | c10 ^ 0x65 | c11 ^ 0x73)) break block0;
                        return 9824;
                    }
                    case 't': {
                        if (c11 == '4') {
                            if (0 != (c ^ 0x68 | c8 ^ 0x65 | c9 ^ 0x72 | c10 ^ 0x65)) break block0;
                            return 8756;
                        }
                        if (c11 != 'p' || 0 != (c ^ 0x68 | c8 ^ 0x69 | c9 ^ 0x6E | c10 ^ 0x73)) break block0;
                        return 8201;
                    }
                    case 'u': {
                        if (c == 'a') {
                            if (0 != (c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                            return 250;
                        }
                        if (c != 'g' || 0 != (c8 ^ 0x72 | c9 ^ 0x61 | c10 ^ 0x76 | c11 ^ 0x65)) break block0;
                        return 249;
                    }
                    case 'w': {
                        if (0 != (c ^ 0x65 | c8 ^ 0x69 | c9 ^ 0x65 | c10 ^ 0x72 | c11 ^ 0x70)) break block0;
                        return 8472;
                    }
                    case 'y': {
                        if (0 != (c ^ 0x61 | c8 ^ 0x63 | c9 ^ 0x75 | c10 ^ 0x74 | c11 ^ 0x65)) break block0;
                        return 253;
                    }
                }
                break;
            }
            case 7: {
                char c = cArray[n + 1];
                char c12 = cArray[n + 2];
                char c13 = cArray[n + 3];
                char c14 = cArray[n + 4];
                char c15 = cArray[n + 5];
                char c16 = cArray[n + 6];
                switch (cArray[n]) {
                    case 'E': {
                        if (0 != (c ^ 0x70 | c12 ^ 0x73 | c13 ^ 0x69 | c14 ^ 0x6C | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 917;
                    }
                    case 'O': {
                        if (0 != (c ^ 0x6D | c12 ^ 0x69 | c13 ^ 0x63 | c14 ^ 0x72 | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 927;
                    }
                    case 'U': {
                        if (0 != (c ^ 0x70 | c12 ^ 0x73 | c13 ^ 0x69 | c14 ^ 0x6C | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 933;
                    }
                    case 'a': {
                        if (0 != (c ^ 0x6C | c12 ^ 0x65 | c13 ^ 0x66 | c14 ^ 0x73 | c15 ^ 0x79 | c16 ^ 0x6D)) break;
                        return 8501;
                    }
                    case 'e': {
                        if (0 != (c ^ 0x70 | c12 ^ 0x73 | c13 ^ 0x69 | c14 ^ 0x6C | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 949;
                    }
                    case 'o': {
                        if (0 != (c ^ 0x6D | c12 ^ 0x69 | c13 ^ 0x63 | c14 ^ 0x72 | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 959;
                    }
                    case 'u': {
                        if (0 != (c ^ 0x70 | c12 ^ 0x73 | c13 ^ 0x69 | c14 ^ 0x6C | c15 ^ 0x6F | c16 ^ 0x6E)) break;
                        return 965;
                    }
                }
                break;
            }
            case 8: {
                char c = cArray[n + 1];
                char c17 = cArray[n + 2];
                char c18 = cArray[n + 3];
                char c19 = cArray[n + 4];
                char c20 = cArray[n + 5];
                char c21 = cArray[n + 6];
                char c22 = cArray[n + 7];
                switch (cArray[n]) {
                    case 't': {
                        if (0 != (c ^ 0x68 | c17 ^ 0x65 | c18 ^ 0x74 | c19 ^ 0x61 | c20 ^ 0x73 | c21 ^ 0x79 | c22 ^ 0x6D)) break block0;
                        return 977;
                    }
                }
                break;
            }
        }
        return -1;
    }
}

