/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.FontProvider;
import ice.util.Defs;
import ice.util.alg.CharKit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class JavaFontProvider
implements FontProvider {
    protected String[] genericToJava = new String[]{"monospace", "Monospaced", "sansserif", "SansSerif", "sans-serif", "SansSerif", "helvetica", "SansSerif", "arial", "SansSerif", "serif", "Serif"};
    protected String[] allFamilies;
    protected Hashtable familyHash;

    public JavaFontProvider() {
        this.init();
    }

    public boolean isFamilySupported(String string) {
        String string2 = CharKit.toLowerCase((String)string);
        Integer n = (Integer)this.familyHash.get(string2);
        if (n != null) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.genericToJava.length) {
            if (this.genericToJava[n2].equalsIgnoreCase(string2)) {
                return true;
            }
            n2 += 2;
        }
        return false;
    }

    public String[] getFontFamilies() {
        return this.allFamilies;
    }

    public Font getFont(String string, int n, int n2) {
        String string2 = CharKit.toLowerCase((String)string);
        Integer n3 = (Integer)this.familyHash.get(string2);
        if (n3 != null) {
            return new Font(string2, n, n2);
        }
        int n4 = 0;
        while (n4 < this.genericToJava.length) {
            if (this.genericToJava[n4].equalsIgnoreCase(string2)) {
                return new Font(this.genericToJava[n4 + 1], n, n2);
            }
            n4 += 2;
        }
        throw new RuntimeException("Error in JavaFontProvider, has no Font implementation for: [" + string2 + "]");
    }

    protected void init() {
        int n;
        if (!this.initJava2Fonts()) {
            this.initJava1Fonts();
        }
        this.familyHash = new Hashtable();
        String string = Defs.sysProperty((String)"ice.pilots.html4.addonFontMapping");
        if (string != null) {
            n = 1;
            int n2 = string.indexOf(44);
            while (n2 > 0) {
                ++n;
                n2 = string.indexOf(44, n2 + 1);
            }
            String[] stringArray = new String[this.genericToJava.length + n];
            System.arraycopy(this.genericToJava, 0, stringArray, 0, this.genericToJava.length);
            int n3 = 0;
            n2 = string.indexOf(44);
            n = this.genericToJava.length;
            while (n2 > 0) {
                stringArray[n++] = CharKit.toLowerCase((String)string.substring(n3, n2).trim());
                n3 = n2 + 1;
                n2 = string.indexOf(44, n3);
            }
            stringArray[n] = CharKit.toLowerCase((String)string.substring(n3).trim());
            this.genericToJava = stringArray;
        }
        n = 0;
        while (n < this.allFamilies.length) {
            this.familyHash.put(CharKit.toLowerCase((String)this.allFamilies[n]), new Integer(n));
            ++n;
        }
    }

    protected void initJava1Fonts() {
        this.allFamilies = Toolkit.getDefaultToolkit().getFontList();
        String string = Defs.sysProperty((String)"ice.pilots.html4.addonFonts");
        if (string != null) {
            int n = 1;
            int n2 = string.indexOf(44);
            while (n2 > 0) {
                ++n;
                n2 = string.indexOf(44, n2 + 1);
            }
            String[] stringArray = new String[this.allFamilies.length + n];
            System.arraycopy(this.allFamilies, 0, stringArray, 0, this.allFamilies.length);
            int n3 = 0;
            n2 = string.indexOf(44);
            n = this.allFamilies.length;
            while (n2 > 0) {
                stringArray[n++] = string.substring(n3, n2).trim();
                n3 = n2 + 1;
                n2 = string.indexOf(44, n3);
            }
            stringArray[n] = string.substring(n3).trim();
            this.allFamilies = stringArray;
        }
    }

    protected boolean initJava2Fonts() {
        try {
            Class<?> clazz = Class.forName("java.awt.GraphicsEnvironment");
            Method method = clazz.getMethod("getLocalGraphicsEnvironment", null);
            Method method2 = clazz.getMethod("getAvailableFontFamilyNames", null);
            Object object = method.invoke(null, null);
            this.allFamilies = (String[])method2.invoke(object, null);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }
}

