/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.text;

import ice.pilots.text.ThePilot;
import ice.storm.print.AbstractStormPrinter;
import ice.storm.print.PageDecoration;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class ThePrinter
extends AbstractStormPrinter {
    private Vector DEFAULT_FONT_SIZE = new Vector();
    private ThePilot OEAB = null;
    private int abs = 0;
    private int append;
    private FontMetrics black;
    private int ceil;
    Font fonts = new Font("Arial", 0, 10);

    protected ThePrinter(ThePilot thePilot) {
        this.OEAB = thePilot;
        this.getPageCount();
    }

    public int getPageCount() {
        if (this.pageFormat == null) {
            throw new NullPointerException();
        }
        if (this.pageFormat.hasImageableAreaChanged()) {
            int n;
            this.fonts = ThePilot.getDefaultFont();
            if (this.fonts != null) {
                n = ThePilot.DEFAULT_FONT_SIZE;
                int n2 = n * (int)(this.pageFormat.getScale() * 256.0) >> 8;
                if (n2 < 4) {
                    n2 = 4;
                }
                this.fonts = new Font(this.fonts.getName(), this.fonts.getStyle(), n2);
            }
            this.black = Toolkit.getDefaultToolkit().getFontMetrics(this.fonts);
            this.abs = this.black.getAscent();
            this.ceil = this.black.charWidth(' ');
            this.append = (int)this.pageFormat.getImageableHeight() / this.abs;
            this.DEFAULT_FONT_SIZE = (Vector)this.OEAB.getLines().clone();
            if (this.pageFormat.isTextWrappingEnabled()) {
                n = 0;
                Enumeration enumeration = this.DEFAULT_FONT_SIZE.elements();
                while (enumeration.hasMoreElements() && (int)Math.ceil((double)this.DEFAULT_FONT_SIZE.size() / (double)this.append) < 2000) {
                    String string = (String)enumeration.nextElement();
                    int n3 = this.black.stringWidth(string);
                    if ((double)n3 > this.pageFormat.getImageableWidth()) {
                        this.DEFAULT_FONT_SIZE(this.DEFAULT_FONT_SIZE, string, n);
                    }
                    ++n;
                }
            }
            this.numberOfPages = (int)Math.ceil((double)this.DEFAULT_FONT_SIZE.size() / (double)this.append);
            this.currentPageIndex = -1;
            this.pageFormat.setImageableAreaChangedFlag(false);
        }
        return this.numberOfPages;
    }

    private void DEFAULT_FONT_SIZE(Vector vector, String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                n4 = this.ceil;
                n2 += n4;
                ++n3;
            } else {
                n4 = this.black.stringWidth(string2);
                n2 += n4;
                n3 += string2.length();
            }
            if (!((double)n2 > this.pageFormat.getImageableWidth()) || !((double)(n2 - n4) <= this.pageFormat.getImageableWidth())) continue;
            if ((double)n4 <= this.pageFormat.getImageableWidth()) {
                String string3 = string.substring(0, n3 - string2.length());
                String string4 = string.substring(n3 - string2.length(), string.length()).trim();
                vector.setElementAt(string3, n);
                vector.insertElementAt(string4, n + 1);
                continue;
            }
            int n5 = n2 - n4;
            int n6 = 0;
            while (n6 < string2.length() - 1) {
                if ((double)(n5 += this.black.stringWidth(string2.substring(n6, n6 + 1))) > this.pageFormat.getImageableWidth()) {
                    String string5 = string2.substring(0, n6);
                    String string6 = string2.substring(n6, string2.length()).trim();
                    vector.setElementAt(string5, n);
                    vector.setElementAt(string6 + " " + vector.elementAt(n + 1), n + 1);
                    continue block0;
                }
                ++n6;
            }
        }
    }

    public void printPage(Graphics graphics, int n) {
        Object object;
        if (n < 0) {
            n = 0;
        } else if (n > this.numberOfPages - 1) {
            n = this.numberOfPages - 1;
        }
        graphics.setColor(Color.black);
        graphics.setFont(this.fonts);
        Graphics graphics2 = graphics.create((int)this.pageFormat.getMargin(2), (int)this.pageFormat.getMargin(1), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        graphics2.translate(0, 0);
        graphics2.setClip(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        int n2 = this.black.getMaxAscent() - 3;
        int n3 = this.append * n;
        int n4 = n3 + this.append;
        int n5 = n3;
        while (n5 < this.DEFAULT_FONT_SIZE.size() && n5 < n4) {
            object = (String)this.DEFAULT_FONT_SIZE.elementAt(n5);
            graphics2.drawString((String)object, 0, n2);
            n2 += this.abs;
            ++n5;
        }
        graphics2.dispose();
        object = graphics.create(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        ((Graphics)object).translate(0, 0);
        ((Graphics)object).setClip(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        Vector vector = this.pageFormat.getDecoration();
        int n6 = vector.size() - 1;
        while (n6 >= 0) {
            PageDecoration pageDecoration = (PageDecoration)vector.elementAt(n6);
            pageDecoration.paint((Graphics)object, n, this.numberOfPages, this.pageFormat);
            --n6;
        }
        ((Graphics)object).dispose();
    }

    public void print(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.setFont(ThePilot.getDefaultFont());
        int n = this.abs;
        int n2 = 0;
        while (n2 < this.DEFAULT_FONT_SIZE.size()) {
            String string = (String)this.DEFAULT_FONT_SIZE.elementAt(n2);
            graphics.drawString(string, 0, n);
            n += this.abs;
            ++n2;
        }
    }

    public void setZoom(int n) {
        double d = (double)Math.abs(n) / 256.0;
        this.pageFormat.setScale(d);
        this.getPageCount();
    }

    public int getZoom() {
        return (int)(this.pageFormat.getScale() * 256.0);
    }

    public Dimension getDimension() {
        int n = (int)this.pageFormat.getImageableWidth();
        int n2 = this.abs * this.numberOfPages;
        return new Dimension(n, n2);
    }

    public void dispose() {
    }
}

