/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import java.io.FilePermission;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.Permission;

public final class ExecOptionPermission
extends Permission {
    private static final long serialVersionUID = 5842294756823092756L;
    private transient String prefix;
    private transient boolean plain;
    private transient Permission fp;

    public ExecOptionPermission(String string) {
        super(string);
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.init(string);
    }

    private void init(String string) {
        this.prefix = string;
        this.plain = true;
        int n = string.length() - 1;
        if (n >= 0) {
            int n2;
            char c = string.charAt(n);
            if (c == '\"' && n > 0 && string.charAt(0) == '\"') {
                this.prefix = string.substring(1, n);
            } else if (c == '*') {
                this.prefix = string.substring(0, n);
                this.plain = false;
            } else if (c == '}' && (n2 = string.lastIndexOf(123)) >= 0) {
                this.prefix = string.substring(0, n2);
                String string2 = string.substring(n2 + 1, n);
                if (!string2.equals("<<ALL FILES>>")) {
                    this.fp = new FilePermission(string2, "read");
                }
                this.plain = false;
            }
        }
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ExecOptionPermission)) {
            return false;
        }
        ExecOptionPermission execOptionPermission = (ExecOptionPermission)permission;
        if (this.plain) {
            return execOptionPermission.plain && this.prefix.equals(execOptionPermission.prefix);
        }
        if (this.fp == null) {
            return execOptionPermission.prefix.startsWith(this.prefix);
        }
        if (execOptionPermission.plain) {
            return execOptionPermission.prefix.startsWith(this.prefix) && this.fp.implies(new FilePermission(execOptionPermission.prefix.substring(this.prefix.length()), "read"));
        }
        return this.prefix.equals(execOptionPermission.prefix) && this.fp.implies(execOptionPermission.fp);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExecOptionPermission)) {
            return false;
        }
        ExecOptionPermission execOptionPermission = (ExecOptionPermission)object;
        return this.prefix.equals(execOptionPermission.prefix) && this.plain == execOptionPermission.plain && (this.fp == null ? execOptionPermission.fp == null : this.fp.equals(execOptionPermission.fp));
    }

    public int hashCode() {
        int n = this.prefix.hashCode();
        if (!this.plain) {
            n = this.fp != null ? (n += this.fp.hashCode()) : ++n;
        }
        return n;
    }

    public String getActions() {
        return "";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getName() == null) {
            throw new InvalidObjectException("name cannot be null");
        }
        this.init(this.getName());
    }
}

