/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.EncodingUtils;
import com.mathworks.html.HtmlSourceReader;
import com.mathworks.html.ResourceReferenceHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CopyResourceHandler
implements ResourceReferenceHandler {
    private static final Pattern BASE_URL_PATTERN = Pattern.compile("^(https?://[^/]+|file://)/?(.*/)?([^/]*)?$");
    private static final String[] RESOURCE_TYPES = new String[]{"gif", "jpe", "jpg", "png", "js", "css"};
    private static final Pattern RESOURCE_PATTERN = CopyResourceHandler.buildResourceAttributePattern();
    private final Map<String, String> fResourcesToCopy = new HashMap<String, String>();
    private final ResourceCopyStrategy fCopyStrategy;
    private final File fFileToSave;
    private File fResourceDir;

    public CopyResourceHandler(File file) {
        this(file, new DefaultCopyStrategy());
    }

    public CopyResourceHandler(File file, ResourceCopyStrategy resourceCopyStrategy) {
        this.fFileToSave = file;
        this.fCopyStrategy = resourceCopyStrategy;
    }

    private static Pattern buildResourceAttributePattern() {
        StringBuilder stringBuilder = new StringBuilder("<\\w+[^>]*\\s+(");
        stringBuilder.append("src=[\"']?([^\"]+)[\"']?");
        stringBuilder.append("|\\S+=[\"']?\\S+\\.(");
        for (String string : RESOURCE_TYPES) {
            stringBuilder.append(string).append('|');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(")[\"']?)");
        return Pattern.compile(stringBuilder.toString(), 34);
    }

    @Override
    public String handleReferences(String string, String string2) {
        this.findRequiredResources(string, string2);
        if (!this.fResourcesToCopy.isEmpty()) {
            this.createResourceFolder();
            this.copyResources();
            return this.modifyReferencesInSource(string);
        }
        return string;
    }

    private void findRequiredResources(String string, String string2) {
        ResourceResolver resourceResolver = new ResourceResolver(string2);
        Matcher matcher = RESOURCE_PATTERN.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            if (this.fResourcesToCopy.containsKey(string3 = string3.replaceFirst("^\\S+=([\"']?)(.*?)\\1$", "$2"))) continue;
            String string4 = resourceResolver.resolveResource(string3);
            this.fResourcesToCopy.put(string3, string4);
        }
    }

    private void createResourceFolder() {
        int n = this.fFileToSave.getName().lastIndexOf(46);
        if (n == -1) {
            n = this.fFileToSave.getName().length();
        }
        String string = this.fFileToSave.getName().substring(0, n) + "_files";
        File file = new File(this.fFileToSave.getParentFile(), string);
        this.fCopyStrategy.createResourceDir(file);
        this.fResourceDir = file;
    }

    private String modifyReferencesInSource(String string) {
        String string2 = string;
        String string3 = this.fResourceDir.getName();
        if (EncodingUtils.needsEncoding(string3)) {
            string3 = EncodingUtils.encodeUrl(string3);
        }
        for (Map.Entry<String, String> entry : this.fResourcesToCopy.entrySet()) {
            String string4 = entry.getValue();
            string4 = string4.replaceFirst("^.*/([^/]+)", string3 + "/$1");
            string2 = string2.replace(entry.getKey(), string4);
        }
        return string2;
    }

    private void copyResources() {
        for (String string : this.fResourcesToCopy.values()) {
            this.copySingleResourceSilently(string);
        }
    }

    private void copySingleResourceSilently(String string) {
        try {
            this.copyResource(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String string) throws IOException {
        File file = this.getLocalFileForResource(string);
        InputStream inputStream = this.fCopyStrategy.getInputStreamForResource(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.fCopyStrategy.getOutputStreamForFile(file));
        try {
            int n;
            while ((n = inputStream.read()) >= 0) {
                ((OutputStream)bufferedOutputStream).write(n);
            }
        }
        finally {
            inputStream.close();
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    private File getLocalFileForResource(String string) {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            return new File(this.fResourceDir, string.substring(n + 1));
        }
        return new File(this.fResourceDir, string);
    }

    public static class ResourceResolver {
        private final String iUrlRoot;
        private final String iUrlPath;

        public ResourceResolver(String string) {
            String string2;
            String string3;
            Matcher matcher = BASE_URL_PATTERN.matcher(string);
            if (matcher.find()) {
                string3 = matcher.group(1);
                String string4 = matcher.group(2);
                string2 = string4 == null ? string3 + '/' : string3 + '/' + string4;
            } else {
                string3 = "";
                int n = string.lastIndexOf(47);
                string2 = n >= 0 ? string.substring(0, n + 1) : string + "/";
            }
            this.iUrlRoot = string3;
            this.iUrlPath = string2;
        }

        public String resolveResource(String string) {
            if (string.startsWith("http") || string.startsWith("file:")) {
                return string;
            }
            if (string.startsWith("/")) {
                return this.iUrlRoot + string;
            }
            return this.iUrlPath + string;
        }
    }

    private static class DefaultCopyStrategy
    implements ResourceCopyStrategy {
        private DefaultCopyStrategy() {
        }

        @Override
        public InputStream getInputStreamForResource(String string) throws IOException {
            return HtmlSourceReader.getInputStreamForUrl(string);
        }

        @Override
        public OutputStream getOutputStreamForFile(File file) throws IOException {
            return new FileOutputStream(file);
        }

        @Override
        public void createResourceDir(File file) {
            if (!file.exists() && file.getParentFile().canWrite()) {
                file.mkdirs();
            }
        }
    }

    public static interface ResourceCopyStrategy {
        public InputStream getInputStreamForResource(String var1) throws IOException;

        public OutputStream getOutputStreamForFile(File var1) throws IOException;

        public void createResourceDir(File var1);
    }
}

