/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.HtmlTextWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class DefaultHtmlTextWriter
implements HtmlTextWriter {
    private static int sNextId = 0;
    private final String fFileName = DefaultHtmlTextWriter.getUniqueFileName();
    private File fHtmlTextDir;

    private static synchronized String getUniqueFileName() {
        return "mwblank" + sNextId++ + ".html";
    }

    @Override
    public void beforeFirstWrite() {
        File file = this.getHtmlTextFile();
        if (file != null && !file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHtmlText(String string, Charset charset) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getHtmlTextFile()));
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, charset);){
            outputStreamWriter.write(string);
        }
    }

    @Override
    public void setHtmlTextDir(File file) {
        if (this.isDirectoryValid(file)) {
            this.getHtmlTextFile().delete();
            this.fHtmlTextDir = file;
        }
    }

    private boolean isDirectoryValid(File file) {
        return file != null && file.exists() && file.isDirectory() && file.canWrite();
    }

    @Override
    public File getHtmlTextFile() {
        File file = this.fHtmlTextDir == null ? new File(System.getProperty("java.io.tmpdir")) : this.fHtmlTextDir;
        return new File(file, this.fFileName);
    }

    @Override
    public void dispose() {
        this.getHtmlTextFile().delete();
    }
}

