/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.RelativeUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlReplacer;
import com.mathworks.html.WebUrl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class RelativeUrlBuilder<T extends Url> {
    private final T fStartUrl;

    public RelativeUrlBuilder(T t) {
        this.fStartUrl = t;
    }

    public T buildRelativeUrl(RelativeUrl relativeUrl) {
        return new RelativeUrlReplacer(relativeUrl).transformUrl(this.fStartUrl);
    }

    public T buildRelativeUrl(String string) {
        return this.buildRelativeUrl(RelativeUrl.fromString(string));
    }

    public static <T extends Url> T buildRelativeUrl(T t, RelativeUrl relativeUrl) {
        return new RelativeUrlBuilder<T>(t).buildRelativeUrl(relativeUrl);
    }

    public static <T extends Url> T buildRelativeUrl(T t, String string) {
        return new RelativeUrlBuilder<T>(t).buildRelativeUrl(string);
    }

    private static class RelativeUrlReplacer
    extends UrlReplacer {
        private final RelativeUrl iRelativeUrl;

        private RelativeUrlReplacer(RelativeUrl relativeUrl) {
            this.iRelativeUrl = relativeUrl;
        }

        @Override
        protected WebUrl transformWebUrl(WebUrl webUrl) {
            try {
                URL uRL = webUrl.toURL();
                URL uRL2 = new URL(uRL, this.iRelativeUrl.toString());
                return new WebUrl(uRL2);
            }
            catch (MalformedURLException malformedURLException) {
                return webUrl.toUrlBuilder().append(this.iRelativeUrl).toUrl();
            }
        }

        @Override
        protected FileUrl transformFileUrl(FileUrl fileUrl) {
            File file = this.appendToFile(fileUrl.getFile());
            UrlBuilder<FileUrl> urlBuilder = UrlBuilder.fromFile(file);
            urlBuilder.setTarget(this.iRelativeUrl.getTarget());
            urlBuilder.setParameters(this.iRelativeUrl.getParameters());
            return urlBuilder.toUrl();
        }

        private File appendToFile(File file) {
            String string = this.iRelativeUrl.getRelativePath();
            File file2 = RelativeUrlReplacer.getFileForAppending(file, string);
            if (string != null && !string.isEmpty()) {
                file2 = new File(file2, string);
            }
            try {
                return file2.getCanonicalFile();
            }
            catch (Exception exception) {
                return file2;
            }
        }

        private static File getFileForAppending(File file, String string) {
            if (file.isDirectory() || string == null || string.isEmpty()) {
                return file;
            }
            return file.getParentFile();
        }

        @Override
        protected CustomProtocolUrl transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return customProtocolUrl.toUrlBuilder().append(this.iRelativeUrl).toUrl();
        }
    }
}

