/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.EncodingUtils;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlParser;
import com.mathworks.html.UrlVisitor;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class Url {
    private final Map<String, List<String>> fParameters = new LinkedHashMap<String, List<String>>();
    private String fTarget;

    Url(Map<String, List<String>> map, String string) {
        if (map != null) {
            this.fParameters.putAll(map);
        }
        this.fTarget = string;
    }

    public static Url parse(URL uRL) {
        return UrlParser.parse(uRL);
    }

    public static Url parse(String string) throws MalformedURLException {
        return UrlParser.parse(string);
    }

    public static Url parseSilently(String string) {
        try {
            return Url.parse(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public abstract UrlBuilder<? extends Url> toUrlBuilder();

    public abstract UrlType getType();

    public abstract String getProtocol();

    public abstract String getBaseUrl();

    public Map<String, List<String>> getParameters() {
        return Collections.unmodifiableMap(this.fParameters);
    }

    public List<String> getParameterValues(String string) {
        if (this.fParameters.containsKey(string)) {
            return Collections.unmodifiableList(this.fParameters.get(string));
        }
        return null;
    }

    public String getParameterValue(String string) {
        List<String> list = this.getParameterValues(string);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    public String getTarget() {
        return this.fTarget;
    }

    public Set<UrlPart> diffTo(Url url) {
        if (url == null) {
            return this.getNonNullParts();
        }
        EnumSet<UrlPart> enumSet = EnumSet.noneOf(UrlPart.class);
        if (!this.getProtocol().equals(url.getProtocol()) || !Url.areBaseUrlsEqual(this, url)) {
            enumSet.add(UrlPart.BASE);
        }
        if (!this.isParamMapEqual(url)) {
            enumSet.add(UrlPart.QUERYSTRING);
        }
        String string = this.getTarget();
        String string2 = url.getTarget();
        if (string != null && !string.equals(string2) || string == null && string2 != null) {
            enumSet.add(UrlPart.TARGET);
        }
        return Collections.unmodifiableSet(enumSet);
    }

    private static boolean areBaseUrlsEqual(Url url, Url url2) {
        Object[] objectArray;
        Object[] objectArray2 = url.getBaseUrlComparisonItems();
        if (objectArray2.length != (objectArray = url2.getBaseUrlComparisonItems()).length) {
            return false;
        }
        for (int i = 0; i < objectArray2.length; ++i) {
            if (objectArray2[i].equals(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    protected abstract Object[] getBaseUrlComparisonItems();

    private boolean isParamMapEqual(Url url) {
        Map<String, List<String>> map = this.getParameters();
        Map<String, List<String>> map2 = url.getParameters();
        Set<String> set = map.keySet();
        Set<String> set2 = map2.keySet();
        if (set.size() != set2.size() || !set.containsAll(set2)) {
            return false;
        }
        for (String string : set) {
            List<String> list;
            List<String> list2 = map.get(string);
            if (list2.equals(list = map2.get(string))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Url.assembleUrl(this.getBaseUrl(), this.fParameters, this.fTarget);
    }

    public String getUnencodedUrl() {
        String string = EncodingUtils.decodeBaseUrl(this.getBaseUrl());
        return Url.assembleUrl(string, this.fParameters, this.fTarget, false);
    }

    public boolean equals(Object object) {
        return object instanceof Url && this.diffTo((Url)object).isEmpty();
    }

    public int hashCode() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(this.fParameters);
        return Url.assembleUrl(this.getBaseUrl(), treeMap, this.getTarget()).hashCode();
    }

    static String assembleUrl(String string, Map<String, List<String>> map, String string2) {
        return Url.assembleUrl(string, map, string2, true);
    }

    private static String assembleUrl(String string, Map<String, List<String>> map, String string2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string);
        String string3 = Url.buildQueryString(map, bl);
        if (string3.length() > 0) {
            stringBuilder.append('?').append(string3);
        }
        if (string2 != null) {
            stringBuilder.append('#').append(string2);
        }
        return stringBuilder.toString();
    }

    private static String buildQueryString(Map<String, List<String>> map, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> list;
            String string = entry.getKey();
            if (bl) {
                string = Url.encodeQueryStringPart(string);
            }
            if ((list = entry.getValue()).isEmpty()) {
                Url.appendParameter(stringBuilder, string, null);
                continue;
            }
            for (String string2 : list) {
                if (bl) {
                    string2 = Url.encodeQueryStringPart(string2);
                }
                Url.appendParameter(stringBuilder, string, string2);
            }
        }
        return stringBuilder.toString();
    }

    private static void appendParameter(StringBuilder stringBuilder, String string, String string2) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append('&');
        }
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append('=').append(string2);
        }
    }

    private static String encodeQueryStringPart(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public abstract void accept(UrlVisitor var1);

    public boolean isTargetOnSamePage(Url url) {
        Set<UrlPart> set = this.diffTo(url);
        return set.isEmpty() || set.size() == 1 && set.contains((Object)UrlPart.TARGET);
    }

    public String getQueryString() {
        return Url.buildQueryString(this.getParameters(), true);
    }

    public static Set<UrlPart> diff(Url url, Url url2) {
        if (url != null) {
            return url.diffTo(url2);
        }
        if (url2 != null) {
            return url2.getNonNullParts();
        }
        return Collections.emptySet();
    }

    public static boolean isUrlChangeOfParts(Url url, Url url2, UrlPart ... urlPartArray) {
        Set<UrlPart> set = Url.diff(url, url2);
        return set.size() == urlPartArray.length && set.containsAll(Arrays.asList(urlPartArray));
    }

    private Set<UrlPart> getNonNullParts() {
        String string;
        EnumSet<UrlPart> enumSet = EnumSet.of(UrlPart.BASE);
        if (!this.getParameters().isEmpty()) {
            enumSet.add(UrlPart.QUERYSTRING);
        }
        if ((string = this.getTarget()) != null && !string.isEmpty()) {
            enumSet.add(UrlPart.TARGET);
        }
        return enumSet;
    }

    public static enum UrlType {
        WEB,
        FILE,
        CUSTOM_PROTOCOL;

    }

    public static enum UrlPart {
        BASE,
        QUERYSTRING,
        TARGET;

    }
}

