/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html;

import com.mathworks.html.CloneableUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlPartParser;
import com.mathworks.html.UrlVisitor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebUrl
extends CloneableUrl<WebUrl> {
    static final Set<String> WEB_URL_PROTOCOLS = new HashSet<String>(Arrays.asList("http", "https", "ftp"));
    private final URL fBaseUrl;

    public WebUrl(String string) throws MalformedURLException {
        this(new URL(string));
    }

    public WebUrl(URL uRL) {
        this(WebUrl.getWebBaseUrl(uRL), UrlPartParser.parseParameters(uRL.getQuery()), uRL.getRef());
    }

    public WebUrl(URL uRL, Map<String, List<String>> map, String string) {
        super(map, string);
        this.fBaseUrl = WebUrl.getWebBaseUrl(uRL);
    }

    private static URL getWebBaseUrl(URL uRL) {
        String string = uRL.getProtocol();
        if (!WEB_URL_PROTOCOLS.contains(string)) {
            throw new IllegalArgumentException("WebUrl can only be created from a URL with a protocol of http, https, or ftp.");
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : "Existing URLs should not cause MalformedURLExceptions";
            return uRL;
        }
    }

    public URL toURL() {
        try {
            return new URL(this.toString());
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : "UrlBuilder URLs should not be malformed";
            return this.fBaseUrl;
        }
    }

    @Override
    public Url.UrlType getType() {
        return Url.UrlType.WEB;
    }

    @Override
    public String getProtocol() {
        return this.fBaseUrl.getProtocol();
    }

    @Override
    public String getBaseUrl() {
        String string = this.fBaseUrl.toExternalForm();
        return string.replaceFirst(";.*", "");
    }

    @Override
    public void accept(UrlVisitor urlVisitor) {
        urlVisitor.visitWebUrl(this);
    }

    @Override
    protected CloneableUrl<WebUrl> append(String ... stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(this.getPathParts()));
        linkedList.addAll(Arrays.asList(stringArray));
        String string = WebUrl.buildPath(linkedList);
        try {
            URL uRL = new URL(this.fBaseUrl.getProtocol(), this.fBaseUrl.getHost(), this.fBaseUrl.getPort(), string);
            return new WebUrl(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return this;
        }
    }

    private static String buildPath(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append('/').append(string);
        }
        return stringBuilder.toString();
    }

    String[] getPathParts() {
        String string = this.fBaseUrl.getPath().replaceAll("^/+", "").replaceAll("/+&", "");
        return string.split("/");
    }

    @Override
    protected WebUrl createModifiedCopy(Map<String, List<String>> map, String string) {
        return new WebUrl(this.fBaseUrl, map, string);
    }

    @Override
    public UrlBuilder<WebUrl> toUrlBuilder() {
        return new UrlBuilder<WebUrl>(this);
    }

    @Override
    protected Object[] getBaseUrlComparisonItems() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.fBaseUrl.getHost());
        arrayList.add(this.fBaseUrl.getPort());
        arrayList.addAll(Arrays.asList(this.getPathParts()));
        return arrayList.toArray();
    }
}

