/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.HtmlActionGroup;
import com.mathworks.html.jxbrowser.BrowserAccessRunnable;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.teamdev.jxbrowser.ie.IEBrowser;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

class JxBrowserZoomHandler
extends KeyAdapter {
    private final BrowserHolder fBrowser;
    private final ResourceBundle fResBundle = ResourceBundle.getBundle("com.mathworks.html.resources.RES_HtmlPanel");
    private int fZoomValue = 100;
    private HtmlActionGroup fZoomActionGroup;

    JxBrowserZoomHandler(BrowserHolder browserHolder) {
        this.fBrowser = browserHolder;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.isControlDown(keyEvent)) {
            int n = keyEvent.getKeyCode();
            if (n == 107 || n == 61) {
                this.zoomIn();
            } else if (n == 109 || n == 45) {
                this.zoomOut();
            }
        }
    }

    private boolean isControlDown(KeyEvent keyEvent) {
        return this.fBrowser.getType() == BrowserHolder.Type.Safari ? keyEvent.isMetaDown() : keyEvent.isControlDown();
    }

    private void zoomIn() {
        int n = this.fZoomValue;
        this.fZoomValue += 10;
        this.fBrowser.invokeLater(new ZoomRunnable(n, this.fZoomValue));
    }

    private void zoomOut() {
        if (this.fZoomValue > 10) {
            int n = this.fZoomValue;
            this.fZoomValue -= 10;
            this.fBrowser.invokeLater(new ZoomRunnable(n, this.fZoomValue));
        }
    }

    HtmlActionGroup getZoomActionGroup() {
        if (this.fZoomActionGroup == null) {
            this.fZoomActionGroup = this.createZoomActionGroup();
        }
        return this.fZoomActionGroup;
    }

    private HtmlActionGroup createZoomActionGroup() {
        Map<String, Action> map = this.createZoomActions();
        HtmlActionGroup htmlActionGroup = new HtmlActionGroup("ZoomActions", map);
        return htmlActionGroup;
    }

    private Map<String, Action> createZoomActions() {
        HashMap<String, Action> hashMap = new HashMap<String, Action>();
        ZoomInAction zoomInAction = new ZoomInAction(this.getLabel("ZoomIn"));
        ZoomOutAction zoomOutAction = new ZoomOutAction(this.getLabel("ZoomOut"));
        hashMap.put("ZoomIn", zoomInAction);
        hashMap.put("ZoomOut", zoomOutAction);
        return hashMap;
    }

    private String getLabel(String string) {
        return this.fResBundle.getString("action.label." + string.toLowerCase(Locale.ENGLISH));
    }

    private class ZoomOutAction
    extends AbstractAction {
        private ZoomOutAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JxBrowserZoomHandler.this.zoomOut();
            JxBrowserZoomHandler.this.fBrowser.getComponent().requestFocusInWindow();
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private ZoomInAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JxBrowserZoomHandler.this.zoomIn();
            JxBrowserZoomHandler.this.fBrowser.getComponent().requestFocusInWindow();
        }
    }

    private static class ZoomRunnable
    implements BrowserAccessRunnable {
        private final int iOldZoomValue;
        private final int iNewZoomValue;

        private ZoomRunnable(int n, int n2) {
            this.iOldZoomValue = n;
            this.iNewZoomValue = n2;
        }

        @Override
        public void handleMozillaBrowser(MozillaBrowser mozillaBrowser) {
            mozillaBrowser.getConfigurable().setZoomValue(this.iNewZoomValue);
        }

        @Override
        public void handleMozilla15Browser(com.teamdev.jxbrowser.mozilla15.MozillaBrowser mozillaBrowser) {
            mozillaBrowser.getConfigurable().setZoomValue(this.iNewZoomValue);
        }

        @Override
        public void handleIEBrowser(IEBrowser iEBrowser) {
            iEBrowser.getConfigurable().setZoomValue(this.iNewZoomValue);
        }

        @Override
        public void handleSafariBrowser(SafariBrowser safariBrowser) {
            int n;
            Font font = safariBrowser.getConfigurable().getDefaultFont();
            int n2 = font.getSize();
            int n3 = n = this.iNewZoomValue > this.iOldZoomValue ? n2 + 1 : n2 - 1;
            if (n >= 10 && n <= 72) {
                Font font2 = new Font(font.getName(), 0, n);
                safariBrowser.getConfigurable().setDefaultFont(font2);
            }
        }
    }
}

