/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMElement;
import com.teamdev.jxbrowser.chromium.dom.DOMNode;
import com.teamdev.jxbrowser.chromium.events.FrameLoadEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.LoadEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

class CustomProtocolFormHandler
extends LoadAdapter {
    private final FileUrl fPlaceholderUrl = CustomProtocolFormHandler.buildPlaceHolderUrl();
    private final List<Url> fReplacedFormUrls = new LinkedList<Url>();

    CustomProtocolFormHandler() {
    }

    private static FileUrl buildPlaceHolderUrl() {
        File file = HtmlPanel.getResourceDirectory();
        File file2 = new File(file, "mwcustomprotocol");
        return new FileUrl(file2);
    }

    public void onDocumentLoadedInMainFrame(LoadEvent loadEvent) {
        this.updateFormsInDocument(loadEvent.getBrowser().getDocument());
    }

    public void onDocumentLoadedInFrame(FrameLoadEvent frameLoadEvent) {
        DOMDocument dOMDocument;
        int n = (int)frameLoadEvent.getFrameId();
        if (n != -1 && (dOMDocument = frameLoadEvent.getBrowser().getDocument(n)) != null) {
            this.updateFormsInDocument(dOMDocument);
        }
    }

    private void updateFormsInDocument(DOMDocument dOMDocument) {
        List list = dOMDocument.getElementsByTagName("form");
        for (DOMNode dOMNode : list) {
            DOMElement dOMElement;
            Url url;
            if (!(dOMNode instanceof DOMElement) || (url = this.updateFormAction(dOMElement = (DOMElement)dOMNode)) == null) continue;
            CustomProtocolFormHandler.updateFormMethod(dOMElement);
        }
    }

    private Url updateFormAction(DOMElement dOMElement) {
        Url url;
        String string = dOMElement.getAttribute("action");
        if (string != null && !string.isEmpty() && (url = Url.parseSilently(string)) != null && url.getType() == Url.UrlType.CUSTOM_PROTOCOL) {
            Url url2 = this.createPlaceholderFormUrl(this.fReplacedFormUrls.size());
            dOMElement.setAttribute("action", url2.toString());
            this.fReplacedFormUrls.add(url);
            return url;
        }
        return null;
    }

    private Url createPlaceholderFormUrl(int n) {
        UrlBuilder<FileUrl> urlBuilder = this.fPlaceholderUrl.toUrlBuilder();
        urlBuilder.setTarget(String.valueOf(n));
        return urlBuilder.toUrl();
    }

    private static void updateFormMethod(DOMElement dOMElement) {
        String string = dOMElement.getAttribute("method");
        if (string != null && !string.isEmpty() && !string.equalsIgnoreCase("get")) {
            dOMElement.setAttribute("method", "get");
        }
    }

    Url getCustomProtocolFormUrl(Url url) {
        Url url2;
        if (this.isPlaceholderUrl(url) && (url2 = this.getOriginalFormAction(url)) != null) {
            UrlBuilder<? extends Url> urlBuilder = url2.toUrlBuilder();
            urlBuilder.setParameters(url.getParameters());
            return urlBuilder.toUrl();
        }
        return null;
    }

    private boolean isPlaceholderUrl(Url url) {
        return !url.diffTo(this.fPlaceholderUrl).contains((Object)Url.UrlPart.BASE);
    }

    private Url getOriginalFormAction(Url url) {
        String string = url.getTarget();
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                return n >= 0 && n < this.fReplacedFormUrls.size() ? this.fReplacedFormUrls.get(n) : null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

