/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.BrowserListeners;
import com.mathworks.html.BrowserNavigator;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.TextUrlRequestHandler;
import com.mathworks.html.Url;
import com.mathworks.html.jxbrowser.chromium.CustomProtocolFormHandler;
import com.mathworks.html.jxbrowser.chromium.LoadFailureListener;
import com.mathworks.html.jxbrowser.chromium.LoadHtmlHandler;
import com.mathworks.html.jxbrowser.chromium.RequestHandlerAdapter;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.LoadHandler;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import javax.swing.SwingUtilities;

class JxBrowserChromiumNavigator
implements BrowserNavigator {
    private final Browser fBrowser;
    private final RequestHandlerAdapter fRequestHandlerAdapter;
    private final LoadHtmlHandler fLoadHtmlHandler;
    private final LoadFailureListener fLoadFailureListener;

    private JxBrowserChromiumNavigator(Browser browser, BrowserListeners browserListeners) {
        this.fBrowser = browser;
        CustomProtocolFormHandler customProtocolFormHandler = new CustomProtocolFormHandler();
        browser.addLoadListener((LoadListener)customProtocolFormHandler);
        this.fRequestHandlerAdapter = new RequestHandlerAdapter(browserListeners.getRequestHandler(), customProtocolFormHandler);
        this.fBrowser.setLoadHandler((LoadHandler)this.fRequestHandlerAdapter);
        this.fBrowser.addLoadListener((LoadListener)this.fRequestHandlerAdapter);
        this.fLoadFailureListener = new LoadFailureListener(this);
        this.fBrowser.addLoadListener((LoadListener)this.fLoadFailureListener);
        this.fLoadHtmlHandler = new LoadHtmlHandler(this.fBrowser);
        this.fLoadHtmlHandler.setFileDir(HtmlPanel.getResourceDirectory());
        browserListeners.getRequestHandler().addRequestHandler(this.fLoadHtmlHandler);
    }

    static JxBrowserChromiumNavigator create(Browser browser, BrowserListeners browserListeners) {
        JxBrowserChromiumNavigator jxBrowserChromiumNavigator = new JxBrowserChromiumNavigator(browser, browserListeners);
        browserListeners.getRequestHandler().addRequestHandler(jxBrowserChromiumNavigator.createTextUrlRequestHandler());
        return jxBrowserChromiumNavigator;
    }

    private TextUrlRequestHandler createTextUrlRequestHandler() {
        return new TextUrlRequestHandler(this, this.fLoadHtmlHandler);
    }

    @Override
    public void setHtmlText(String string) {
        this.fLoadHtmlHandler.beforeSetHtmlText();
        Url url = this.fLoadHtmlHandler.getHtmlTextUrl(string);
        this.setCurrentLocation(url);
    }

    @Override
    public void setCurrentLocation(String string) {
        this.fRequestHandlerAdapter.setPendingRequest(Url.parseSilently(string), BrowserRequest.Origin.SET_LOCATION);
        this.doSetCurrentLocation(string);
    }

    @Override
    public void setCurrentLocation(Url url) {
        this.fRequestHandlerAdapter.setPendingRequest(url, BrowserRequest.Origin.SET_LOCATION);
        this.doSetCurrentLocation(url.toString());
    }

    @Override
    public Url getCurrentLocation() {
        return Url.parseSilently(this.fBrowser.getURL());
    }

    @Override
    public boolean canGoBack() {
        return this.fBrowser.canGoBack();
    }

    @Override
    public void goBack() {
        this.fRequestHandlerAdapter.setPendingRequest(null, BrowserRequest.Origin.GO_BACK);
        this.fBrowser.goBack();
    }

    @Override
    public boolean canGoForward() {
        return this.fBrowser.canGoForward();
    }

    @Override
    public void goForward() {
        this.fRequestHandlerAdapter.setPendingRequest(null, BrowserRequest.Origin.GO_FORWARD);
        this.fBrowser.goForward();
    }

    @Override
    public void reload() {
        this.fRequestHandlerAdapter.setPendingRequest(null, BrowserRequest.Origin.REFRESH);
        this.fBrowser.reloadIgnoringCache();
    }

    @Override
    public void addLoadFailureHandlers(LoadFailureHandlerMap loadFailureHandlerMap) {
        this.fLoadFailureListener.addLoadFailureHandlers(loadFailureHandlerMap);
    }

    LoadHtmlHandler getLoadHtmlHandler() {
        return this.fLoadHtmlHandler;
    }

    private void doSetCurrentLocation(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JxBrowserChromiumNavigator.this.fBrowser.loadURL(string);
            }
        });
    }
}

