/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser.chromium;

import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.ProxyAuthenticationFailureHandler;
import com.mathworks.html.ProxyCredentials;
import com.mathworks.html.ProxySettings;
import com.mathworks.html.jxbrowser.chromium.MWDialogHandlerBase;
import com.teamdev.jxbrowser.chromium.AuthDialogParams;
import com.teamdev.jxbrowser.chromium.Browser;
import com.teamdev.jxbrowser.chromium.CloseStatus;
import com.teamdev.jxbrowser.chromium.CustomProxyConfig;
import com.teamdev.jxbrowser.chromium.DirectProxyConfig;
import com.teamdev.jxbrowser.chromium.HostPortPair;
import com.teamdev.jxbrowser.chromium.ProxyConfig;
import com.teamdev.jxbrowser.chromium.events.FinishLoadingEvent;
import com.teamdev.jxbrowser.chromium.events.LoadAdapter;
import com.teamdev.jxbrowser.chromium.events.LoadListener;
import java.util.concurrent.CountDownLatch;

class ProxyHandler {
    private final ProxySettings fProxySettings = ProxySettings.getCurrentSettings();

    ProxyHandler() {
    }

    ProxyConfig getProxyConfig() {
        if (this.fProxySettings == null) {
            return new DirectProxyConfig();
        }
        HostPortPair hostPortPair = new HostPortPair(this.fProxySettings.getHost(), this.fProxySettings.getPort());
        return new CustomProxyConfig(hostPortPair, hostPortPair, hostPortPair, "<local>");
    }

    MWDialogHandlerBase createProxyDialogHandler(Browser browser) {
        if (this.fProxySettings != null) {
            ProxyCredentials proxyCredentials = this.fProxySettings.getCredentials();
            if (proxyCredentials != null) {
                return new ProxyDialogHandler(browser, proxyCredentials);
            }
            return new ProxyDialogHandler(browser, null);
        }
        return null;
    }

    private static class ProxyLoadListener
    extends LoadAdapter {
        private final ProxyDialogHandler iDialogHandler;

        private ProxyLoadListener(ProxyDialogHandler proxyDialogHandler) {
            this.iDialogHandler = proxyDialogHandler;
        }

        public void onFinishLoadingFrame(FinishLoadingEvent finishLoadingEvent) {
            this.iDialogHandler.setNeedsCredentials(false);
        }
    }

    private static class CredentialsListener
    implements HtmlDataListener<ProxyCredentials> {
        private final CountDownLatch iLatch;
        private ProxyCredentials iCredentials;

        private CredentialsListener(CountDownLatch countDownLatch) {
            this.iLatch = countDownLatch;
        }

        @Override
        public synchronized void dataRetrieved(ProxyCredentials proxyCredentials) {
            this.iCredentials = proxyCredentials;
            this.iLatch.countDown();
        }

        private ProxyCredentials getCredentials() {
            return this.iCredentials;
        }
    }

    private class ProxyDialogHandler
    extends MWDialogHandlerBase {
        private final Browser iBrowser;
        private ProxyCredentials iCredentials;
        private boolean iNeedsCredentials = false;

        private ProxyDialogHandler(Browser browser, ProxyCredentials proxyCredentials) {
            this.iBrowser = browser;
            this.iCredentials = proxyCredentials;
            browser.addLoadListener((LoadListener)new ProxyLoadListener(this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CloseStatus onAuthRequired(AuthDialogParams authDialogParams) {
            if (authDialogParams.isProxy()) {
                try {
                    CloseStatus closeStatus;
                    CloseStatus closeStatus2 = closeStatus = this.requiresCredentials() ? this.getCredentials() : CloseStatus.OK;
                    if (closeStatus != null) {
                        authDialogParams.setUsername(this.iCredentials == null ? null : this.iCredentials.getUsername());
                        authDialogParams.setPassword(this.iCredentials == null ? null : this.iCredentials.getPassword());
                        CloseStatus closeStatus3 = closeStatus;
                        return closeStatus3;
                    }
                    CloseStatus closeStatus4 = super.onAuthRequired(authDialogParams);
                    return closeStatus4;
                }
                finally {
                    this.setNeedsCredentials(true);
                }
            }
            return null;
        }

        private boolean requiresCredentials() {
            return this.iCredentials == null || this.iNeedsCredentials;
        }

        private CloseStatus getCredentials() {
            ProxyAuthenticationFailureHandler proxyAuthenticationFailureHandler = ProxySettings.getAuthenticationFailureHandler();
            if (proxyAuthenticationFailureHandler != null) {
                try {
                    this.iCredentials = this.waitForCredentials(proxyAuthenticationFailureHandler);
                    if (this.iCredentials != null) {
                        return CloseStatus.OK;
                    }
                    return CloseStatus.CANCEL;
                }
                catch (InterruptedException interruptedException) {
                    return CloseStatus.CANCEL;
                }
            }
            return null;
        }

        private ProxyCredentials waitForCredentials(ProxyAuthenticationFailureHandler proxyAuthenticationFailureHandler) throws InterruptedException {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            CredentialsListener credentialsListener = new CredentialsListener(countDownLatch);
            proxyAuthenticationFailureHandler.onFailure(this.iBrowser.getView().getComponent(), ProxyHandler.this.fProxySettings, credentialsListener);
            countDownLatch.await();
            return credentialsListener.getCredentials();
        }

        private void setNeedsCredentials(boolean bl) {
            this.iNeedsCredentials = bl;
        }
    }
}

