/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.EmulatorLocalDevice;
import com.intel.bluetooth.EmulatorServiceConnection;
import com.intel.bluetooth.ServiceRecordImpl;
import java.io.IOException;

class EmulatorL2CAPService
extends EmulatorServiceConnection {
    private int receiveMTU;
    private int transmitMTU;
    int pcm;

    EmulatorL2CAPService(EmulatorLocalDevice localDevice, long handle, int pcm) {
        super(localDevice, handle);
        this.pcm = pcm;
    }

    public int getPcm() {
        return this.pcm;
    }

    int getReceiveMTU() throws IOException {
        return this.receiveMTU;
    }

    int getTransmitMTU() throws IOException {
        return this.transmitMTU;
    }

    public void open(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU) throws IOException {
        this.params = params;
        this.receiveMTU = receiveMTU;
        this.transmitMTU = transmitMTU;
        this.localDevice.getDeviceManagerService().l2OpenService(this.localDevice.getAddress(), this.pcm);
    }

    public long accept() throws IOException {
        return this.localDevice.getDeviceManagerService().l2Accept(this.localDevice.getAddress(), this.pcm, this.params.authenticate, this.params.encrypt, this.receiveMTU);
    }

    public void close(ServiceRecordImpl serviceRecord) throws IOException {
        this.localDevice.getDeviceManagerService().removeServiceRecord(this.localDevice.getAddress(), serviceRecord.getHandle());
        this.localDevice.getDeviceManagerService().l2CloseService(this.localDevice.getAddress(), this.pcm);
    }
}

