/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.EmulatorConnection;
import com.intel.bluetooth.EmulatorL2CAPClient;
import com.intel.bluetooth.EmulatorL2CAPService;
import com.intel.bluetooth.EmulatorRFCOMMClient;
import com.intel.bluetooth.EmulatorRFCOMMService;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.emu.DeviceDescriptor;
import com.intel.bluetooth.emu.DeviceManagerService;
import com.intel.bluetooth.emu.EmulatorConfiguration;
import com.intel.bluetooth.emu.EmulatorUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;

class EmulatorLocalDevice {
    private DeviceManagerService service;
    private DeviceDescriptor deviceDescriptor;
    private int bluetooth_sd_attr_retrievable_max = 0;
    private int bluetooth_l2cap_receiveMTU_max = 0;
    private int bluetooth_connected_devices_max = 0;
    private EmulatorConfiguration configuration;
    private Map<String, String> propertiesMap;
    private Vector<Long> channels = new Vector();
    private Vector<Long> pcms = new Vector();
    private long connectionCount = 0L;
    private Map<Long, EmulatorConnection> connections = new Hashtable<Long, EmulatorConnection>();

    EmulatorLocalDevice(DeviceManagerService service, DeviceDescriptor deviceDescriptor) throws BluetoothStateException {
        this.service = service;
        this.deviceDescriptor = deviceDescriptor;
        this.propertiesMap = new Hashtable<String, String>();
        this.propertiesMap.put("bluecove.radio.version", BlueCoveImpl.version);
        this.propertiesMap.put("bluecove.radio.manufacturer", "pyx4j.com");
        this.propertiesMap.put("bluecove.stack.version", BlueCoveImpl.version);
        this.updateConfiguration();
    }

    void destroy() {
        this.service = null;
        this.deviceDescriptor = null;
    }

    DeviceManagerService getDeviceManagerService() {
        return this.service;
    }

    void updateConfiguration() throws BluetoothStateException {
        this.configuration = this.service.getEmulatorConfiguration(this.deviceDescriptor.getAddress());
        this.bluetooth_sd_attr_retrievable_max = this.configuration.getIntProperty("bluetooth.sd.attr.retrievable.max");
        this.bluetooth_l2cap_receiveMTU_max = this.configuration.getIntProperty("bluetooth.l2cap.receiveMTU.max");
        this.bluetooth_connected_devices_max = this.configuration.getIntProperty("bluetooth.connected.devices.max");
        if (this.bluetooth_l2cap_receiveMTU_max + 2 > this.configuration.getConnectionBufferSize()) {
            throw new BluetoothStateException("l2cap.receiveMTU.max larger then connection buffer");
        }
        String[] property = new String[]{"bluetooth.master.switch", "bluetooth.sd.attr.retrievable.max", "bluetooth.connected.devices.max", "bluetooth.l2cap.receiveMTU.max", "bluetooth.sd.trans.max", "bluetooth.connected.inquiry.scan", "bluetooth.connected.page.scan", "bluetooth.connected.inquiry", "bluetooth.connected.page"};
        for (int i = 0; i < property.length; ++i) {
            this.propertiesMap.put(property[i], this.configuration.getProperty(property[i]));
        }
    }

    void updateLocalDeviceProperties() {
        this.deviceDescriptor = this.service.getDeviceDescriptor(this.deviceDescriptor.getAddress());
        try {
            this.updateConfiguration();
        }
        catch (BluetoothStateException bluetoothStateException) {
            // empty catch block
        }
    }

    long getAddress() {
        return this.deviceDescriptor.getAddress();
    }

    String getName() {
        return this.deviceDescriptor.getName();
    }

    int getDeviceClass() {
        return this.deviceDescriptor.getDeviceClass();
    }

    void setLocalDeviceServiceClasses(int classOfDevice) {
        int c = this.deviceDescriptor.getDeviceClass();
        c &= 0x1FFC;
        this.deviceDescriptor.setDeviceClass(c |= classOfDevice);
        this.service.setLocalDeviceServiceClasses(this.deviceDescriptor.getAddress(), c);
    }

    boolean isActive() {
        if (this.deviceDescriptor == null) {
            return false;
        }
        return this.deviceDescriptor.isPoweredOn();
    }

    boolean isLocalDevicePowerOn() {
        this.deviceDescriptor.setPoweredOn(this.service.isLocalDevicePowerOn(this.deviceDescriptor.getAddress()));
        return this.deviceDescriptor.isPoweredOn();
    }

    void setLocalDevicePower(boolean on) {
        this.deviceDescriptor.setPoweredOn(on);
    }

    public boolean isConnectable() {
        return this.deviceDescriptor.isPoweredOn() && this.deviceDescriptor.isConnectable();
    }

    String getLocalDeviceProperty(String property) {
        return this.propertiesMap.get(property);
    }

    int getBluetooth_sd_attr_retrievable_max() {
        return this.bluetooth_sd_attr_retrievable_max;
    }

    int getBluetooth_l2cap_receiveMTU_max() {
        return this.bluetooth_l2cap_receiveMTU_max;
    }

    int getLocalDeviceDiscoverable() {
        return this.service.getLocalDeviceDiscoverable(this.getAddress());
    }

    boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        return this.service.setLocalDeviceDiscoverable(this.getAddress(), mode);
    }

    EmulatorConfiguration getConfiguration() {
        return this.configuration;
    }

    EmulatorConnection getConnection(long handle) throws IOException {
        EmulatorConnection c = this.connections.get(new Long(handle));
        if (c == null) {
            throw new IOException("Invalid connection handle " + handle);
        }
        return c;
    }

    void removeConnection(EmulatorConnection c) {
        this.connections.remove(new Long(c.getHandle()));
        if (c instanceof EmulatorRFCOMMService) {
            this.channels.remove(new Long(((EmulatorRFCOMMService)c).getChannel()));
        } else if (c instanceof EmulatorL2CAPService) {
            this.pcms.remove(new Long(((EmulatorL2CAPService)c).getPcm()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextConnectionId() {
        long id;
        Map<Long, EmulatorConnection> map = this.connections;
        synchronized (map) {
            ++this.connectionCount;
            id = this.connectionCount;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmulatorRFCOMMService createRFCOMMService() {
        EmulatorRFCOMMService s;
        Map<Long, EmulatorConnection> map = this.connections;
        synchronized (map) {
            long handle = this.nextConnectionId();
            int channel = (int)EmulatorUtils.getNextAvailable(this.channels, 1L, 1);
            s = new EmulatorRFCOMMService(this, handle, channel);
            this.connections.put(new Long(handle), s);
            this.channels.addElement(new Long(channel));
        }
        return s;
    }

    private void validateCanConnect(long remoteAddress) throws IOException {
        if (RemoteDeviceHelper.connectedDevices() >= this.bluetooth_connected_devices_max && RemoteDeviceHelper.openConnections((long)remoteAddress) == 0) {
            throw new BluetoothConnectionException(3, "Number of connected device exceeded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmulatorRFCOMMClient createRFCOMMClient(long remoteAddress) throws IOException {
        EmulatorRFCOMMClient c;
        this.validateCanConnect(remoteAddress);
        Map<Long, EmulatorConnection> map = this.connections;
        synchronized (map) {
            long handle = this.nextConnectionId();
            c = new EmulatorRFCOMMClient(this, handle);
            this.connections.put(new Long(handle), c);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmulatorL2CAPService createL2CAPService(int bluecove_ext_psm) throws IOException {
        EmulatorL2CAPService s;
        Map<Long, EmulatorConnection> map = this.connections;
        synchronized (map) {
            int pcm;
            if (bluecove_ext_psm != 0) {
                if (this.pcms.contains(new Long(bluecove_ext_psm))) {
                    throw new IOException("Server PCM " + Integer.toHexString(bluecove_ext_psm) + " already reserved");
                }
                pcm = bluecove_ext_psm;
            } else {
                pcm = (int)EmulatorUtils.getNextAvailable(this.pcms, 4097L, 2);
            }
            long handle = this.nextConnectionId();
            s = new EmulatorL2CAPService(this, handle, pcm);
            this.connections.put(new Long(handle), s);
            this.pcms.addElement(new Long(pcm));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmulatorL2CAPClient createL2CAPClient(long remoteAddress) throws IOException {
        EmulatorL2CAPClient c;
        this.validateCanConnect(remoteAddress);
        Map<Long, EmulatorConnection> map = this.connections;
        synchronized (map) {
            long handle = this.nextConnectionId();
            c = new EmulatorL2CAPClient(this, handle);
            this.connections.put(new Long(handle), c);
        }
        return c;
    }
}

