/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.emu.ConnectionBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ConnectionBufferRFCOMM
extends ConnectionBuffer {
    ConnectionBufferRFCOMM(long remoteAddress, String portID, InputStream is, OutputStream os) {
        super(remoteAddress, portID, is, os);
    }

    void rfWrite(byte[] b) throws IOException {
        this.monitor.writeTimeStamp = System.currentTimeMillis();
        ++this.monitor.writeOperations;
        this.monitor.writeBytes += (long)b.length;
        this.os.write(b);
    }

    void rfFlush() throws IOException {
        this.os.flush();
    }

    int rfAvailable() throws IOException {
        return this.is.available();
    }

    byte[] rfRead(int len) throws IOException {
        byte[] b = new byte[len];
        int rc = this.is.read(b);
        if (rc == -1) {
            return null;
        }
        this.monitor.readTimeStamp = System.currentTimeMillis();
        ++this.monitor.readOperations;
        this.monitor.readBytes += (long)rc;
        if (rc == len) {
            return b;
        }
        byte[] b2 = new byte[rc];
        System.arraycopy(b, 0, b2, 0, rc);
        return b2;
    }
}

