/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import java.util.Arrays;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmulatorUtils {
    public static long getNextAvailable(Vector<Long> handles, long firstAvalable, int step) {
        return EmulatorUtils.getNextAvailable(handles.toArray(new Long[handles.size()]), firstAvalable, step);
    }

    public static long getNextAvailable(Set<Long> handles, long firstAvalable, int step) {
        return EmulatorUtils.getNextAvailable(handles.toArray(new Long[handles.size()]), firstAvalable, step);
    }

    public static long getNextAvailable(Long[] handles, long firstAvalable, int step) {
        if (handles.length == 0) {
            return firstAvalable;
        }
        Arrays.sort((Object[])handles);
        for (int i = 0; i < handles.length; ++i) {
            long expect = firstAvalable + (long)(i * step);
            if (handles[i] == expect) continue;
            return expect;
        }
        return handles[handles.length - 1] + (long)step;
    }

    public static String discoverableModeString(int mode) {
        if (10390323 == mode) {
            return "GIAC";
        }
        if (10390272 == mode) {
            return "LIAC";
        }
        if (0 == mode) {
            return "NOT_DISCOVERABLE";
        }
        return "0x" + Integer.toHexString(mode);
    }
}

