/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private StringUtils() {
    }

    public static String stripChar(String string, char c) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String stripChars(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String insertLineBreaks(String string, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("'maxCharsPerLine' must be >= 1");
        }
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (string.length() > n) {
            boolean bl = false;
            for (int i = n; i >= 0; --i) {
                if (!Character.isWhitespace(string.charAt(i))) continue;
                stringBuilder.append(string.substring(0, i));
                stringBuilder.append(LINE_SEPARATOR);
                string = string.substring(i + 1);
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuilder.append(string.substring(0, n));
            stringBuilder.append(LINE_SEPARATOR);
            string = string.substring(n);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String quoteSingleQuotes(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(39, 0);
        if (n != -1) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n2 = 0;
            while (n != -1) {
                stringBuilder.insert(n + n2, '\'');
                ++n2;
                n = string.indexOf(39, n + 1);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static int indexOf(String string, String string2, int n, boolean bl) {
        if (bl) {
            return string.indexOf(string2, n);
        }
        int n2 = string2.length();
        if (n >= string.length()) {
            if (string.length() == 0 && n == 0 && n2 == 0) {
                return 0;
            }
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 == 0) {
            return n;
        }
        char c = Character.toUpperCase(string2.charAt(0));
        char c2 = Character.toLowerCase(c);
        int n3 = string.length() - n2;
        int n4 = n;
        block0: while (true) {
            int n5;
            if (n4 <= n3 && (n5 = string.charAt(n4)) != c2 && n5 != c) {
                ++n4;
                continue;
            }
            if (n4 > n3) {
                return -1;
            }
            n5 = 1;
            int n6 = n4 + 1;
            int n7 = n6 + n2 - 1;
            while (n6 < n7) {
                char c3;
                char c4;
                if ((c4 = string.charAt(n6++)) == (c3 = string2.charAt(n5++)) || (c4 = Character.toUpperCase(c4)) == (c3 = Character.toLowerCase(c3)) || (c4 = Character.toLowerCase(c4)) == (c3 = Character.toLowerCase(c3))) continue;
                ++n4;
                continue block0;
            }
            break;
        }
        return n4;
    }

    public static int lastIndexOf(String string, String string2, int n, boolean bl) {
        int n2;
        if (bl) {
            return string.lastIndexOf(string2, n);
        }
        int n3 = string2.length();
        if (n < 0) {
            return -1;
        }
        int n4 = string.length() - n3;
        if (n > n4) {
            n = n4;
        }
        if (n3 == 0) {
            return n;
        }
        int n5 = n3 - 1;
        int n6 = n5 + n;
        char c = Character.toUpperCase(string2.charAt(n5));
        char c2 = Character.toLowerCase(c);
        block0: while (true) {
            int n7;
            if (n6 >= n5 && (n7 = string.charAt(n6)) != c2 && n7 != c) {
                --n6;
                continue;
            }
            if (n6 < n5) {
                return -1;
            }
            n7 = n6 - 1;
            int n8 = n5 - 1;
            n2 = n7 - n5;
            while (n7 > n2) {
                char c3;
                char c4;
                if ((c4 = string.charAt(n7--)) == (c3 = string2.charAt(n8--)) || (c4 = Character.toUpperCase(c4)) == (c3 = Character.toUpperCase(c3)) || (c4 = Character.toLowerCase(c4)) == (c3 = Character.toLowerCase(c3))) continue;
                --n6;
                continue block0;
            }
            break;
        }
        return n2 + 1;
    }

    public static boolean startsWith(String string, String string2, int n, boolean bl) {
        if (bl) {
            return string.startsWith(string2, n);
        }
        if (n < 0 || n > string.length() - string2.length()) {
            return false;
        }
        int n2 = n;
        int n3 = 0;
        int n4 = string2.length();
        while (n3 < n4) {
            char c;
            char c2;
            if ((c2 = string.charAt(n2++)) == (c = string2.charAt(n3++)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(String string, String string2, boolean bl) {
        if (bl) {
            return string.endsWith(string2);
        }
        return StringUtils.startsWith(string, string2, string.length() - string2.length(), bl);
    }

    public static boolean isWholeWord(String string, String string2) {
        return StringUtils.isWholeWord(string, string2, true);
    }

    public static boolean isWholeWord(String string, String string2, boolean bl) {
        boolean bl2 = false;
        int n = StringUtils.indexOf(string, string2, 0, false);
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = StringUtils.lastIndexOf(string, string2, n3, false);
        while (!bl2 && n > -1 && n <= n4) {
            int n5;
            bl2 = !bl ? (n > 0 && (Character.isLetterOrDigit(string.charAt(n - 1)) || string.charAt(n - 1) == '_' || string.charAt(n - 1) == '.') || n + n2 < n3 && (Character.isLetterOrDigit(string.charAt(n + n2)) || string.charAt(n + n2) == '_' || string.charAt(n + n2) == '.') ? (n > 0 && string.charAt(n - 1) == '.' || n + n2 < n3 && string.charAt(n + n2) == '.' ? ((n5 = StringUtils.indexOf(string, ".", 0, false)) + 1 < n3 ? Character.isWhitespace(string.charAt(n5 + 1)) : n - 1 <= 0 || Character.isWhitespace(string.charAt(n - 1))) : false) : true) : (n <= 0 || !Character.isLetterOrDigit(string.charAt(n - 1)) && string.charAt(n - 1) != '_') && (n + n2 >= n3 || !Character.isLetterOrDigit(string.charAt(n + n2)) && string.charAt(n + n2) != '_');
            n = StringUtils.indexOf(string, string2, n + n2, false);
        }
        return bl2;
    }

    public static String repeat(String string, int n) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer = stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String replaceAllStrings(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            throw new IllegalArgumentException("null or empty String");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = StringUtils.indexOf(string, string2, n, bl2);
        while (n2 >= 0) {
            String string4 = StringUtils.getStringToCheck(n2, string, string2.length());
            boolean bl5 = StringUtils.shouldModify(string, string4, string2, n2, bl, bl2, bl3, bl4);
            if (bl5) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string.substring(n, n2 + string2.length()));
            }
            n = n2 += string2.length();
            n2 = StringUtils.indexOf(string, string2, n, bl2);
        }
        if (n == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n));
        return new String(stringBuffer);
    }

    public static String replaceAllStrings(String string, String string2, String string3) {
        return StringUtils.replaceAllStrings(string, string2, string3, false, false);
    }

    public static String replaceAllStrings(String string, String string2, String string3, boolean bl, boolean bl2) {
        return StringUtils.replaceAllStrings(string, string2, string3, bl, bl2, true, false);
    }

    public static String surroundText(String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null || string4 == null) {
            throw new IllegalArgumentException("null or empty String");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = StringUtils.indexOf(string, string2, n, bl2);
        while (n2 >= 0) {
            String string5 = StringUtils.getStringToCheck(n2, string, string2.length());
            boolean bl5 = StringUtils.shouldModify(string, string5, string2, n2, bl, bl2, bl3, bl4);
            if (bl5) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
                stringBuffer.append(string.substring(n2, string2.length() + n2));
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(string.substring(n, n2 + string2.length()));
            }
            n = n2 += string2.length();
            n2 = StringUtils.indexOf(string, string2, n, bl2);
        }
        if (n == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n));
        return new String(stringBuffer);
    }

    private static String getStringToCheck(int n, String string, int n2) {
        String string2 = n + n2 + 2 <= string.length() ? (n != 0 ? string.substring(n - 1, n + n2 + 2) : string.substring(n, n + n2 + 2)) : (n + n2 + 1 <= string.length() ? (n != 0 ? string.substring(n - 1, n + n2 + 1) : string.substring(n, n + n2 + 1)) : (n != 0 ? string.substring(n - 1, n + n2) : string.substring(n, n + n2)));
        return string2;
    }

    private static boolean shouldModify(String string, String string2, String string3, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        if (!(bl && !StringUtils.isWholeWord(string2, string3, bl3) || bl2 && !string.substring(n, n + string3.length()).equals(string3))) {
            if (bl4) {
                int n2 = string.indexOf(60, n);
                int n3 = string.indexOf(62, n);
                if (n3 != -1 && n2 == -1) {
                    bl5 = false;
                } else if (n3 == -1 || n3 > n2) {
                    bl5 = true;
                }
            } else {
                bl5 = true;
            }
        }
        return bl5;
    }

    public static int[] findPattern(String string, int n, CharSequence charSequence) {
        if (string == null) {
            throw new IllegalArgumentException("Input pattern must not be null.");
        }
        if (charSequence == null) {
            throw new IllegalArgumentException("Input sequence must not be null.");
        }
        if (n < 0 || n > charSequence.length()) {
            throw new IllegalArgumentException("Begin position must be inside the character sequence");
        }
        int n2 = -1;
        int n3 = -1;
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(charSequence);
        boolean bl = matcher.find(n);
        if (bl) {
            n2 = matcher.start();
            n3 = matcher.end();
        }
        return new int[]{n2, n3};
    }

    public static String[] stringToArray(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public static String arrayToString(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length < 1) {
            return "";
        }
        String string2 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2.concat(string + stringArray[i]);
        }
        return string2;
    }

    public static String convertToHTML(String string, boolean bl) {
        return StringUtils.convertToHTML(string, bl, true);
    }

    public static String convertToHTML(String string, boolean bl, boolean bl2) {
        if (string.indexOf(10) == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(bl2 ? string : StringUtils.escapeASCIIEntitiesForHTML(string), "\n");
        String string2 = "";
        if (bl) {
            string2 = string2 + "&nbsp ";
        }
        if (stringTokenizer.hasMoreElements()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreElements()) {
            string2 = bl ? string2 + "&nbsp <br>&nbsp " : string2 + "<br> ";
            string2 = string2 + stringTokenizer.nextToken();
        }
        string2 = "<html>" + string2 + "</html>";
        return string2;
    }

    public static String fileNamePatternToRegex(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
        StringBuilder stringBuilder = new StringBuilder();
        if (string.startsWith("*")) {
            stringBuilder.append(".*");
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.append("\\Q");
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) == '\\') {
                    stringBuilder.append("\\\\");
                    continue;
                }
                stringBuilder.append(string2.charAt(i));
            }
            stringBuilder.append("\\E");
            if (!stringTokenizer.hasMoreTokens() && !string.endsWith("*")) continue;
            stringBuilder.append(".*");
        }
        return stringBuilder.toString();
    }

    private static String escapeASCIIEntitiesForHTML(String string) {
        if (!StringUtils.hasSpecialChars(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '/': {
                    stringBuilder.append("&frasl;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static boolean hasSpecialChars(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            block7: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        bl = true;
                        continue block7;
                    }
                    case '>': {
                        bl = true;
                        continue block7;
                    }
                    case '\"': {
                        bl = true;
                        continue block7;
                    }
                    case '&': {
                        bl = true;
                        continue block7;
                    }
                    case '/': {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public static boolean isWhitespace(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = 0;
        while (n < cArray.length && bl) {
            if (Character.isWhitespace(cArray[n])) {
                ++n;
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public static String escapeRegex(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"\\", "/", ".", "*", "+", "?", "|", "(", ")", "[", "]", "{", "}"}) {
            string = string.replace(string2, '\\' + string2);
        }
        return string;
    }

    public static List<String> split(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : string.split(string2)) {
            if ((string3 = string3.trim()).length() == 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static boolean isEmptyString(Object object) {
        return object == null || object.toString().trim().length() == 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }
}

