/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.event;

import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorListener;

public class EventUtils {
    private EventUtils() {
    }

    public static void addAWTEventListener(final AWTEventListener aWTEventListener, long l, Disposable disposable) {
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, l);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
            }
        }, disposable);
    }

    public static void addAWTEventListener(AWTEventListener aWTEventListener, long l) {
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, l);
    }

    public static void removeAWTEventListener(AWTEventListener aWTEventListener) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
    }

    public static void addAncestorListener(final JComponent jComponent, final AncestorListener ancestorListener, Disposable disposable) {
        jComponent.addAncestorListener(ancestorListener);
        Disposer.register(disposable, new Disposable(){

            @Override
            public void dispose() {
                jComponent.removeAncestorListener(ancestorListener);
            }
        });
    }

    public static void addContainerListener(final Container container, final ContainerListener containerListener, Disposable disposable) {
        container.addContainerListener(containerListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                container.removeContainerListener(containerListener);
            }
        }, disposable);
    }

    public static void addPropertyChangeListener(final Component component, final PropertyChangeListener propertyChangeListener, Disposable disposable) {
        component.addPropertyChangeListener(propertyChangeListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                component.removePropertyChangeListener(propertyChangeListener);
            }
        }, disposable);
    }

    public static void addComponentListener(final Component component, final ComponentListener componentListener, Disposable disposable) {
        component.addComponentListener(componentListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                component.removeComponentListener(componentListener);
            }
        }, disposable);
    }

    public static void addMouseListener(final Component component, final MouseListener mouseListener, Disposable disposable) {
        component.addMouseListener(mouseListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                component.removeMouseListener(mouseListener);
            }
        }, disposable);
    }

    public static void addMouseMotionListener(final Component component, final MouseMotionListener mouseMotionListener, Disposable disposable) {
        component.addMouseMotionListener(mouseMotionListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                component.removeMouseMotionListener(mouseMotionListener);
            }
        }, disposable);
    }

    public static void addFocusListener(final Component component, final FocusListener focusListener, Disposable disposable) {
        component.addFocusListener(focusListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                component.removeFocusListener(focusListener);
            }
        }, disposable);
    }

    public static void addHierarchyBoundsListener(final Component component, final HierarchyBoundsListener hierarchyBoundsListener, Disposable disposable) {
        component.addHierarchyBoundsListener(hierarchyBoundsListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                component.removeHierarchyBoundsListener(hierarchyBoundsListener);
            }
        }, disposable);
    }

    public static void addHierarchyListener(final Component component, final HierarchyListener hierarchyListener, Disposable disposable) {
        component.addHierarchyListener(hierarchyListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                component.removeHierarchyListener(hierarchyListener);
            }
        }, disposable);
    }

    public static void addKeyListener(final Component component, final KeyListener keyListener, Disposable disposable) {
        component.addKeyListener(keyListener);
        Disposer.register(new Disposable(){

            @Override
            public void dispose() {
                component.removeKeyListener(keyListener);
            }
        }, disposable);
    }
}

