/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices.dws;

import com.mathworks.internal.dws.client.v3.BitVer;
import com.mathworks.internal.dws.client.v3.DownloadServiceStub;
import com.mathworks.internal.dws.client.v3.GetUpdatedSoftwareWithinReleaseReturn;
import com.mathworks.internal.dws.client.v3.Software;
import com.mathworks.mlwebservices.DefaultService;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.mlwebservices.WSSwingWorker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.axis2.client.Stub;

public final class DownloadWebService
extends DefaultService {
    private DownloadServiceStub serviceConnection;
    private WSSwingWorker bindingThread;

    @Override
    public boolean isConnected() {
        return this.serviceConnection != null;
    }

    @Override
    public WSSwingWorker getBindingThread(String string) {
        if (this.bindingThread == null) {
            this.bindingThread = new BindingThread(string);
        }
        return this.bindingThread;
    }

    @Override
    public void disconnect() {
        this.serviceConnection = null;
    }

    @Deprecated
    public static DownloadWebService bindToWebServiceNow(String string) {
        DownloadWebService downloadWebService = new DownloadWebService(string);
        downloadWebService.bind(true);
        return downloadWebService;
    }

    private void bind(boolean bl) {
        WSSwingWorker wSSwingWorker = this.getBindingThread("Default");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<?> future = executorService.submit(wSSwingWorker);
        if (bl) {
            try {
                future.get(20000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
            }
            catch (TimeoutException timeoutException) {
                this.serviceConnection = null;
            }
        }
        executorService.shutdown();
    }

    public Collection<Software> getUpdatedSoftwareFromList(BitVer[] bitVerArray, String string) {
        ArrayList<Software> arrayList = null;
        if (this.isConnected() && bitVerArray.length > 0) {
            try {
                GetUpdatedSoftwareWithinReleaseReturn getUpdatedSoftwareWithinReleaseReturn = this.serviceConnection.getUpdatedSoftwareWithinRelease(bitVerArray, string, Locale.getDefault().toString());
                Software[] softwareArray = getUpdatedSoftwareWithinReleaseReturn.getSoftware().getSoftware();
                int n = softwareArray.length;
                arrayList = new ArrayList<Software>(n);
                arrayList.addAll(Arrays.asList(softwareArray).subList(0, n));
            }
            catch (Throwable throwable) {
                arrayList = null;
            }
        }
        return arrayList;
    }

    public Collection<Software> getLatestProductDataFromWeb(String string) {
        ArrayList<Software> arrayList = null;
        if (this.isConnected()) {
            try {
                Software[] softwareArray = this.serviceConnection.getAllUpdatedSoftware(string, Locale.getDefault().toString()).getSoftware().getSoftware();
                int n = softwareArray.length;
                arrayList = new ArrayList<Software>(n);
                arrayList.addAll(Arrays.asList(softwareArray).subList(0, n));
            }
            catch (Throwable throwable) {
                arrayList = null;
            }
        }
        return arrayList;
    }

    public void ping() {
        if (this.isConnected()) {
            try {
                this.serviceConnection.ping("");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public DownloadWebService(String string) {
        this.setEndpointURL(string);
    }

    @Override
    public String getDefaultEndpointURL() {
        return WSEndPoints.getDownloadWSEndPoint();
    }

    private final class BindingThread
    extends WSSwingWorker {
        private final String clientString;

        BindingThread(String string) {
            this.clientString = string;
        }

        @Override
        public void run() {
            DownloadServiceStub downloadServiceStub;
            try {
                String string = DownloadWebService.this.getEndpointURL();
                downloadServiceStub = new DownloadServiceStub(string);
                DownloadWebService.this.configureOptions((Stub)downloadServiceStub);
                downloadServiceStub.ping(this.clientString);
            }
            catch (Throwable throwable) {
                downloadServiceStub = null;
            }
            if (!this.isCancelled()) {
                DownloadWebService.this.serviceConnection = downloadServiceStub;
            }
        }
    }
}

