/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.databrowser;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.toolbox.shared.controllib.databrowser.WorkspaceTextSearch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class TCDataBrowser {
    private WorkspaceTextSearch fWorkspaceTextSearch;
    private Vector<TogglePanel> fBrowserPanels;
    private Vector<BrowserSplitPane> fBrowserSplitPanes;
    private MJPanel fPanel;

    public TCDataBrowser() {
        this("Unnamed Toolbox");
    }

    public TCDataBrowser(String string) {
        this.createWidgets();
        this.buildPanel();
    }

    public MJPanel getPanel() {
        return this.fPanel;
    }

    public void removePanelFromParent() {
        Container container = this.fPanel.getParent();
        if (container != null) {
            container.remove((Component)this.fPanel);
            container.validate();
            container.repaint();
        }
    }

    public void reset() {
        this.fPanel.removeAll();
        this.fPanel.revalidate();
        this.fPanel.repaint();
        this.fBrowserPanels.removeAllElements();
        this.fBrowserSplitPanes.removeAllElements();
    }

    public void move(int n, int n2) {
        TogglePanel togglePanel = this.fBrowserPanels.remove(n);
        this.fBrowserPanels.insertElementAt(togglePanel, n2);
        this.buildPanel();
    }

    public void setWorkspaceTextSearch(WorkspaceTextSearch workspaceTextSearch) {
        this.fWorkspaceTextSearch = workspaceTextSearch;
    }

    public WorkspaceTextSearch getWorkspaceTextSearch() {
        return this.fWorkspaceTextSearch;
    }

    public void setDividerLocation(final int n, final double d) {
        final int n2 = this.fBrowserSplitPanes.size() - 1;
        if (SwingUtilities.isEventDispatchThread()) {
            this.fBrowserSplitPanes.elementAt(n2 - n).setDividerLocation(d);
            this.fPanel.revalidate();
            this.fPanel.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((BrowserSplitPane)((Object)TCDataBrowser.this.fBrowserSplitPanes.elementAt(n2 - n))).setDividerLocation(d);
                    TCDataBrowser.this.fPanel.revalidate();
                    TCDataBrowser.this.fPanel.repaint();
                }
            });
        }
    }

    public void open(String string) {
        final TogglePanel togglePanel = this.findPanel(string);
        if (SwingUtilities.isEventDispatchThread()) {
            togglePanel.setOpen(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    togglePanel.setOpen(true);
                }
            });
        }
    }

    public void close(String string) {
        final TogglePanel togglePanel = this.findPanel(string);
        if (SwingUtilities.isEventDispatchThread()) {
            togglePanel.setOpen(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    togglePanel.setOpen(false);
                }
            });
        }
    }

    public void createWidgets() {
        this.fPanel = new MJPanel();
        this.fBrowserPanels = new Vector();
        this.fBrowserSplitPanes = new Vector();
    }

    public void addPanel(String string, String string2, JComponent jComponent) {
        this.fBrowserPanels.add(new TogglePanel(string, string2, jComponent));
        this.buildPanel();
    }

    public void removePanel(String string) {
        TogglePanel togglePanel = this.findPanel(string);
        if (togglePanel == null) {
            return;
        }
        this.fBrowserPanels.remove((Object)togglePanel);
        if (SwingUtilities.isEventDispatchThread()) {
            this.buildPanel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TCDataBrowser.this.buildPanel();
                }
            });
        }
    }

    private TogglePanel findPanel(String string) {
        if (string == null) {
            return null;
        }
        for (TogglePanel togglePanel : this.fBrowserPanels) {
            if (!togglePanel.getName().equals(string)) continue;
            return togglePanel;
        }
        return null;
    }

    public int getPanelCount() {
        return this.fBrowserPanels.size();
    }

    public void buildPanel() {
        this.fPanel.setLayout((LayoutManager)new BorderLayout());
        this.fPanel.setVisible(true);
        this.fPanel.removeAll();
        if (this.fWorkspaceTextSearch != null) {
            this.fPanel.add((Component)this.fWorkspaceTextSearch.getPanel(), (Object)"First");
        }
        if (this.getPanelCount() == 0) {
            return;
        }
        if (this.getPanelCount() == 1) {
            this.fPanel.add((Component)((Object)this.fBrowserPanels.elementAt(0)), (Object)"Center");
        } else {
            this.fPanel.add(this.recursiveBuild(0), (Object)"Center");
        }
        this.fPanel.revalidate();
        this.fPanel.repaint();
    }

    private Component recursiveBuild(int n) {
        int n2;
        int n3;
        if (n == 0) {
            this.fBrowserSplitPanes.removeAllElements();
        }
        BrowserSplitPane browserSplitPane = (n3 = n + 1) == (n2 = this.fBrowserPanels.size() - 1) ? new BrowserSplitPane(0, true, (Component)((Object)this.fBrowserPanels.elementAt(n)), (Component)((Object)this.fBrowserPanels.elementAt(n3))) : new BrowserSplitPane(0, true, (Component)((Object)this.fBrowserPanels.elementAt(n)), this.recursiveBuild(n3));
        browserSplitPane.setQENames(n);
        return browserSplitPane;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TCDataBrowser tCDataBrowser = new TCDataBrowser();
                MJFrame mJFrame = new MJFrame("Unit Testing Frame - A Data Browser");
                mJFrame.getContentPane().setLayout(new FlowLayout());
                mJFrame.setContentPane((Container)tCDataBrowser.getPanel());
                mJFrame.setSize(500, 500);
                mJFrame.setLocationRelativeTo(null);
                mJFrame.setDefaultCloseOperation(2);
                mJFrame.setVisible(true);
            }
        });
    }

    private class BrowserSplitPane
    extends MJSplitPane {
        public BrowserSplitPane(int n, boolean bl, Component component, Component component2) {
            super(n, bl, component, component2);
            this.setDividerSize(4);
            this.setBorder(null);
            this.setResizeWeight(0.0);
            TCDataBrowser.this.fBrowserSplitPanes.add(this);
            double d = 1.0 / (double)(TCDataBrowser.this.fBrowserSplitPanes.size() + 1);
            this.setDividerLocation(d);
        }

        public void collapse(final boolean bl) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setDividerLocation(this.getCollapsedLocation(bl));
                if (bl) {
                    this.setDividerSize(4);
                    this.setEnabled(true);
                } else {
                    this.setDividerSize(0);
                    this.setEnabled(false);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BrowserSplitPane.this.setDividerLocation(BrowserSplitPane.this.getCollapsedLocation(bl));
                        if (bl) {
                            BrowserSplitPane.this.setDividerSize(2);
                            BrowserSplitPane.this.setEnabled(true);
                        } else {
                            BrowserSplitPane.this.setDividerSize(0);
                            BrowserSplitPane.this.setEnabled(false);
                        }
                    }
                });
            }
        }

        public int getCollapsedLocation(boolean bl) {
            int n = this.getLastDividerLocation();
            if (bl) {
                if (n != -1 && n != 0) {
                    return n;
                }
                return this.getMaximumDividerLocation();
            }
            return this.getMinimumDividerLocation();
        }

        public void setQENames(int n) {
            String string = "SplitPaneQE" + Integer.valueOf(n).toString();
            String string2 = "DividerQE" + Integer.valueOf(n).toString();
            this.setName(string);
            this.getComponent(2).setName(string2);
        }
    }

    private class TogglePanel
    extends MJPanel {
        private String fName;
        private String fTitle;
        private final JComponent fComponent;
        private final ToggleButton fButton;

        public TogglePanel(String string, String string2, JComponent jComponent) {
            super((LayoutManager)new BorderLayout());
            this.fButton = new ToggleButton();
            this.fComponent = jComponent;
            this.setName(string);
            this.setTitle(string2);
            MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
            mJPanel.add((Component)((Object)this.fButton), (Object)"Center");
            mJPanel.setBorder(BorderFactory.createEtchedBorder());
            this.add((Component)mJPanel, "North");
            this.add(this.fComponent, "Center");
            this.setOpen(true);
        }

        public boolean isOpen() {
            return this.fComponent.isVisible();
        }

        public void setOpen(final boolean bl) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (this.fButton.isSelected() != bl) {
                    this.fButton.setSelected(bl);
                }
                this.fComponent.revalidate();
                this.fComponent.setVisible(bl);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TogglePanel.this.fButton.isSelected() != bl) {
                            TogglePanel.this.fButton.setSelected(bl);
                        }
                        TogglePanel.this.fComponent.revalidate();
                        TogglePanel.this.fComponent.setVisible(bl);
                    }
                });
            }
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String string) {
            if (string != null && !string.equals(this.fName)) {
                this.fName = string;
                super.setName(string);
                this.fButton.setName(string + "Button");
            }
        }

        public String getTitle() {
            return this.fTitle;
        }

        public void setTitle(final String string) {
            if (string != null && !string.equals(this.fTitle)) {
                this.fTitle = string;
                if (SwingUtilities.isEventDispatchThread()) {
                    this.fButton.setText(string);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TogglePanel.this.fButton.setText(string);
                        }
                    });
                }
            }
        }

        public JComponent getComponent() {
            return this.fComponent;
        }

        public int getIndex() {
            return TCDataBrowser.this.fBrowserPanels.indexOf((Object)this);
        }

        public void setEnabled(final boolean bl) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.fComponent.setEnabled(bl);
                this.fButton.setEnabled(bl);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TogglePanel.this.fComponent.setEnabled(bl);
                        TogglePanel.this.fButton.setEnabled(bl);
                    }
                });
            }
        }

        public ImageIcon makeImage(String string) {
            URL uRL = TogglePanel.class.getResource("resources/" + string);
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                return imageIcon;
            }
            return null;
        }

        private class ToggleButton
        extends MJCheckBox {
            private ImageIcon rightArrow;
            private ImageIcon downArrow;
            protected ActionListener arrowBtnLsnr = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ToggleButton.this.setSelected(ToggleButton.this.isSelected());
                }
            };

            public ToggleButton() {
                this.rightArrow = TogglePanel.this.makeImage("medium_right_arrow.gif");
                this.downArrow = TogglePanel.this.makeImage("medium_down_arrow.gif");
                this.setFocusPainted(true);
                this.setBorderPainted(false);
                this.setIcon(this.rightArrow);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.addActionListener(this.arrowBtnLsnr);
            }

            public void setSelected(boolean bl) {
                super.setSelected(bl);
                TogglePanel.this.setOpen(bl);
                this.setIcon(bl ? this.downArrow : this.rightArrow);
                if (this.isLastPanel()) {
                    return;
                }
                MJSplitPane mJSplitPane = (MJSplitPane)TogglePanel.this.getParent();
                if (mJSplitPane != null && mJSplitPane instanceof MJSplitPane) {
                    ((BrowserSplitPane)mJSplitPane).collapse(bl);
                }
            }

            private boolean isLastPanel() {
                return TogglePanel.this.getIndex() + 1 == TCDataBrowser.this.getPanelCount();
            }
        }
    }
}

