/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.databrowser;

import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.jmi.Callback;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.services.ColorPrefs;
import com.mathworks.toolbox.shared.controllib.databrowser.FullRLTCellRenderer;
import com.mathworks.toolbox.shared.controllib.databrowser.IDataBrowser;
import com.mathworks.toolbox.shared.controllib.databrowser.IDataBrowserActionProvider;
import com.mathworks.toolbox.shared.controllib.databrowser.NoSelectionPopupMenu;
import com.mathworks.toolbox.shared.controllib.databrowser.SelectionPopupMenu;
import com.mathworks.toolbox.shared.controllib.databrowser.TCWorkspaceModel;
import com.mathworks.toolbox.shared.controllib.databrowser.VariableSelection;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.recordlist.IRecordIconProvider;
import com.mathworks.widgets.recordlist.IRecordSecondaryIconProvider;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistTable;
import com.mathworks.widgets.recordlist.RecordlistTableModel;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TCWorkspaceTable
implements IDataBrowser {
    private WSTable fWSTable;
    private MJPanel fPanel;
    private String fTitle;
    private MJPopupMenu fSelectionPopupMenu = null;
    private MJPopupMenu fNoSelectionPopupMenu = null;
    private MJScrollPane fScrollPane = null;
    private TCWorkspaceModel fRecordlistModel;
    private TableModel fTableModel;
    private UDDObject fMATLABPeer;
    private Callback fTransferEventsToMATLAB = new Callback();
    private Callback fVariableSelectionEventsToMATLAB = new Callback();
    private VariableSelectionListener fVariableSelectionListener;
    private MyDragGestureListener fMyDragGestureListener;
    private DragGestureRecognizer fMyDragGestureRecognizer;
    protected MJAbstractAction fPastingAction = null;
    private int fRowHighlightIDX = -1;
    private int fColumnHighlightIDX = -1;
    private Color fHiliteColor;

    public TCWorkspaceTable() {
        this.createWidgets();
        this.attachListeners();
        this.fPanel = this.buildPanel();
    }

    public MJPanel getPanel() {
        return this.fPanel;
    }

    public NoSelectionPopupMenu getNoSelectionPopupMenu() {
        return (NoSelectionPopupMenu)this.fNoSelectionPopupMenu;
    }

    public SelectionPopupMenu getSelectionPopupMenu() {
        return (SelectionPopupMenu)this.fSelectionPopupMenu;
    }

    public void removePanelFromParent() {
        this.fMATLABPeer = null;
        Container container = this.fPanel.getParent();
        if (container != null) {
            container.remove((Component)this.fPanel);
            container.repaint();
        }
        this.cleanup();
    }

    public UDDObject getMATLABPeer() {
        return this.fMATLABPeer;
    }

    public void setMATLABPeer(UDDObject uDDObject) {
        this.fMATLABPeer = uDDObject;
        this.getTCWorkspaceModel().setMATLABPeer(uDDObject);
    }

    public Callback getTransferEventsToMATLAB() {
        return this.fTransferEventsToMATLAB;
    }

    public Callback getVariableSelectionEventsToMATLAB() {
        return this.fVariableSelectionEventsToMATLAB;
    }

    public TCWorkspaceModel getTCWorkspaceModel() {
        if (this.fRecordlistModel instanceof TCWorkspaceModel) {
            return this.fRecordlistModel;
        }
        return null;
    }

    public void showColumn(String string) {
        if (string.equalsIgnoreCase("value")) {
            this.fWSTable.showField(this.fRecordlistModel.VALUE());
        }
        if (string.equalsIgnoreCase("size")) {
            this.fWSTable.showField(this.fRecordlistModel.SIZE());
        }
        if (string.equalsIgnoreCase("bytes")) {
            this.fWSTable.showField(this.fRecordlistModel.BYTES());
        }
        if (string.equalsIgnoreCase("class")) {
            this.fWSTable.showField(this.fRecordlistModel.CLASS());
        }
    }

    public void hideColumn(String string) {
        if (string.equalsIgnoreCase("value")) {
            this.fWSTable.hideField(this.fRecordlistModel.VALUE());
        }
        if (string.equalsIgnoreCase("size")) {
            this.fWSTable.hideField(this.fRecordlistModel.SIZE());
        }
        if (string.equalsIgnoreCase("bytes")) {
            this.fWSTable.hideField(this.fRecordlistModel.BYTES());
        }
        if (string.equalsIgnoreCase("class")) {
            this.fWSTable.hideField(this.fRecordlistModel.CLASS());
        }
    }

    @Override
    public void setTitle(String string) {
        this.fTitle = string;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    public void notifyMATLABAboutTransfer(TransferHandlerEventData transferHandlerEventData) {
        this.fTransferEventsToMATLAB.postCallback(new Object[]{transferHandlerEventData});
    }

    public void notifyMATLABAboutVariableSelection(String[] stringArray) {
        this.fVariableSelectionEventsToMATLAB.postCallback((Object[])stringArray);
    }

    public void createWidgets() {
        this.fRecordlistModel = new TCWorkspaceModel();
        this.fWSTable = new WSTable((IRecordlistModel)this.fRecordlistModel);
        this.fWSTable.setName("WSTableQE");
        this.fWSTable.hideField(1);
        this.fWSTable.hideField(2);
        this.fWSTable.hideField(3);
        this.fWSTable.setDefaultRenderer(Object.class, new MyTableCellRenderer(2, (IRecordIconProvider)this.fRecordlistModel, null));
        this.fWSTable.setDefaultRenderer(Number.class, new MyTableCellRenderer(4, (IRecordIconProvider)this.fRecordlistModel, null));
        TableColumnModel tableColumnModel = this.fWSTable.getColumnModel();
        for (int i = 0; i < this.fWSTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(130);
        }
        this.fPastingAction = new PastingAction();
        this.fSelectionPopupMenu = new SelectionPopupMenu(this);
        this.fWSTable.setSelectionPopupMenu(this.fSelectionPopupMenu);
        this.fNoSelectionPopupMenu = new NoSelectionPopupMenu(this.fWSTable);
        this.fWSTable.setNoSelectionPopupMenu(this.fNoSelectionPopupMenu);
        this.fWSTable.setFillsViewportHeight(true);
        this.fWSTable.setTransferHandler(new WorkspaceTransferHandler());
        this.fWSTable.setDragEnabled(false);
        this.fWSTable.setDropMode(DropMode.INSERT_ROWS);
        this.fMyDragGestureListener = new MyDragGestureListener();
        this.fMyDragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)this.fWSTable), 3, this.fMyDragGestureListener);
        this.fWSTable.enableDragHandling(true);
        this.fScrollPane = new MJScrollPane((Component)((Object)this.fWSTable));
        this.fScrollPane.setHorizontalScrollBarPolicy(30);
        this.fScrollPane.setVerticalScrollBarPolicy(20);
        this.setColors();
        this.fTableModel = this.fWSTable.getModel();
    }

    public void attachListeners() {
        this.fVariableSelectionListener = new VariableSelectionListener();
        this.fWSTable.getSelectionModel().addListSelectionListener(this.fVariableSelectionListener);
    }

    public MJPanel buildPanel() {
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BorderLayout());
        mJPanel.add((Component)this.fScrollPane, (Object)"Center");
        mJPanel.setVisible(true);
        return mJPanel;
    }

    public WSTable getWSTable() {
        return this.fWSTable;
    }

    private void setColors() {
        Color color = ColorPrefs.getTextColor();
        Color color2 = ColorPrefs.getBackgroundColor();
        JViewport jViewport = this.fScrollPane.getViewport();
        this.fWSTable.setForeground(color);
        ((Component)jViewport).setForeground(color);
        this.fWSTable.setBackground(color2);
        ((Component)jViewport).setBackground(color2);
    }

    public void hilite(String string) {
        for (int i = 0; i < this.getTCWorkspaceModel().getRecordCount(); ++i) {
            String string2 = (String)this.fWSTable.getModel().getValueAt(i, this.getTCWorkspaceModel().getPrimaryFieldIndex());
            if (!string2.equals(string)) continue;
            this.fRowHighlightIDX = i;
            this.fColumnHighlightIDX = this.fWSTable.convertColumnIndexToView(this.getTCWorkspaceModel().getPrimaryFieldIndex());
        }
        Thread thread = new Thread(){
            int fRow;
            int fCol;
            int fRed;
            int fGreen;
            int fBlue;
            float fHue;
            float fSaturation;
            float fBrightness;
            int fAlpha;
            float fOne2Zero;
            int MAX_ITERATIONS;
            {
                this.fRow = TCWorkspaceTable.this.fRowHighlightIDX;
                this.fCol = TCWorkspaceTable.this.fColumnHighlightIDX;
                this.fHue = 0.14166667f;
                this.fSaturation = 1.0f;
                this.fBrightness = 1.0f;
                this.MAX_ITERATIONS = 40;
            }

            @Override
            public void run() {
                for (int i = 0; i <= this.MAX_ITERATIONS; ++i) {
                    try {
                        TCWorkspaceTable.this.fRowHighlightIDX = this.fRow;
                        TCWorkspaceTable.this.fColumnHighlightIDX = this.fCol;
                        this.fOne2Zero = (float)((Math.cos(0.314159 * (double)i) + 1.0) / 2.0);
                        this.fAlpha = 200 - (int)(this.fOne2Zero * 72.0f);
                        this.fBrightness = (float)(0.99 + (double)this.fOne2Zero * 0.01);
                        this.fSaturation = (float)(0.1 + (double)this.fOne2Zero * 0.9);
                        TCWorkspaceTable.this.fHiliteColor = Color.getHSBColor(this.fHue, this.fSaturation, this.fBrightness);
                        this.fRed = TCWorkspaceTable.this.fHiliteColor.getRed();
                        this.fGreen = TCWorkspaceTable.this.fHiliteColor.getGreen();
                        this.fBlue = TCWorkspaceTable.this.fHiliteColor.getBlue();
                        TCWorkspaceTable.this.fHiliteColor = new Color(this.fRed, this.fGreen, this.fBlue, this.fAlpha);
                        if (TCWorkspaceTable.this.fWSTable != null) {
                            TCWorkspaceTable.this.fWSTable.repaint();
                        } else {
                            i = this.MAX_ITERATIONS;
                        }
                        1.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    if (TCWorkspaceTable.this.fWSTable != null) {
                        if (!TCWorkspaceTable.this.fWSTable.isFocusOwner()) continue;
                        i = this.MAX_ITERATIONS;
                        continue;
                    }
                    i = this.MAX_ITERATIONS;
                }
                TCWorkspaceTable.this.fRowHighlightIDX = -1;
                TCWorkspaceTable.this.fColumnHighlightIDX = -1;
            }
        };
        thread.start();
    }

    public String[] getVariableNamesFromViewIndices(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.fWSTable.getModel().getValueAt(nArray[i], this.getTCWorkspaceModel().getPrimaryFieldIndex());
        }
        return stringArray;
    }

    public void pasteSelection() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (!transferable.isDataFlavorSupported(new DataFlavor(UDDObject.class, "UDDObject"))) {
            return;
        }
        this.fWSTable.getTransferHandler().importData(new TransferHandler.TransferSupport((Component)((Object)this.fWSTable), transferable));
    }

    private void cleanup() {
        if (this.fWSTable != null) {
            this.fWSTable.setNoSelectionPopupMenu(null);
            this.fWSTable.setSelectionPopupMenu(null);
            this.fWSTable.setTransferHandler(null);
            ((MyTableCellRenderer)this.fWSTable.getDefaultRenderer(Object.class)).cleanup();
            ((MyTableCellRenderer)this.fWSTable.getDefaultRenderer(Number.class)).cleanup();
            this.fWSTable.setDefaultRenderer(Object.class, null);
            this.fWSTable.setDefaultRenderer(Number.class, null);
            this.fWSTable.getSelectionModel().removeListSelectionListener(this.fVariableSelectionListener);
            this.fVariableSelectionListener = null;
            this.fWSTable = null;
        }
        if (this.fMyDragGestureRecognizer != null) {
            this.fMyDragGestureRecognizer.removeDragGestureListener(this.fMyDragGestureListener);
            this.fMyDragGestureRecognizer = null;
            this.fMyDragGestureListener = null;
        }
        if (this.fPastingAction != null) {
            ((PastingAction)this.fPastingAction).cleanup();
            this.fPastingAction = null;
        }
        if (this.fNoSelectionPopupMenu != null) {
            ((NoSelectionPopupMenu)this.fNoSelectionPopupMenu).cleanup();
            this.fNoSelectionPopupMenu = null;
        }
        if (this.fRecordlistModel != null) {
            this.fRecordlistModel.cleanup();
            this.fRecordlistModel = null;
        }
        this.fSelectionPopupMenu = null;
        this.fPanel = null;
        this.fScrollPane = null;
        this.fTableModel = null;
        this.fMATLABPeer = null;
        this.fTransferEventsToMATLAB = null;
        this.fVariableSelectionEventsToMATLAB = null;
        this.fHiliteColor = null;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TCWorkspaceTable tCWorkspaceTable = new TCWorkspaceTable();
                MJFrame mJFrame = new MJFrame("Unit Testing Frame - Workspace Table");
                mJFrame.getContentPane().setLayout(new FlowLayout());
                mJFrame.setContentPane((Container)tCWorkspaceTable.getPanel());
                mJFrame.setSize(500, 500);
                mJFrame.setLocationRelativeTo(null);
                mJFrame.setDefaultCloseOperation(2);
                mJFrame.setVisible(true);
            }
        });
    }

    private class VariableSelectionListener
    implements ListSelectionListener {
        private VariableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            boolean bl = listSelectionEvent.getValueIsAdjusting();
            if (!listSelectionModel.isSelectionEmpty()) {
                int[] nArray = TCWorkspaceTable.this.fWSTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = TCWorkspaceTable.this.fWSTable.convertRowIndexToModel(nArray[i]);
                }
                String[] stringArray = TCWorkspaceTable.this.getVariableNamesFromViewIndices(nArray);
                TCWorkspaceTable.this.notifyMATLABAboutVariableSelection(stringArray);
            }
        }
    }

    private class WorkspaceTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        private WorkspaceTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            RecordlistTable recordlistTable = (RecordlistTable)jComponent;
            int[] nArray = recordlistTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = recordlistTable.convertRowIndexToModel(nArray[i]);
            }
            String[] stringArray = TCWorkspaceTable.this.getVariableNamesFromViewIndices(nArray);
            return new VariableSelection(stringArray, TCWorkspaceTable.this.getMATLABPeer());
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            super.exportDone(jComponent, transferable, n);
        }

        @Override
        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            super.exportAsDrag(jComponent, inputEvent, n);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            if (!transferSupport.isDataFlavorSupported(new DataFlavor(UDDObject.class, "UDDObject"))) {
                return false;
            }
            if (transferSupport.isDrop()) {
                transferSupport.setShowDropLocation(false);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            if (!this.canImport(transferSupport)) {
                return false;
            }
            Transferable transferable = transferSupport.getTransferable();
            try {
                String[] stringArray = (String[])transferable.getTransferData(new DataFlavor(String[].class, "StringArray"));
                UDDObject uDDObject = (UDDObject)transferable.getTransferData(new DataFlavor(UDDObject.class, "UDDObject"));
                String string = transferSupport.isDrop() ? (transferSupport.getUserDropAction() == 2 ? "MOVE" : "COPY") : "PASTE";
                TransferHandlerEventData transferHandlerEventData = new TransferHandlerEventData(stringArray, uDDObject, string);
                if (stringArray.length != 0) {
                    TCWorkspaceTable.this.notifyMATLABAboutTransfer(transferHandlerEventData);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public Icon getVisualRepresentation(Transferable transferable) {
            return super.getVisualRepresentation(transferable);
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
            super.exportToClipboard(jComponent, clipboard, n);
        }
    }

    private class MyDragGestureListener
    implements DragGestureListener {
        private MyDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            TransferHandler transferHandler = TCWorkspaceTable.this.fWSTable.getTransferHandler();
            transferHandler.exportAsDrag((JComponent)((Object)TCWorkspaceTable.this.fWSTable), dragGestureEvent.getTriggerEvent(), 1);
        }
    }

    private class TransferHandlerEventData {
        public UDDObject graphicalcomponent;
        public String[] selected_variables;
        public String action;

        private TransferHandlerEventData(String[] stringArray, UDDObject uDDObject, String string) {
            this.selected_variables = stringArray;
            this.graphicalcomponent = uDDObject;
            this.action = string;
        }
    }

    public class PastingAction
    extends MJAbstractAction {
        private static final long serialVersionUID = -5198711332703260988L;
        private FlavorListener fFlavorListener;

        public PastingAction() {
            this.setAccelerator(KeyStroke.getKeyStroke(86, 128));
            String string = XMLMessageSystem.getBundle((String)"Controllib:databrowser").getString("PasteText");
            this.setName(string);
            this.setComponentName("Paste");
            this.setEnabled(this.isPasteAllowed());
            this.fFlavorListener = new FlavorListener(){

                @Override
                public void flavorsChanged(FlavorEvent flavorEvent) {
                    PastingAction.this.setEnabled(PastingAction.this.isPasteAllowed());
                }
            };
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.addFlavorListener(this.fFlavorListener);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TCWorkspaceTable.this.pasteSelection();
        }

        private boolean isPasteAllowed() {
            boolean bl;
            if (PlatformInfo.isMacintosh()) {
                return true;
            }
            try {
                bl = Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(new DataFlavor(UDDObject.class, "UDDObject"));
            }
            catch (IllegalStateException illegalStateException) {
                bl = this.isEnabled();
            }
            return bl;
        }

        public void cleanup() {
            Toolkit.getDefaultToolkit().getSystemClipboard().removeFlavorListener(this.fFlavorListener);
            this.fFlavorListener = null;
        }
    }

    private class WSTable
    extends RecordlistTable
    implements IDataBrowserActionProvider {
        private static final long serialVersionUID = 1L;

        private WSTable(IRecordlistModel iRecordlistModel) {
            this(new RecordlistTableModel(iRecordlistModel), null);
        }

        private WSTable(IRecordlistModel iRecordlistModel, String string) {
            this(new RecordlistTableModel(iRecordlistModel), string);
        }

        private WSTable(RecordlistTableModel recordlistTableModel, String string) {
            super(recordlistTableModel, string);
        }

        public MJAbstractAction getAction(int n) {
            MJAbstractAction mJAbstractAction = null;
            mJAbstractAction = n == 1000 ? TCWorkspaceTable.this.fPastingAction : super.getAction(n);
            return mJAbstractAction;
        }
    }

    private class MyTableCellRenderer
    extends FullRLTCellRenderer {
        public MyTableCellRenderer(int n, IRecordIconProvider iRecordIconProvider, IRecordSecondaryIconProvider iRecordSecondaryIconProvider) {
            super(n, iRecordIconProvider, iRecordSecondaryIconProvider);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!jTable.isFocusOwner() && TCWorkspaceTable.this.fRowHighlightIDX != -1 && TCWorkspaceTable.this.fColumnHighlightIDX != -1 && n == TCWorkspaceTable.this.fRowHighlightIDX && n2 == TCWorkspaceTable.this.fColumnHighlightIDX) {
                this.getfReal().setBackground(TCWorkspaceTable.this.fHiliteColor);
                this.setPrimaryIcon(this.hiliteIcon(this.getfPrimaryIconLabel().getIcon()));
                if (object instanceof String) {
                    this.getfReal().setText((String)object);
                }
            }
            return component;
        }

        public Icon hiliteIcon(Icon icon) {
            if (!(icon instanceof ImageIcon)) {
                return icon;
            }
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
            graphics2D.setComposite(AlphaComposite.SrcAtop);
            graphics2D.setColor(TCWorkspaceTable.this.fHiliteColor);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.dispose();
            return new ImageIcon(bufferedImage);
        }
    }
}

