/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.databrowser.editor;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.MatlabArrayTableModel;
import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IPrintingOpProvider;
import com.mathworks.widgets.spreadsheet.ISaveOpProvider;
import com.mathworks.widgets.spreadsheet.ISelectionOpProvider;
import com.mathworks.widgets.text.print.MultiHeaderTextPrinter;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Scanner;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class UnsupportedClassTextArea
extends MJTextArea
implements IClipboardOpProvider,
ISelectionOpProvider,
ISaveOpProvider,
IPrintingOpProvider,
UpdatableData {
    protected String fVar;
    protected Color fNormalForegroundColor;
    private boolean fCurrentlyDisplayingError = false;
    private final MJAbstractAction fSaveAction;
    private final TextAreaCopyAction fCopyAction;
    private final MJAbstractAction fPageSetupAction;
    private final MJAbstractAction fPrintAction;
    private final MJAbstractAction fPrintSelectionAction;
    private final MInputMap fInputMap;
    private static final String DOESNOTEXISTPLACEHOLDER = "DOESNOTEXISTPLACEHOLDER";
    private String fMessage;

    UnsupportedClassTextArea(MatlabArrayTableModel matlabArrayTableModel) {
        this(matlabArrayTableModel.getVariableName());
    }

    UnsupportedClassTextArea(String string) {
        this.fVar = string;
        this.fNormalForegroundColor = this.getForeground();
        this.setEditable(false);
        TextAreaActionProvider textAreaActionProvider = new TextAreaActionProvider();
        this.fInputMap = MInputMap.createMInputMap((JComponent)((Object)this));
        this.fSaveAction = ArrayUtils.getSaveAction((String)this.fVar, (ArrayUtils.SaveActionProvider)textAreaActionProvider);
        this.fCopyAction = new TextAreaCopyAction();
        this.fPageSetupAction = new ArrayUtils.PageSetupAction((ArrayUtils.PrintActionProvider)textAreaActionProvider);
        this.fPrintSelectionAction = new TextAreaPrintSelectionAction(textAreaActionProvider);
        this.fPrintAction = new ArrayUtils.PrintAction((ArrayUtils.PrintActionProvider)textAreaActionProvider);
    }

    public String getVariableName() {
        return this.fVar;
    }

    public void rename(String string) {
        this.fVar = string;
        this.updateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        int n = 0;
        if (Matlab.getExecutionStatus((int)n) == 0) {
            this.fCurrentlyDisplayingError = false;
            this.setForeground(this.fNormalForegroundColor);
        } else {
            this.fCurrentlyDisplayingError = true;
            this.setForeground(Color.red);
        }
        StringBuilder stringBuilder = new StringBuilder();
        try (Scanner scanner = new Scanner(this.fMessage);){
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine();
                if (string.contains("<a href=\"matlab:")) continue;
                stringBuilder.append(string).append(System.getProperty("line.separator"));
            }
        }
        this.setText(stringBuilder.toString());
    }

    public void setMessage(String string) {
        this.fMessage = string;
    }

    public String getMessage() {
        return this.fMessage;
    }

    void clear() {
        this.setText("");
    }

    public void setForeground(Color color) {
        this.fNormalForegroundColor = color;
        if (!this.fCurrentlyDisplayingError) {
            super.setForeground(color);
        }
    }

    public Color getForeground() {
        return this.fNormalForegroundColor;
    }

    public final Action getCutAction() {
        return null;
    }

    public final Action getCopyAction() {
        return this.fCopyAction;
    }

    public final Action getPasteAction() {
        return null;
    }

    public final Action getExcelPasteAction() {
        return null;
    }

    public final Action getSelectAllAction() {
        return this.fCopyAction;
    }

    private void registerWithInputMap(MJAbstractAction mJAbstractAction) {
        assert (MatlabKeyBindings.getManager().containsActionAndContext((Action)mJAbstractAction)) : "Action is not registered in keybinding manager";
        MatlabKeyBindings.getManager().addKeyBindings((ExtendedAction)mJAbstractAction, (ExtendedInputMap)this.fInputMap);
        MatlabKeyBindings.getManager().addToActionMap((ExtendedAction)mJAbstractAction, this.getActionMap());
    }

    public final Action getSaveAction() {
        return this.fSaveAction;
    }

    private static String getMainHeaderText(String string) {
        return ArrayUtils.getResource((String)"printing.pageTitle", (String)string) + "\t" + ArrayUtils.getResource((String)"printing.header.pg") + " ";
    }

    protected void printTextArea() {
        String string = this.getVariableName();
        MultiHeaderTextPrinter.printPlainText((JTextArea)((Object)this), (Font)this.getFont(), (String)ArrayUtils.getResource((String)"printing.pageTitle", (String)string), (String)UnsupportedClassTextArea.getMainHeaderText(string));
    }

    protected void printSelection() {
        String string = this.getVariableName();
        MultiHeaderTextPrinter.printPlainTextSelection((JTextArea)((Object)this), (Font)this.getFont(), (String)ArrayUtils.getResource((String)"printing.pageTitle", (String)string), (String)UnsupportedClassTextArea.getMainHeaderText(string));
    }

    protected void pageSetup() {
        PrintUtils.showPageSetupDialog((String)ArrayUtils.getResource((String)"printing.pageTitle"));
    }

    public final Action getPrintAction() {
        return this.fPrintAction;
    }

    public final Action getPrintSelectionAction() {
        return this.fPrintSelectionAction;
    }

    public final Action getPageSetupAction() {
        return this.fPageSetupAction;
    }

    private class TextAreaActionProvider
    implements ArrayUtils.PrintActionProvider,
    ArrayUtils.SaveActionProvider {
        private TextAreaActionProvider() {
        }

        public void printSelection() {
            UnsupportedClassTextArea.this.printSelection();
        }

        public void print() {
            UnsupportedClassTextArea.this.printTextArea();
        }

        public void pageSetup() {
            UnsupportedClassTextArea.this.pageSetup();
        }

        public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
            UnsupportedClassTextArea.this.registerWithInputMap(mJAbstractAction);
        }

        public Component getComponentForDialog() {
            return UnsupportedClassTextArea.this;
        }
    }

    private class TextAreaPrintSelectionAction
    extends ArrayUtils.PrintSelectionAction
    implements CaretListener {
        TextAreaPrintSelectionAction(ArrayUtils.PrintActionProvider printActionProvider) {
            super(printActionProvider);
            UnsupportedClassTextArea.this.addCaretListener(this);
            this.updateEnabledState();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.updateEnabledState();
        }

        private void updateEnabledState() {
            this.setEnabled(UnsupportedClassTextArea.this.getSelectedText() != null);
        }
    }

    private class TextAreaCopyAction
    extends MJAbstractAction
    implements CaretListener {
        TextAreaCopyAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("SpreadsheetTable", "copy-to-clipboard", (ExtendedAction)this);
            this.setComponentName("Copy");
            UnsupportedClassTextArea.this.registerWithInputMap(this);
            UnsupportedClassTextArea.this.addCaretListener(this);
            this.updateEnabledState();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.updateEnabledState();
        }

        private void updateEnabledState() {
            this.setEnabled(UnsupportedClassTextArea.this.getSelectedText() != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = UnsupportedClassTextArea.this.getSelectedText();
            if (PlatformInfo.isXWindows()) {
                MJClipboard.getMJClipboard().setXSelectionContents(string);
            }
            MJClipboard.getMJClipboard().setContents(string, null);
        }
    }
}

