/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.mozilla.classfile.ByteCode;
import org.mozilla.classfile.ClassFileField;
import org.mozilla.classfile.ClassFileMethod;
import org.mozilla.classfile.ConstantPool;
import org.mozilla.classfile.ExceptionTableEntry;
import org.mozilla.classfile.JavaVariable;
import org.mozilla.javascript.LabelTable;

public class ClassFileWriter {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    private ExceptionTableEntry[] OEAB;
    private int acquireLabel;
    private int[] add;
    private int addClass;
    private byte[] addConstant;
    private int addElement;
    private ConstantPool addFieldRef;
    private ClassFileMethod addInterfaceMethodRef;
    private short addLabelFixup;
    private short addMethodRef;
    private short addToCodeBuffer;
    private Vector addUtf8 = new Vector();
    private Vector append = new Vector();
    private Vector arraycopy = new Vector();
    private short charAt;
    private short clearLabels;
    private short elementAt;
    private short fixLabelGotos;
    private LabelTable getCatchType = new LabelTable();

    public ClassFileWriter(String string, String string2, String string3) {
        this.addFieldRef = new ConstantPool();
        this.clearLabels = this.addFieldRef.addClass(string);
        this.elementAt = this.addFieldRef.addClass(string2);
        if (string3 != null) {
            this.fixLabelGotos = this.addFieldRef.addUtf8(string3);
        }
        this.charAt = 1;
    }

    public void addInterface(String string) {
        short s = this.addFieldRef.addClass(string);
        this.arraycopy.addElement(new Short(s));
    }

    public void setFlags(short s) {
        this.charAt = s;
    }

    public static String fullyQualifiedForm(String string) {
        return string.replace('.', '/');
    }

    public void addField(String string, String string2, short s) {
        short s2 = this.addFieldRef.addUtf8(string);
        short s3 = this.addFieldRef.addUtf8(string2);
        this.append.addElement(new ClassFileField(s2, s3, s));
    }

    public void addField(String string, String string2, short s, int n) {
        short s2 = this.addFieldRef.addUtf8(string);
        short s3 = this.addFieldRef.addUtf8(string2);
        short[] sArray = new short[]{this.addFieldRef.addUtf8("ConstantValue"), 0, 2, this.addFieldRef.addConstant(n)};
        this.append.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void addField(String string, String string2, short s, long l) {
        short s2 = this.addFieldRef.addUtf8(string);
        short s3 = this.addFieldRef.addUtf8(string2);
        short[] sArray = new short[]{this.addFieldRef.addUtf8("ConstantValue"), 0, 2, this.addFieldRef.addConstant(l)};
        this.append.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void addField(String string, String string2, short s, double d) {
        short s2 = this.addFieldRef.addUtf8(string);
        short s3 = this.addFieldRef.addUtf8(string2);
        short[] sArray = new short[]{this.addFieldRef.addUtf8("ConstantValue"), 0, 2, this.addFieldRef.addConstant(d)};
        this.append.addElement(new ClassFileField(s2, s3, s, sArray));
    }

    public void startMethod(String string, String string2, short s) {
        short s2 = this.addFieldRef.addUtf8(string);
        short s3 = this.addFieldRef.addUtf8(string2);
        this.addInterfaceMethodRef = new ClassFileMethod(s2, s3, s);
        this.addUtf8.addElement(this.addInterfaceMethodRef);
    }

    public void stopMethod(short s, JavaVariable[] javaVariableArray) {
        int n;
        int n2;
        int n3;
        short s2;
        int n4;
        if (this.addInterfaceMethodRef == null) {
            throw new RuntimeException("No method to stop");
        }
        this.getCatchType.fixLabelGotos(this.addConstant);
        this.addToCodeBuffer = s;
        int n5 = 0;
        if (this.add != null) {
            n5 = 8 + this.addClass * 4;
        }
        int n6 = 0;
        if (javaVariableArray != null) {
            n6 = 8 + javaVariableArray.length * 10;
        }
        int n7 = 14 + this.addElement + 2 + this.acquireLabel * 8 + 2 + n5 + n6;
        byte[] byArray = new byte[n7];
        int n8 = 0;
        short s3 = this.addFieldRef.addUtf8("Code");
        byArray[n8++] = (byte)(s3 >> 8);
        byArray[n8++] = (byte)s3;
        byArray[n8++] = (byte)((n7 -= 6) >> 24);
        byArray[n8++] = (byte)(n7 >> 16);
        byArray[n8++] = (byte)(n7 >> 8);
        byArray[n8++] = (byte)n7;
        byArray[n8++] = (byte)(this.addMethodRef >> 8);
        byArray[n8++] = (byte)this.addMethodRef;
        byArray[n8++] = (byte)(this.addToCodeBuffer >> 8);
        byArray[n8++] = (byte)this.addToCodeBuffer;
        byArray[n8++] = (byte)(this.addElement >> 24);
        byArray[n8++] = (byte)(this.addElement >> 16);
        byArray[n8++] = (byte)(this.addElement >> 8);
        byArray[n8++] = (byte)this.addElement;
        System.arraycopy(this.addConstant, 0, byArray, n8, this.addElement);
        n8 += this.addElement;
        if (this.acquireLabel > 0) {
            byArray[n8++] = (byte)(this.acquireLabel >> 8);
            byArray[n8++] = (byte)this.acquireLabel;
            n4 = 0;
            while (n4 < this.acquireLabel) {
                s2 = this.OEAB[n4].getStartPC(this.getCatchType);
                byArray[n8++] = (byte)(s2 >> 8);
                byArray[n8++] = (byte)s2;
                n3 = this.OEAB[n4].getEndPC(this.getCatchType);
                byArray[n8++] = (byte)(n3 >> 8);
                byArray[n8++] = (byte)n3;
                n2 = this.OEAB[n4].getHandlerPC(this.getCatchType);
                byArray[n8++] = (byte)(n2 >> 8);
                byArray[n8++] = (byte)n2;
                n = this.OEAB[n4].getCatchType();
                byArray[n8++] = (byte)(n >> 8);
                byArray[n8++] = (byte)n;
                ++n4;
            }
        } else {
            byArray[n8++] = 0;
            byArray[n8++] = 0;
        }
        n4 = 0;
        if (this.add != null) {
            ++n4;
        }
        if (javaVariableArray != null) {
            ++n4;
        }
        byArray[n8++] = 0;
        byArray[n8++] = (byte)n4;
        if (this.add != null) {
            s2 = this.addFieldRef.addUtf8("LineNumberTable");
            byArray[n8++] = (byte)(s2 >> 8);
            byArray[n8++] = (byte)s2;
            n3 = 2 + this.addClass * 4;
            byArray[n8++] = (byte)(n3 >> 24);
            byArray[n8++] = (byte)(n3 >> 16);
            byArray[n8++] = (byte)(n3 >> 8);
            byArray[n8++] = (byte)n3;
            byArray[n8++] = (byte)(this.addClass >> 8);
            byArray[n8++] = (byte)this.addClass;
            n2 = 0;
            while (n2 < this.addClass) {
                byArray[n8++] = (byte)(this.add[n2] >> 24);
                byArray[n8++] = (byte)(this.add[n2] >> 16);
                byArray[n8++] = (byte)(this.add[n2] >> 8);
                byArray[n8++] = (byte)this.add[n2];
                ++n2;
            }
        }
        if (javaVariableArray != null) {
            s2 = this.addFieldRef.addUtf8("LocalVariableTable");
            byArray[n8++] = (byte)(s2 >> 8);
            byArray[n8++] = (byte)s2;
            n3 = javaVariableArray.length;
            n2 = 2 + n3 * 10;
            byArray[n8++] = (byte)(n2 >> 24);
            byArray[n8++] = (byte)(n2 >> 16);
            byArray[n8++] = (byte)(n2 >> 8);
            byArray[n8++] = (byte)n2;
            byArray[n8++] = (byte)(n3 >> 8);
            byArray[n8++] = (byte)n3;
            n = 0;
            while (n < n3) {
                JavaVariable javaVariable = javaVariableArray[n];
                int n9 = javaVariable.getStartPC();
                byArray[n8++] = (byte)(n9 >> 8);
                byArray[n8++] = (byte)n9;
                int n10 = this.addElement - n9;
                byArray[n8++] = (byte)(n10 >> 8);
                byArray[n8++] = (byte)n10;
                short s4 = this.addFieldRef.addUtf8(javaVariable.getName());
                byArray[n8++] = (byte)(s4 >> 8);
                byArray[n8++] = (byte)s4;
                String string = javaVariable.getTypeDescriptor();
                short s5 = this.addFieldRef.addUtf8(string);
                byArray[n8++] = (byte)(s5 >> 8);
                byArray[n8++] = (byte)s5;
                short s6 = javaVariable.getJRegister();
                byArray[n8++] = (byte)(s6 >> 8);
                byArray[n8++] = (byte)s6;
                ++n;
            }
        }
        this.addInterfaceMethodRef.setCodeAttribute(byArray);
        this.OEAB = null;
        this.acquireLabel = 0;
        this.add = null;
        this.addElement = 0;
        this.addInterfaceMethodRef = null;
        this.addMethodRef = 0;
        this.addLabelFixup = 0;
        this.getCatchType.clearLabels();
    }

    public void add(byte by) {
        if (ByteCode.opcodeCount(by) != 0) {
            throw new RuntimeException("Unexpected operands");
        }
        this.addToCodeBuffer(by);
        this.addLabelFixup = (short)(this.addLabelFixup + ByteCode.stackChange(by));
        if (this.addLabelFixup < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.addLabelFixup > this.addMethodRef) {
            this.addMethodRef = this.addLabelFixup;
        }
    }

    public void add(byte by, int n) {
        this.addLabelFixup = (short)(this.addLabelFixup + ByteCode.stackChange(by));
        if (this.addLabelFixup < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.addLabelFixup > this.addMethodRef) {
            this.addMethodRef = this.addLabelFixup;
        }
        switch (by) {
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -58: 
            case -57: {
                if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE && (n < 0 || n > 65535)) {
                    throw new RuntimeException("Bad label for branch");
                }
                int n2 = this.addElement;
                this.addToCodeBuffer(by);
                if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                int n3 = n & Integer.MAX_VALUE;
                int n4 = this.getCatchType.getLabelPC(n3);
                if (n4 != -1) {
                    short s = (short)(n4 - n2);
                    this.addToCodeBuffer((byte)(s >> 8));
                    this.addToCodeBuffer((byte)s);
                    break;
                }
                this.getCatchType.addLabelFixup(n3, n2 + 1);
                this.addToCodeBuffer((byte)0);
                this.addToCodeBuffer((byte)0);
                break;
            }
            case 16: {
                if (n < -128 || n > 127) {
                    throw new RuntimeException("out of range byte");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case 17: {
                if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                    throw new RuntimeException("out of range short");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -68: {
                if (n < 0 || n > 255) {
                    throw new RuntimeException("out of range index");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -76: 
            case -75: {
                if (n < 0 || n > 65535) {
                    throw new RuntimeException("out of range field");
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                if (n < 0 || n > 65535) {
                    throw new RuntimeException("out of range index");
                }
                if (n >= 256 || by == 19 || by == 20) {
                    if (by == 18) {
                        this.addToCodeBuffer((byte)19);
                    } else {
                        this.addToCodeBuffer(by);
                    }
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            case -87: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                if (n < 0 || n > 65535) {
                    throw new RuntimeException("out of range variable");
                }
                if (n >= 256) {
                    this.addToCodeBuffer((byte)-60);
                    this.addToCodeBuffer(by);
                    this.addToCodeBuffer((byte)(n >> 8));
                    this.addToCodeBuffer((byte)n);
                    break;
                }
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)n);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected opcode for 1 operand");
            }
        }
    }

    public void addLoadConstant(int n) {
        this.add((byte)18, this.addFieldRef.addConstant(n));
    }

    public void addLoadConstant(long l) {
        this.add((byte)20, this.addFieldRef.addConstant(l));
    }

    public void addLoadConstant(float f) {
        this.add((byte)18, this.addFieldRef.addConstant(f));
    }

    public void addLoadConstant(double d) {
        this.add((byte)20, this.addFieldRef.addConstant(d));
    }

    public void addLoadConstant(String string) {
        this.add((byte)18, this.addFieldRef.addConstant(string));
    }

    public void add(byte by, int n, int n2) {
        this.addLabelFixup = (short)(this.addLabelFixup + ByteCode.stackChange(by));
        if (this.addLabelFixup < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.addLabelFixup > this.addMethodRef) {
            this.addMethodRef = this.addLabelFixup;
        }
        if (by == -124) {
            if (n < 0 || n > 65535) {
                throw new RuntimeException("out of range variable");
            }
            if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
                throw new RuntimeException("out of range increment");
            }
            if (n > 255 || n2 < -128 || n2 > 127) {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)(n >> 8));
                this.addToCodeBuffer((byte)n);
                this.addToCodeBuffer((byte)(n2 >> 8));
                this.addToCodeBuffer((byte)n2);
            } else {
                this.addToCodeBuffer((byte)-60);
                this.addToCodeBuffer((byte)-124);
                this.addToCodeBuffer((byte)n);
                this.addToCodeBuffer((byte)n2);
            }
        } else if (by == -59) {
            if (n < 0 || n > 65535) {
                throw new RuntimeException("out of range index");
            }
            if (n2 < 0 || n2 > 255) {
                throw new RuntimeException("out of range dimensions");
            }
            this.addToCodeBuffer((byte)-59);
            this.addToCodeBuffer((byte)(n >> 8));
            this.addToCodeBuffer((byte)n);
            this.addToCodeBuffer((byte)n2);
        } else {
            throw new RuntimeException("Unexpected opcode for 2 operands");
        }
    }

    public void add(byte by, String string) {
        this.addLabelFixup = (short)(this.addLabelFixup + ByteCode.stackChange(by));
        if (this.addLabelFixup < 0) {
            throw new RuntimeException("Stack underflow");
        }
        switch (by) {
            case -69: 
            case -67: 
            case -64: 
            case -63: {
                short s = this.addFieldRef.addClass(string);
                this.addToCodeBuffer(by);
                this.addToCodeBuffer((byte)(s >> 8));
                this.addToCodeBuffer((byte)s);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for class reference");
            }
        }
        if (this.addLabelFixup > this.addMethodRef) {
            this.addMethodRef = this.addLabelFixup;
        }
    }

    public void add(byte by, String string, String string2, String string3) {
        this.addLabelFixup = (short)(this.addLabelFixup + ByteCode.stackChange(by));
        if (this.addLabelFixup < 0) {
            throw new RuntimeException("After " + Integer.toHexString(by & 0xFF) + " Stack underflow");
        }
        char c = string3.charAt(0);
        int n = c == 'J' || c == 'D' ? 2 : 1;
        switch (by) {
            case -78: 
            case -76: {
                this.addLabelFixup = (short)(this.addLabelFixup + n);
                break;
            }
            case -77: 
            case -75: {
                this.addLabelFixup = (short)(this.addLabelFixup - n);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for field reference");
            }
        }
        short s = this.addFieldRef.addFieldRef(string, string2, string3);
        this.addToCodeBuffer(by);
        this.addToCodeBuffer((byte)(s >> 8));
        this.addToCodeBuffer((byte)s);
        if (this.addLabelFixup > this.addMethodRef) {
            this.addMethodRef = this.addLabelFixup;
        }
    }

    public void add(byte by, String string, String string2, String string3, String string4) {
        int n = this.acquireLabel(string3);
        this.addLabelFixup = (short)(this.addLabelFixup - (n & 0xFFFF));
        this.addLabelFixup = (short)(this.addLabelFixup + ByteCode.stackChange(by));
        if (this.addLabelFixup < 0) {
            throw new RuntimeException("After " + Integer.toHexString(by & 0xFF) + " Stack underflow");
        }
        if (this.addLabelFixup > this.addMethodRef) {
            this.addMethodRef = this.addLabelFixup;
        }
        switch (by) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                char c = string4.charAt(0);
                if (c != 'V') {
                    this.addLabelFixup = c == 'J' || c == 'D' ? (short)(this.addLabelFixup + 2) : (short)(this.addLabelFixup + 1);
                }
                this.addToCodeBuffer(by);
                if (by == -71) {
                    short s = this.addFieldRef.addInterfaceMethodRef(string, string2, string3 + string4);
                    this.addToCodeBuffer((byte)(s >> 8));
                    this.addToCodeBuffer((byte)s);
                    this.addToCodeBuffer((byte)((n >> 16) + 1));
                    this.addToCodeBuffer((byte)0);
                    break;
                }
                short s = this.addFieldRef.addMethodRef(string, string2, string3 + string4);
                this.addToCodeBuffer((byte)(s >> 8));
                this.addToCodeBuffer((byte)s);
                break;
            }
            default: {
                throw new RuntimeException("bad opcode for method reference");
            }
        }
        if (this.addLabelFixup > this.addMethodRef) {
            this.addMethodRef = this.addLabelFixup;
        }
    }

    public int acquireLabel() {
        return this.getCatchType.acquireLabel() | Integer.MIN_VALUE;
    }

    public void markLabel(int n) {
        if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad label, no biscuit");
        }
        this.getCatchType.markLabel(n & Integer.MAX_VALUE, this.addElement);
    }

    public void markLabel(int n, short s) {
        if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad label, no biscuit");
        }
        this.addLabelFixup = s;
        this.getCatchType.markLabel(n & Integer.MAX_VALUE, this.addElement);
    }

    public void markHandler(int n) {
        this.addLabelFixup = 1;
        this.markLabel(n);
    }

    public int getCurrentCodeOffset() {
        return this.addElement;
    }

    public short getStackTop() {
        return this.addLabelFixup;
    }

    public void adjustStackTop(int n) {
        this.addLabelFixup = (short)(this.addLabelFixup + n);
        if (this.addLabelFixup < 0) {
            throw new RuntimeException("Stack underflow");
        }
        if (this.addLabelFixup > this.addMethodRef) {
            this.addMethodRef = this.addLabelFixup;
        }
    }

    public void addToCodeBuffer(byte by) {
        if (this.addInterfaceMethodRef == null) {
            throw new RuntimeException("No method to add to");
        }
        if (this.addConstant == null) {
            this.addConstant = new byte[128];
            this.addConstant[0] = by;
            this.addElement = 1;
        } else {
            if (this.addElement == this.addConstant.length) {
                byte[] byArray = this.addConstant;
                this.addConstant = new byte[this.addElement * 2];
                System.arraycopy(byArray, 0, this.addConstant, 0, this.addElement);
            }
            this.addConstant[this.addElement++] = by;
        }
    }

    public void addExceptionHandler(int n, int n2, int n3, String string) {
        if ((n & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad startLabel");
        }
        if ((n2 & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad endLabel");
        }
        if ((n3 & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            throw new RuntimeException("Bad handlerLabel");
        }
        ExceptionTableEntry exceptionTableEntry = new ExceptionTableEntry(n, n2, n3, string == null ? (short)0 : this.addFieldRef.addClass(string));
        if (this.OEAB == null) {
            this.OEAB = new ExceptionTableEntry[4];
            this.OEAB[0] = exceptionTableEntry;
            this.acquireLabel = 1;
        } else {
            if (this.acquireLabel == this.OEAB.length) {
                ExceptionTableEntry[] exceptionTableEntryArray = this.OEAB;
                this.OEAB = new ExceptionTableEntry[this.acquireLabel * 2];
                System.arraycopy(exceptionTableEntryArray, 0, this.OEAB, 0, this.acquireLabel);
            }
            this.OEAB[this.acquireLabel++] = exceptionTableEntry;
        }
    }

    public void addLineNumberEntry(short s) {
        if (this.addInterfaceMethodRef == null) {
            throw new RuntimeException("No method to stop");
        }
        if (this.add == null) {
            this.add = new int[16];
            this.add[0] = (this.addElement << 16) + s;
            this.addClass = 1;
        } else {
            if (this.addClass == this.add.length) {
                int[] nArray = this.add;
                this.add = new int[this.addClass * 2];
                System.arraycopy(nArray, 0, this.add, 0, this.addClass);
            }
            this.add[this.addClass++] = (this.addElement << 16) + s;
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        short s = 0;
        if (this.fixLabelGotos != 0) {
            s = this.addFieldRef.addUtf8("SourceFile");
        }
        dataOutputStream.writeLong(-3819410108756852691L);
        this.addFieldRef.write(dataOutputStream);
        dataOutputStream.writeShort(this.charAt);
        dataOutputStream.writeShort(this.clearLabels);
        dataOutputStream.writeShort(this.elementAt);
        dataOutputStream.writeShort(this.arraycopy.size());
        int n = 0;
        while (n < this.arraycopy.size()) {
            dataOutputStream.writeShort(((Short)this.arraycopy.elementAt(n)).shortValue());
            ++n;
        }
        dataOutputStream.writeShort(this.append.size());
        int n2 = 0;
        while (n2 < this.append.size()) {
            ((ClassFileField)this.append.elementAt(n2)).write(dataOutputStream);
            ++n2;
        }
        dataOutputStream.writeShort(this.addUtf8.size());
        int n3 = 0;
        while (n3 < this.addUtf8.size()) {
            ((ClassFileMethod)this.addUtf8.elementAt(n3)).write(dataOutputStream);
            ++n3;
        }
        if (this.fixLabelGotos != 0) {
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(s);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeShort(this.fixLabelGotos);
        } else {
            dataOutputStream.writeShort(0);
        }
    }

    private int OEAB() {
        int n = 0;
        if (this.fixLabelGotos != 0) {
            this.addFieldRef.addUtf8("SourceFile");
        }
        n += 8;
        n += this.addFieldRef.getWriteSize();
        n += 2;
        n += 2;
        n += 2;
        n += 2;
        n += 2 * this.arraycopy.size();
        n += 2;
        int n2 = 0;
        while (n2 < this.append.size()) {
            n += ((ClassFileField)this.append.elementAt(n2)).getWriteSize();
            ++n2;
        }
        n += 2;
        int n3 = 0;
        while (n3 < this.addUtf8.size()) {
            n += ((ClassFileMethod)this.addUtf8.elementAt(n3)).getWriteSize();
            ++n3;
        }
        if (this.fixLabelGotos != 0) {
            n += 2;
            n += 2;
            n += 4;
            n += 2;
        } else {
            n += 2;
        }
        return n;
    }

    public byte[] toByteArray() {
        int n = this.OEAB();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            this.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length != n) {
            throw new RuntimeException();
        }
        return byArray;
    }

    private int acquireLabel(String string) {
        if (string.charAt(0) != '(') {
            throw new RuntimeException("Bad parameter signature");
        }
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        while (string.charAt(n) != ')') {
            switch (string.charAt(n)) {
                case 'D': 
                case 'J': {
                    ++n2;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    ++n3;
                    ++n;
                    break;
                }
                case '[': {
                    while (string.charAt(n) == '[') {
                        ++n;
                    }
                    if (string.charAt(n) != 'L') {
                        ++n2;
                        ++n3;
                        ++n;
                        break;
                    }
                }
                case 'L': {
                    ++n2;
                    ++n3;
                    while (string.charAt(n++) != ';') {
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Bad signature character");
                }
            }
        }
        return n3 << 16 | n2;
    }
}

