/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaObject
implements Scriptable,
Wrapper,
Externalizable {
    static final int JSTYPE_UNDEFINED = 0;
    static final int JSTYPE_NULL = 1;
    static final int JSTYPE_BOOLEAN = 2;
    static final int JSTYPE_NUMBER = 3;
    static final int JSTYPE_STRING = 4;
    static final int JSTYPE_JAVA_CLASS = 5;
    static final int JSTYPE_JAVA_OBJECT = 6;
    static final int JSTYPE_JAVA_ARRAY = 7;
    static final int JSTYPE_OBJECT = 8;
    public static final byte CONVERSION_TRIVIAL = 1;
    public static final byte CONVERSION_NONTRIVIAL = 0;
    public static final byte CONVERSION_NONE = 99;
    protected Scriptable prototype;
    protected Scriptable parent;
    protected Object javaObject;
    protected Class staticType;
    protected JavaMembers members;
    private Hashtable ByteClass;

    public NativeJavaObject() {
    }

    public NativeJavaObject(Scriptable scriptable, Object object, Class clazz) {
        this.parent = scriptable;
        this.javaObject = object;
        this.staticType = clazz;
        this.initMembers();
    }

    protected void initMembers() {
        Class<?> clazz = this.javaObject != null ? this.javaObject.getClass() : this.staticType;
        this.members = JavaMembers.lookupClass(this.parent, clazz, this.staticType);
        this.ByteClass = this.members.getFieldAndMethodsObjects(this, this.javaObject, false);
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.members.has(string, false);
    }

    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    public Object get(String string, Scriptable scriptable) {
        Object v;
        if (this.ByteClass != null && (v = this.ByteClass.get(string)) != null) {
            return v;
        }
        return this.members.get(this, string, this.javaObject, false);
    }

    public Object get(int n, Scriptable scriptable) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (this.prototype == null || this.members.has(string, false)) {
            this.members.put(this, string, this.javaObject, object, false);
        } else {
            this.prototype.put(string, this.prototype, object);
        }
    }

    public void put(int n, Scriptable scriptable, Object object) {
        throw this.members.reportMemberNotFound(Integer.toString(n));
    }

    public boolean hasInstance(Scriptable scriptable) {
        return false;
    }

    public void delete(String string) {
    }

    public void delete(int n) {
    }

    public Scriptable getPrototype() {
        if (this.prototype == null && this.javaObject instanceof String) {
            return ScriptableObject.getClassPrototype(this.parent, "String");
        }
        return this.prototype;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public Object[] getIds() {
        return this.members.getIds(false);
    }

    public static Object wrap(Scriptable scriptable, Object object, Class clazz) {
        Context context = Context.getContext();
        return context.getWrapFactory().wrap(context, scriptable, object, clazz);
    }

    public Object unwrap() {
        return this.javaObject;
    }

    public String getClassName() {
        return "JavaObject";
    }

    Function getConverter(String string) {
        Object object = this.get(string, (Scriptable)this);
        if (object instanceof Function) {
            return (Function)object;
        }
        return null;
    }

    Object callConverter(Function function) throws JavaScriptException {
        Function function2 = function;
        return function2.call(Context.getContext(), function2.getParentScope(), this, ScriptRuntime.emptyArgs);
    }

    Object callConverter(String string) throws JavaScriptException {
        Function function = this.getConverter(string);
        if (function == null) {
            return this.javaObject.toString();
        }
        return this.callConverter(function);
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.javaObject.toString();
        }
        try {
            if (clazz == ScriptRuntime.BooleanClass) {
                return this.callConverter("booleanValue");
            }
            if (clazz == ScriptRuntime.NumberClass) {
                return this.callConverter("doubleValue");
            }
        }
        catch (JavaScriptException javaScriptException) {
            // empty catch block
        }
        throw Context.reportRuntimeError0("msg.default.value");
    }

    public static boolean canConvert(Object object, Class clazz) {
        int n = NativeJavaObject.getConversionWeight(object, clazz);
        return n < 99;
    }

    public static int getConversionWeight(Object object, Class clazz) {
        int n = NativeJavaObject.getJSTypeCode(object);
        int n2 = 99;
        switch (n) {
            case 0: {
                if (clazz != ScriptRuntime.StringClass && clazz != ScriptRuntime.ObjectClass) break;
                n2 = 1;
                break;
            }
            case 1: {
                if (clazz.isPrimitive()) break;
                n2 = 1;
                break;
            }
            case 2: {
                if (clazz == Boolean.TYPE) {
                    n2 = 1;
                    break;
                }
                if (clazz == ScriptRuntime.BooleanClass) {
                    n2 = 2;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n2 = 3;
                    break;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                n2 = 4;
                break;
            }
            case 3: {
                if (clazz.isPrimitive()) {
                    if (clazz == Double.TYPE) {
                        n2 = 1;
                        break;
                    }
                    if (clazz == Boolean.TYPE) break;
                    n2 = 1 + NativeJavaObject.getSizeRank(clazz);
                    break;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    n2 = 9;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n2 = 10;
                    break;
                }
                if (!ScriptRuntime.NumberClass.isAssignableFrom(clazz)) break;
                n2 = 2;
                break;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass) {
                    n2 = 1;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass || clazz == ScriptRuntime.SerializableClass || clazz == ScriptRuntime.ComparableClass) {
                    n2 = 2;
                    break;
                }
                if (!clazz.isPrimitive() || clazz == Boolean.TYPE) break;
                if (clazz == Character.TYPE) {
                    n2 = 3;
                    break;
                }
                n2 = 4;
                break;
            }
            case 5: {
                if (clazz == ScriptRuntime.ClassClass) {
                    n2 = 1;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n2 = 3;
                    break;
                }
                if (clazz != ScriptRuntime.StringClass) break;
                n2 = 4;
                break;
            }
            case 6: 
            case 7: {
                if (clazz == ScriptRuntime.StringClass) {
                    n2 = 2;
                    break;
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE) {
                    n2 = n == 7 ? 0 : 2 + NativeJavaObject.getSizeRank(clazz);
                    break;
                }
                Object object2 = object;
                if (object2 instanceof Wrapper) {
                    object2 = ((Wrapper)object2).unwrap();
                }
                if (!clazz.isInstance(object2)) break;
                n2 = 0;
                break;
            }
            case 8: {
                if (object instanceof NativeArray && clazz.isArray()) {
                    n2 = 1;
                    break;
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    n2 = 2;
                    break;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    n2 = 3;
                    break;
                }
                if (!clazz.isPrimitive() && clazz == Boolean.TYPE) break;
                n2 = 3 + NativeJavaObject.getSizeRank(clazz);
            }
        }
        return n2;
    }

    static int getSizeRank(Class clazz) {
        if (clazz == Double.TYPE) {
            return 1;
        }
        if (clazz == Float.TYPE) {
            return 2;
        }
        if (clazz == Long.TYPE) {
            return 3;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Short.TYPE) {
            return 5;
        }
        if (clazz == Character.TYPE) {
            return 6;
        }
        if (clazz == Byte.TYPE) {
            return 7;
        }
        if (clazz == Boolean.TYPE) {
            return 99;
        }
        return 8;
    }

    static int getJSTypeCode(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == Undefined.instance) {
            return 0;
        }
        if (object instanceof Scriptable) {
            if (object instanceof NativeJavaClass) {
                return 5;
            }
            if (object instanceof NativeJavaArray) {
                return 7;
            }
            if (object instanceof NativeJavaObject) {
                return 6;
            }
            return 8;
        }
        Class<?> clazz = object.getClass();
        if (clazz == ScriptRuntime.StringClass) {
            return 4;
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return 2;
        }
        if (object instanceof Number) {
            return 3;
        }
        if (clazz == ScriptRuntime.ClassClass) {
            return 5;
        }
        if (clazz.isArray()) {
            return 7;
        }
        return 6;
    }

    public static Object coerceType(Class clazz, Object object) {
        return NativeJavaObject.coerceType(clazz, object, true);
    }

    static Object coerceType(Class clazz, Object object, boolean bl) {
        if (object != null && object.getClass() == clazz) {
            return object;
        }
        switch (NativeJavaObject.getJSTypeCode(object)) {
            case 1: {
                if (clazz.isPrimitive()) {
                    NativeJavaObject.reportConversionError(object, clazz, !bl);
                }
                return null;
            }
            case 0: {
                if (clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.ObjectClass) {
                    return "undefined";
                }
                NativeJavaObject.reportConversionError("undefined", clazz, !bl);
                break;
            }
            case 2: {
                if (clazz == Boolean.TYPE || clazz == ScriptRuntime.BooleanClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 3: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz == ScriptRuntime.ObjectClass) {
                    return NativeJavaObject.coerceToNumber(Double.TYPE, object, bl);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 4: {
                if (clazz == ScriptRuntime.StringClass || clazz == ScriptRuntime.ObjectClass || clazz == ScriptRuntime.SerializableClass || clazz == ScriptRuntime.ComparableClass) {
                    return object;
                }
                if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
                    if (((String)object).length() == 1) {
                        return new Character(((String)object).charAt(0));
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                if (clazz.isPrimitive() && clazz != Boolean.TYPE || ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 5: {
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz == ScriptRuntime.ClassClass || clazz == ScriptRuntime.ObjectClass) {
                    return object;
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 6: 
            case 7: {
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz, !bl);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                if (object instanceof Wrapper) {
                    object = ((Wrapper)object).unwrap();
                }
                if (clazz == ScriptRuntime.StringClass) {
                    return object.toString();
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
                break;
            }
            case 8: {
                if (clazz == ScriptRuntime.StringClass) {
                    return ScriptRuntime.toString(object);
                }
                if (clazz.isPrimitive()) {
                    if (clazz == Boolean.TYPE) {
                        NativeJavaObject.reportConversionError(object, clazz, !bl);
                    }
                    return NativeJavaObject.coerceToNumber(clazz, object, bl);
                }
                if (clazz.isInstance(object)) {
                    return object;
                }
                if (clazz.isArray() && object instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)object;
                    long l = nativeArray.getLength();
                    Class<?> clazz2 = clazz.getComponentType();
                    Object object2 = Array.newInstance(clazz2, (int)l);
                    int n = 0;
                    while ((long)n < l) {
                        try {
                            Array.set(object2, n, NativeJavaObject.coerceType(clazz2, nativeArray.get(n, (Scriptable)nativeArray), bl));
                        }
                        catch (EvaluatorException evaluatorException) {
                            NativeJavaObject.reportConversionError(object, clazz, !bl);
                        }
                        ++n;
                    }
                    return object2;
                }
                if (object instanceof Wrapper) {
                    if (clazz.isInstance(object = ((Wrapper)object).unwrap())) {
                        return object;
                    }
                    NativeJavaObject.reportConversionError(object, clazz, !bl);
                    break;
                }
                NativeJavaObject.reportConversionError(object, clazz, !bl);
            }
        }
        return object;
    }

    static Object coerceToNumber(Class clazz, Object object, boolean bl) {
        Class<?> clazz2 = object.getClass();
        if (clazz == Character.TYPE || clazz == ScriptRuntime.CharacterClass) {
            if (clazz2 == ScriptRuntime.CharacterClass) {
                return object;
            }
            return new Character((char)NativeJavaObject.toInteger(object, ScriptRuntime.CharacterClass, 0.0, 65535.0, bl));
        }
        if (clazz == ScriptRuntime.ObjectClass || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return clazz2 == ScriptRuntime.DoubleClass ? object : new Double(NativeJavaObject.toDouble(object, bl));
        }
        if (clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE) {
            if (clazz2 == ScriptRuntime.FloatClass) {
                return object;
            }
            double d = NativeJavaObject.toDouble(object, bl);
            if (Double.isInfinite(d) || Double.isNaN(d) || d == 0.0) {
                return new Float((float)d);
            }
            double d2 = Math.abs(d);
            if (d2 < (double)1.4E-45f) {
                return new Float(d > 0.0 ? 0.0 : -0.0);
            }
            if (d2 > 3.4028234663852886E38) {
                return new Float(d > 0.0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
            }
            return new Float((float)d);
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            if (clazz2 == ScriptRuntime.IntegerClass) {
                return object;
            }
            return new Integer((int)NativeJavaObject.toInteger(object, ScriptRuntime.IntegerClass, -2.147483648E9, 2.147483647E9, bl));
        }
        if (clazz == ScriptRuntime.LongClass || clazz == Long.TYPE) {
            if (clazz2 == ScriptRuntime.LongClass) {
                return object;
            }
            double d = Double.longBitsToDouble(4890909195324358655L);
            double d3 = Double.longBitsToDouble(-4332462841530417152L);
            return new Long(NativeJavaObject.toInteger(object, ScriptRuntime.LongClass, d3, d, bl));
        }
        if (clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE) {
            if (clazz2 == ScriptRuntime.ShortClass) {
                return object;
            }
            return new Short((short)NativeJavaObject.toInteger(object, ScriptRuntime.ShortClass, -32768.0, 32767.0, bl));
        }
        if (clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE) {
            if (clazz2 == ScriptRuntime.ByteClass) {
                return object;
            }
            return new Byte((byte)NativeJavaObject.toInteger(object, ScriptRuntime.ByteClass, -128.0, 127.0, bl));
        }
        return new Double(NativeJavaObject.toDouble(object, bl));
    }

    static double toDouble(Object object, boolean bl) {
        Method method;
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return ScriptRuntime.toNumber((String)object);
        }
        if (object instanceof Scriptable) {
            if (object instanceof Wrapper) {
                return NativeJavaObject.toDouble(((Wrapper)object).unwrap(), bl);
            }
            return ScriptRuntime.toNumber(object);
        }
        try {
            method = object.getClass().getMethod("doubleValue", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        if (method != null) {
            try {
                return ((Number)method.invoke(object, null)).doubleValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE, !bl);
            }
            catch (InvocationTargetException invocationTargetException) {
                NativeJavaObject.reportConversionError(object, Double.TYPE, !bl);
            }
        }
        return ScriptRuntime.toNumber(object.toString());
    }

    static long toInteger(Object object, Class clazz, double d, double d2, boolean bl) {
        double d3 = NativeJavaObject.toDouble(object, bl);
        if (Double.isInfinite(d3) || Double.isNaN(d3)) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz, !bl);
        }
        if ((d3 = d3 > 0.0 ? Math.floor(d3) : Math.ceil(d3)) < d || d3 > d2) {
            NativeJavaObject.reportConversionError(ScriptRuntime.toString(object), clazz, !bl);
        }
        return (long)d3;
    }

    static void reportConversionError(Object object, Class clazz, boolean bl) {
        if (bl) {
            throw new IllegalArgumentException("Cannot convert " + object + " to type " + clazz);
        }
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", object.toString(), NativeJavaMethod.javaSignature(clazz));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.prototype);
        objectOutput.writeObject(this.parent);
        if (this.javaObject != null) {
            Class<?> clazz = this.javaObject.getClass();
            if (clazz.getName().startsWith("adapter")) {
                objectOutput.writeBoolean(true);
                objectOutput.writeObject(clazz.getSuperclass().getName());
                Class<?>[] classArray = clazz.getInterfaces();
                String[] stringArray = new String[classArray.length];
                int n = 0;
                while (n < classArray.length) {
                    stringArray[n] = classArray[n].getName();
                    ++n;
                }
                objectOutput.writeObject(stringArray);
                try {
                    Object object = clazz.getField("delegee").get(this.javaObject);
                    Object object2 = clazz.getField("self").get(this.javaObject);
                    objectOutput.writeObject(object);
                    objectOutput.writeObject(object2);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            } else {
                objectOutput.writeBoolean(false);
                objectOutput.writeObject(this.javaObject);
            }
        } else {
            objectOutput.writeBoolean(false);
            objectOutput.writeObject(this.javaObject);
        }
        if (this.staticType != null) {
            objectOutput.writeObject(this.staticType.getClass().getName());
        } else {
            objectOutput.writeObject(null);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        this.prototype = (Scriptable)objectInput.readObject();
        this.parent = (Scriptable)objectInput.readObject();
        if (objectInput.readBoolean()) {
            object = Class.forName((String)objectInput.readObject());
            String[] stringArray = (String[])objectInput.readObject();
            Class[] classArray = new Class[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                classArray[n] = Class.forName(stringArray[n]);
                ++n;
            }
            this.javaObject = JavaAdapter.createAdapterClass((Class)object, classArray, (Scriptable)objectInput.readObject(), (Scriptable)objectInput.readObject());
        } else {
            this.javaObject = objectInput.readObject();
        }
        object = (String)objectInput.readObject();
        this.staticType = object != null ? Class.forName((String)object) : null;
        this.initMembers();
    }
}

