/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeScript
extends NativeFunction
implements Script {
    private Script script;
    private int prototypeIdShift = -1;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeScript nativeScript = new NativeScript();
        nativeScript.OEAB(context, scriptable, bl);
    }

    private void OEAB(Context context, Scriptable scriptable, boolean bl) {
        this.prototypeIdShift = this.getMaxId();
        this.addAsPrototype(this.prototypeIdShift + 4, context, scriptable, bl);
    }

    public String getClassName() {
        return "Script";
    }

    public void initScript(Scriptable scriptable) {
    }

    public int methodArity(int n) {
        if (0 <= this.prototypeIdShift) {
            switch (n - this.prototypeIdShift) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (0 <= this.prototypeIdShift) {
            switch (n - this.prototypeIdShift) {
                case 1: {
                    return NativeScript.jsConstructor(context, scriptable, objectArray);
                }
                case 2: {
                    return this.addAsPrototype(scriptable2, idFunction, true).equals(context, objectArray);
                }
                case 4: {
                    return this.addAsPrototype(scriptable2, idFunction, true).decompileScript();
                }
                case 3: {
                    return this.addAsPrototype(scriptable2, idFunction, false).compileReader(context, ScriptRuntime.toString(objectArray, 0));
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeScript addAsPrototype(Scriptable scriptable, IdFunction idFunction, boolean bl) {
        while (!(scriptable instanceof NativeScript)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, bl);
        }
        return (NativeScript)scriptable;
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        String string = objectArray.length == 0 ? "" : ScriptRuntime.toString(objectArray[0]);
        return NativeScript.compile(context, scriptable, string);
    }

    private static Script compile(Context context, Scriptable scriptable, String string) {
        StringReader stringReader = new StringReader(string);
        try {
            int[] nArray = new int[]{0};
            String string2 = Context.getSourcePositionFromStack(nArray);
            if (string2 == null) {
                string2 = "<Script object>";
                nArray[0] = 1;
            }
            return context.compileReader(scriptable, stringReader, string2, nArray[0], null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected IOException");
        }
    }

    private Scriptable compileReader(Context context, String string) {
        this.script = NativeScript.compile(context, null, string);
        return this;
    }

    private Object decompileScript() throws JavaScriptException {
        throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec");
    }

    private Object equals(Context context, Object[] objectArray) {
        Script script = this.script;
        if (script == null) {
            script = this;
        }
        Scriptable scriptable = ScriptableObject.getTopLevelScope(this);
        return context.decompileScript(script, scriptable, 0);
    }

    public Object exec(Context context, Scriptable scriptable) throws JavaScriptException {
        return this.script == null ? Undefined.instance : this.script.exec(context, scriptable);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return this.exec(context, scriptable);
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor");
    }

    protected String getIdName(int n) {
        if (0 <= this.prototypeIdShift) {
            switch (n - this.prototypeIdShift) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 4: {
                    return "exec";
                }
                case 3: {
                    return "compile";
                }
            }
        }
        return super.getIdName(n);
    }

    protected int mapNameToId(String string) {
        int n;
        if (0 <= this.prototypeIdShift && (n = NativeScript.exec(string)) != 0) {
            return this.prototypeIdShift + n;
        }
        return super.mapNameToId(string);
    }

    private static int exec(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "exec";
                n = 4;
                break;
            }
            case 7: {
                string2 = "compile";
                n = 3;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 1;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

