/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class NativeWith
implements Scriptable,
IdFunctionMaster {
    private Scriptable OEAB;
    private Scriptable checkDeprecated;
    private boolean defineProperty;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeWith nativeWith = new NativeWith();
        nativeWith.defineProperty = true;
        IdFunction idFunction = new IdFunction(nativeWith, "constructor", 1);
        idFunction.initAsConstructor(scriptable, nativeWith);
        if (bl) {
            idFunction.sealObject();
        }
        nativeWith.setParentScope(idFunction);
        nativeWith.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        ScriptableObject.defineProperty(scriptable, "With", idFunction, 2);
    }

    private NativeWith() {
    }

    NativeWith(Scriptable scriptable, Scriptable scriptable2) {
        this.checkDeprecated = scriptable;
        this.OEAB = scriptable2;
    }

    public String getClassName() {
        return "With";
    }

    public boolean has(String string, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.OEAB;
        }
        return this.OEAB.has(string, scriptable);
    }

    public boolean has(int n, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.OEAB;
        }
        return this.OEAB.has(n, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.OEAB;
        }
        return this.OEAB.get(string, scriptable);
    }

    public Object get(int n, Scriptable scriptable) {
        if (scriptable == this) {
            scriptable = this.OEAB;
        }
        return this.OEAB.get(n, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            scriptable = this.OEAB;
        }
        this.OEAB.put(string, scriptable, object);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            scriptable = this.OEAB;
        }
        this.OEAB.put(n, scriptable, object);
    }

    public void delete(String string) {
        this.OEAB.delete(string);
    }

    public void delete(int n) {
        this.OEAB.delete(n);
    }

    public Scriptable getPrototype() {
        return this.OEAB;
    }

    public void setPrototype(Scriptable scriptable) {
        this.OEAB = scriptable;
    }

    public Scriptable getParentScope() {
        return this.checkDeprecated;
    }

    public void setParentScope(Scriptable scriptable) {
        this.checkDeprecated = scriptable;
    }

    public Object[] getIds() {
        return this.OEAB.getIds();
    }

    public Object getDefaultValue(Class clazz) {
        return this.OEAB.getDefaultValue(clazz);
    }

    public boolean hasInstance(Scriptable scriptable) {
        return this.OEAB.hasInstance(scriptable);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.defineProperty && n == 1) {
            throw Context.reportRuntimeError1("msg.cant.call.indirect", "With");
        }
        throw IdFunction.onBadMethodId(this, n);
    }

    public int methodArity(int n) {
        if (this.defineProperty && n == 1) {
            return 0;
        }
        return -1;
    }

    public static Object newWithSpecial(Context context, Object[] objectArray, Function function, boolean bl) {
        if (!bl) {
            throw Context.reportRuntimeError1("msg.only.from.new", "With");
        }
        ScriptRuntime.checkDeprecated(context, "With");
        Scriptable scriptable = ScriptableObject.getTopLevelScope(function);
        NativeWith nativeWith = new NativeWith();
        nativeWith.setPrototype(objectArray.length == 0 ? ScriptableObject.getClassPrototype(scriptable, "Object") : ScriptRuntime.toObject(context, scriptable, objectArray[0]));
        nativeWith.setParentScope(scriptable);
        return nativeWith;
    }
}

