/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.UintMap;

public class Node
implements Cloneable {
    public static final int TARGET_PROP = 1;
    public static final int BREAK_PROP = 2;
    public static final int CONTINUE_PROP = 3;
    public static final int ENUM_PROP = 4;
    public static final int FUNCTION_PROP = 5;
    public static final int TEMP_PROP = 6;
    public static final int LOCAL_PROP = 7;
    public static final int CODEOFFSET_PROP = 8;
    public static final int FIXUPS_PROP = 9;
    public static final int VARS_PROP = 10;
    public static final int USES_PROP = 11;
    public static final int REGEXP_PROP = 12;
    public static final int CASES_PROP = 13;
    public static final int DEFAULT_PROP = 14;
    public static final int CASEARRAY_PROP = 15;
    public static final int SOURCENAME_PROP = 16;
    public static final int SOURCE_PROP = 17;
    public static final int TYPE_PROP = 18;
    public static final int SPECIAL_PROP_PROP = 19;
    public static final int LABEL_PROP = 20;
    public static final int FINALLY_PROP = 21;
    public static final int LOCALCOUNT_PROP = 22;
    public static final int TARGETBLOCK_PROP = 23;
    public static final int VARIABLE_PROP = 24;
    public static final int LASTUSE_PROP = 25;
    public static final int ISNUMBER_PROP = 26;
    public static final int DIRECTCALL_PROP = 27;
    public static final int BASE_LINENO_PROP = 28;
    public static final int END_LINENO_PROP = 29;
    public static final int SPECIALCALL_PROP = 30;
    public static final int DEBUGSOURCE_PROP = 31;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    int type;
    Node next;
    private Node D;
    private Node addChildAfter;
    private int clone = -1;
    private UintMap codeBug;

    public Node(int n) {
        this.type = n;
    }

    public Node(int n, Node node) {
        this.type = n;
        this.D = this.addChildAfter = node;
        node.next = null;
    }

    public Node(int n, Node node, Node node2) {
        this.type = n;
        this.D = node;
        this.addChildAfter = node2;
        node.next = node2;
        node2.next = null;
    }

    public Node(int n, Node node, Node node2, Node node3) {
        this.type = n;
        this.D = node;
        this.addChildAfter = node3;
        node.next = node2;
        node2.next = node3;
        node3.next = null;
    }

    public Node(int n, int n2) {
        this.type = n;
        this.clone = n2;
    }

    public Node(int n, Node node, int n2) {
        this(n, node);
        this.clone = n2;
    }

    public Node(int n, Node node, Node node2, int n2) {
        this(n, node, node2);
        this.clone = n2;
    }

    public Node(int n, Node node, Node node2, Node node3, int n2) {
        this(n, node, node2, node3);
        this.clone = n2;
    }

    public static Node newNumber(double d) {
        return new NumberNode(d);
    }

    public static Node newString(String string) {
        return new StringNode(46, string);
    }

    public static Node newString(int n, String string) {
        return new StringNode(n, string);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean hasChildren() {
        return this.D != null;
    }

    public Node getFirstChild() {
        return this.D;
    }

    public Node getLastChild() {
        return this.addChildAfter;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getChildBefore(Node node) {
        if (node == this.D) {
            return null;
        }
        Node node2 = this.D;
        while (node2.next != node) {
            node2 = node2.next;
            if (node2 != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return node2;
    }

    public Node getLastSibling() {
        Node node = this;
        while (node.next != null) {
            node = node.next;
        }
        return node;
    }

    public PreorderNodeIterator getPreorderIterator() {
        return new PreorderNodeIterator(this);
    }

    public void addChildToFront(Node node) {
        node.next = this.D;
        this.D = node;
        if (this.addChildAfter == null) {
            this.addChildAfter = node;
        }
    }

    public void addChildToBack(Node node) {
        node.next = null;
        if (this.addChildAfter == null) {
            this.D = this.addChildAfter = node;
            return;
        }
        this.addChildAfter.next = node;
        this.addChildAfter = node;
    }

    public void addChildrenToFront(Node node) {
        Node node2 = node.getLastSibling();
        node2.next = this.D;
        this.D = node;
        if (this.addChildAfter == null) {
            this.addChildAfter = node2;
        }
    }

    public void addChildrenToBack(Node node) {
        if (this.addChildAfter != null) {
            this.addChildAfter.next = node;
        }
        this.addChildAfter = node.getLastSibling();
        if (this.D == null) {
            this.D = node;
        }
    }

    public void addChildBefore(Node node, Node node2) {
        if (node.next != null) {
            throw new RuntimeException("newChild had siblings in addChildBefore");
        }
        if (this.D == node2) {
            node.next = this.D;
            this.D = node;
            return;
        }
        Node node3 = this.getChildBefore(node2);
        this.addChildAfter(node, node3);
    }

    public void addChildAfter(Node node, Node node2) {
        if (node.next != null) {
            throw new RuntimeException("newChild had siblings in addChildAfter");
        }
        node.next = node2.next;
        node2.next = node;
        if (this.addChildAfter == node2) {
            this.addChildAfter = node;
        }
    }

    public void removeChild(Node node) {
        Node node2 = this.getChildBefore(node);
        if (node2 == null) {
            this.D = this.D.next;
        } else {
            node2.next = node.next;
        }
        if (node == this.addChildAfter) {
            this.addChildAfter = node2;
        }
        node.next = null;
    }

    public void replaceChild(Node node, Node node2) {
        node2.next = node.next;
        if (node == this.D) {
            this.D = node2;
        } else {
            Node node3 = this.getChildBefore(node);
            node3.next = node2;
        }
        if (node == this.addChildAfter) {
            this.addChildAfter = node2;
        }
        node.next = null;
    }

    public void replaceChildAfter(Node node, Node node2) {
        Node node3 = node.next;
        node2.next = node3.next;
        node.next = node2;
        if (node3 == this.addChildAfter) {
            this.addChildAfter = node2;
        }
        node3.next = null;
    }

    public Object getProp(int n) {
        if (this.codeBug == null) {
            return null;
        }
        return this.codeBug.getObject(n);
    }

    public int getIntProp(int n, int n2) {
        if (this.codeBug == null) {
            return n2;
        }
        return this.codeBug.getInt(n, n2);
    }

    public int getExistingIntProp(int n) {
        return this.codeBug.getExistingInt(n);
    }

    public void putProp(int n, Object object) {
        if (object == null) {
            this.removeProp(n);
        } else {
            if (this.codeBug == null) {
                this.codeBug = new UintMap(2);
            }
            this.codeBug.put(n, object);
        }
    }

    public void putIntProp(int n, int n2) {
        if (this.codeBug == null) {
            this.codeBug = new UintMap(2);
        }
        this.codeBug.put(n, n2);
    }

    public void removeProp(int n) {
        if (this.codeBug != null) {
            this.codeBug.remove(n);
        }
    }

    public int getOperation() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 105: 
            case 109: {
                return this.clone;
            }
        }
        Context.codeBug();
        return 0;
    }

    public int getLineno() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 105: 
            case 109: {
                Context.codeBug();
            }
        }
        return this.clone;
    }

    public double getDouble() {
        return ((NumberNode)this).number;
    }

    public String getString() {
        return ((StringNode)this).str;
    }

    public Node cloneNode() {
        Node node;
        try {
            node = (Node)super.clone();
            node.next = null;
            node.D = null;
            node.addChildAfter = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
        return node;
    }

    public String toString() {
        return null;
    }

    public String toStringTree() {
        return this.D(0);
    }

    private String D(int n) {
        return "";
    }

    private static class StringNode
    extends Node {
        String str;

        StringNode(int n, String string) {
            super(n);
            this.str = string;
        }
    }

    private static class NumberNode
    extends Node {
        double number;

        NumberNode(double d) {
            super(45);
            this.number = d;
        }
    }
}

