/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.CellHandler;
import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.MasterCellHandler;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import com.mathworks.peermodel.pageddata.ServerPagedData;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListDataModelHandler
implements DataModelHandler,
ListDataListener,
PropertyChangeListener {
    protected ListModel dataModel;
    private ServerPagedData serverPagedData;
    private AtomicBoolean dirty = new AtomicBoolean(false);
    protected final JList list;
    protected CellHandler<Object, Object> handler = new MasterCellHandler();

    public ListDataModelHandler(JList list) {
        this.list = list;
        this.cacheListDataModel();
        list.addPropertyChangeListener(this);
    }

    public void update(ServerPagedData serverPagedData) {
        this.serverPagedData = serverPagedData;
    }

    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeListDataListener(this);
        }
    }

    public int getRowCount() {
        final int[] results = new int[1];
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                results[0] = this.dataModel.getSize();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        results[0] = ListDataModelHandler.this.dataModel.getSize();
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.dataModel.getSize();
    }

    public int getColumnCount() {
        return -1;
    }

    public boolean is2D() {
        return false;
    }

    public Object getValueAt(final int row) {
        final Object[] results = new Object[1];
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                results[0] = this.doGetValueAt(row);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        results[0] = ListDataModelHandler.this.doGetValueAt(row);
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return results[0];
    }

    private Object doGetValueAt(int row) {
        Object value = this.list.getModel().getElementAt(row);
        ListCellRenderer renderer = this.list.getCellRenderer();
        Component component = renderer.getListCellRendererComponent(this.list, value, row, false, false);
        return this.handler.getCellValue(this.list, renderer, component, value);
    }

    public Object getValueAt(int row, int col) {
        throw new UnsupportedOperationException("Not supported with 1D data models");
    }

    public void setValueAt(Object value, int row) {
        throw new UnsupportedOperationException("Not supported with List data models");
    }

    public void setValueAt(Object value, int row, int col) {
        throw new UnsupportedOperationException("Not supported with 1D data models");
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.markDirty();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.markDirty();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.markDirty();
    }

    public void dispatchCellEvent(int row, int column, Map<String, Object> data) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("model")) {
            this.destroy();
            this.cacheListDataModel();
            this.markDirty();
        }
    }

    public int convertClientRowToListRow(int row) {
        return row;
    }

    protected void markDirty() {
        this.dirty.set(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ListDataModelHandler.this.dirty.compareAndSet(true, false)) {
                    ListDataModelHandler.this.serverPagedData.update();
                }
            }
        });
    }

    private void cacheListDataModel() {
        this.dataModel = this.list.getModel();
        this.dataModel.addListDataListener(this);
    }
}

