/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers;

import com.jidesoft.grid.EnumCellRenderer;
import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.DefaultCellHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class JComboBoxHandler<R>
extends DefaultCellHandler<R, JComboBox> {
    public JComboBoxHandler(String type) {
        super(type);
    }

    @Override
    public Map<String, Object> getProperties(JComponent component, R renderer, JComboBox cell) {
        Map<String, Object> props = super.getProperties(component, renderer, cell);
        if (props != null) {
            Object[] items = new Object[cell.getItemCount()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = this.getItemAsString(cell, cell.getItemAt(i), "");
            }
            props.put("listValues", items);
            return props;
        }
        return null;
    }

    @Override
    public Object getCellValue(JComponent component, R renderer, JComboBox cell, Object value) {
        return this.getItemAsString(cell, cell.getSelectedItem(), value.toString());
    }

    @Override
    public boolean setCellValue(JComponent component, R editor, JComboBox cell, Object value) {
        if (!value.equals(cell.getSelectedItem()) && cell.isEnabled()) {
            ActionListener[] listeners;
            if (cell.isShowing()) {
                cell.showPopup();
            }
            for (int i = 0; i < cell.getItemCount(); ++i) {
                if (!this.getItemAsString(cell, cell.getItemAt(i), value.toString()).equals(value)) continue;
                cell.setSelectedIndex(i);
            }
            if (cell.isShowing()) {
                cell.hidePopup();
            }
            for (ActionListener listener : listeners = cell.getActionListeners()) {
                listener.actionPerformed(new ActionEvent(cell, 1001, value.toString()));
            }
        }
        return cell.isEnabled();
    }

    private String getItemAsString(JComboBox cell, Object item, String fallback) {
        if (cell instanceof EnumCellRenderer) {
            return ((EnumCellRenderer)cell).convertElementToString(item);
        }
        if (item != null) {
            return item.toString();
        }
        return fallback;
    }
}

