/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractBoundedRangeHandler;
import com.mathworks.peermodel.PeerNode;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class JSliderHandler
extends AbstractBoundedRangeHandler {
    private JSlider slider;

    @Override
    public String getType() {
        return "Slider";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        this.slider = (JSlider)component;
        super.handle(parentHandler, component, parentNode);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        props.put("showTicks", this.slider.getPaintTicks());
        props.put("minorTickSpacing", this.slider.getMinorTickSpacing());
        props.put("majorTickSpacing", this.slider.getMajorTickSpacing());
        props.put("snapToTicks", this.slider.getSnapToTicks());
        props.put("showLabels", this.slider.getPaintLabels());
        if (this.slider.getPaintLabels()) {
            Enumeration keys = this.slider.getLabelTable().keys();
            HashMap<Integer, String> labels = new HashMap<Integer, String>();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = this.slider.getLabelTable().get(key);
                if (value instanceof JLabel) {
                    labels.put((Integer)key, ((JLabel)value).getText());
                    continue;
                }
                System.out.println("Unsupported tick label type: " + value.toString());
            }
            props.put("labels", labels);
        }
        props.put("showTrack", this.slider.getPaintTrack());
        props.put("inverted", this.slider.getInverted());
        return props;
    }

    @Override
    protected String getOrientation(Component component) {
        if (this.slider.getOrientation() == 0) {
            return "horizontal";
        }
        return "vertical";
    }

    @Override
    protected BoundedRangeModel getModel(Component component) {
        return this.slider.getModel();
    }
}

