/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.componentHandlers;

import com.mathworks.html.jxbrowser.BrowserAccessRunnable;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.peermodel.PeerNode;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.events.DisposeEvent;
import com.teamdev.jxbrowser.events.DisposeListener;
import com.teamdev.jxbrowser.events.HistoryChangeEvent;
import com.teamdev.jxbrowser.events.HistoryChangeListener;
import com.teamdev.jxbrowser.events.NavigationEvent;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import com.teamdev.jxbrowser.ie.IEBrowser;
import com.teamdev.jxbrowser.mozilla.MozillaBrowser;
import com.teamdev.jxbrowser.safari.SafariBrowser;
import java.awt.Component;
import java.util.Map;

public class JxBrowserHandler
extends AbstractComponentHandler
implements NavigationListener,
HistoryChangeListener,
DisposeListener {
    private BrowserHolder browserHolder;

    @Override
    public String getType() {
        return "IFrame";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode) {
        JxBrowserSwingComponent browserAdaptor = (JxBrowserSwingComponent)component;
        this.browserHolder = browserAdaptor.getBrowser();
        super.handle(parentHandler, component, parentNode);
    }

    @Override
    protected Map<String, Object> doGetProperties(Component component) {
        Map<String, Object> props = super.doGetProperties(component);
        if (this.getBrowser() != null) {
            props.put("location", this.convertUrlToLocation(this.getBrowser().getCurrentLocation()));
        }
        return props;
    }

    private String convertUrlToLocation(String url) {
        int loc = url.indexOf("/help/");
        if (loc >= 0) {
            return "//www.mathworks.com/" + url.substring(loc + 1);
        }
        return url;
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.getBrowser().addDisposeListener((DisposeListener)this);
        this.getBrowser().addNavigationListener((NavigationListener)this);
        this.getBrowser().addHistoryChangeListener((HistoryChangeListener)this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.removeBrowserEvents(this.getBrowser());
    }

    private void removeBrowserEvents(Browser browser) {
        if (browser != null) {
            browser.removeDisposeListener((DisposeListener)this);
            browser.removeNavigationListener((NavigationListener)this);
            browser.removeHistoryChangeListener((HistoryChangeListener)this);
        }
    }

    private Browser getBrowser() {
        final Browser[] result = new Browser[1];
        this.browserHolder.invokeAndWait(new BrowserAccessRunnable(){

            public void handleMozillaBrowser(MozillaBrowser browser) {
                result[0] = browser;
            }

            public void handleMozilla15Browser(com.teamdev.jxbrowser.mozilla15.MozillaBrowser browser) {
                result[0] = browser;
            }

            public void handleIEBrowser(IEBrowser browser) {
                result[0] = browser;
            }

            public void handleSafariBrowser(SafariBrowser browser) {
                result[0] = browser;
            }
        });
        return result[0];
    }

    public void navigationStarted(NavigationEvent event) {
        this.markDirty();
    }

    public void navigationFinished(NavigationFinishedEvent event) {
        this.markDirty();
    }

    public void historyChanged(HistoryChangeEvent event) {
        this.markDirty();
    }

    public void browserDisposed(DisposeEvent disposeEvent) {
        this.removeBrowserEvents(disposeEvent.getBrowser());
    }
}

