/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.containerHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.HandlerFactory;
import com.mathworks.matlabserver.jcp.handlers.componentHandlers.AbstractComponentHandler;
import com.mathworks.peermodel.PeerNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;

public abstract class AbstractContainerHandler
extends AbstractComponentHandler {
    protected Container container;
    private ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            AbstractContainerHandler.this.doAddChild(e.getChild(), AbstractContainerHandler.this.peerNode, AbstractContainerHandler.this.container);
            AbstractContainerHandler.this.markDirty();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            AbstractContainerHandler.this.doRemoveChild(e.getChild());
        }
    };

    protected void doAddChild(Component child, PeerNode peerNode, Container container) {
        Handler handler = HandlerFactory.getHandler(child);
        if (handler != null) {
            handler.handle(this, child, peerNode, container);
        }
    }

    protected void doRemoveChild(Component child) {
        Handler childHandler = this.getChildHandler(child);
        if (childHandler != null) {
            childHandler.destroy();
        }
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.container = (Container)component;
        super.handle(parentHandler, component, parent);
        this.processChildren(this.container);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.destroyChildren();
    }

    public void destroyChildren() {
        ArrayList<Handler> children = new ArrayList<Handler>(this.getChildrenHandlers());
        for (Handler child : children) {
            child.destroy();
        }
    }

    protected void processChildren(Container container) {
        for (Component component : container.getComponents()) {
            this.doAddChild(component, this.peerNode, container);
        }
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.addContainerListener(this.container);
    }

    protected void addContainerListener(Container container) {
        container.addContainerListener(this.containerListener);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.removeContainerListener(this.container);
    }

    protected void removeContainerListener(Container container) {
        container.removeContainerListener(this.containerListener);
    }
}

