/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.menuHandlers;

import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.HandlerFactory;
import com.mathworks.matlabserver.jcp.handlers.menuHandlers.JMenuItemHandler;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.events.Event;
import com.mathworks.peermodel.events.Observer;
import java.awt.Component;
import java.awt.MenuBar;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class JMenuHandler
extends JMenuItemHandler {
    private static boolean menuFocusBypass = false;
    private Handler popupHandler;
    private JMenu menu;
    private Observer menuHover = new Observer(){

        public void handle(Event event) {
            if (menuFocusBypass) {
                return;
            }
            String type = (String)event.getData().get("type");
            String id = event.getTarget().getId();
            if (type.equals("mouseEnter")) {
                JMenuHandler.this.selectMenuLater(true);
                Boolean isShowingNow = (Boolean)event.getData().get("isShowingNow");
                boolean menuWasOpened = isShowingNow != null && isShowingNow != false;
                Handler openedMenuHandler = JMenuHandler.this.getVisibleMenuHandler();
                if (openedMenuHandler != null) {
                    JMenu openedMenu = (JMenu)openedMenuHandler.getComponent();
                    String openedMenuId = openedMenuHandler.getPeerNode().getId();
                    if (!openedMenuId.equals(id) || !menuWasOpened) {
                        JMenuHandler.this.closeMenuLater(openedMenu);
                    }
                    if (menuWasOpened) {
                        JMenuHandler.this.openMenuLater();
                    }
                } else if (menuWasOpened) {
                    JMenuHandler.this.openMenuLater();
                }
            } else if (type.equals("mouseLeave")) {
                JMenuHandler.this.selectMenuLater(false);
            }
        }
    };

    public static void setMenuFocusBypass(boolean menuFocusBypass) {
        JMenuHandler.menuFocusBypass = menuFocusBypass;
    }

    private Handler getVisibleMenuHandler() {
        Handler parentHandler = this.getParentHandler();
        if (!(parentHandler.getComponent() instanceof JMenuBar)) {
            return null;
        }
        for (Handler sibling : parentHandler.getChildrenHandlers()) {
            JMenu menu;
            if (!(sibling.getComponent() instanceof JMenu) || !(menu = (JMenu)sibling.getComponent()).isPopupMenuVisible()) continue;
            return sibling;
        }
        return null;
    }

    @Override
    public String getType() {
        return "Menu";
    }

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.menu = (JMenu)component;
        super.handle(parentHandler, component, parent);
        this.popupHandler = HandlerFactory.getHandler(this.menu.getPopupMenu());
        if (this.popupHandler != null) {
            this.popupHandler.handle(this, this.menu.getPopupMenu(), this.peerNode);
        }
        this.openMenuLater();
        this.closeMenuLater(this.menu);
    }

    public void forceMenuUpdate() {
        this.openMenuLater();
        this.closeMenuLater(this.menu);
    }

    private void closeMenuLater(final JMenu menu) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMenuHandler.this.dispatchHideMenu(menu);
            }
        });
    }

    private void dispatchHideMenu(JMenu menu) {
        MenuElement[] elements = this.getMenuElements(menu);
        if (elements.length > 0 && (elements[0] instanceof MenuBar || elements[0] instanceof JMenuBar)) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    }

    private void openMenuLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JMenuHandler.this.menu.getText() != null && JMenuHandler.this.menu.getText().length() > 0) {
                    MenuElement[] elements = JMenuHandler.this.getMenuElements(JMenuHandler.this.menu);
                    MenuSelectionManager.defaultManager().setSelectedPath(elements);
                }
            }
        });
    }

    private MenuElement[] getMenuElements(JMenu menu) {
        LinkedList<MenuElement> elements = new LinkedList<MenuElement>();
        elements.push(menu);
        Component current = menu.getPopupMenu();
        while (current instanceof MenuElement) {
            elements.push((MenuElement)((Object)current));
            current = this.getParentComponent(current);
        }
        return elements.toArray(new MenuElement[elements.size()]);
    }

    private Component getParentComponent(Component current) {
        if (current instanceof JPopupMenu) {
            return ((JPopupMenu)current).getInvoker();
        }
        return current.getParent();
    }

    private void selectMenuLater(final Boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (JMenuHandler.this.component.getParent() instanceof JMenuBar && JMenuHandler.this.menu.getText() != null && JMenuHandler.this.menu.getText().length() > 0) {
                    JMenuHandler.this.menu.setSelected(b);
                }
            }
        });
    }

    @Override
    protected void doClick(AbstractButton button) {
        if (!menuFocusBypass && this.component.getParent() instanceof JMenuBar && this.menu.getText() != null && this.menu.getText().length() > 0) {
            if (this.menu.isPopupMenuVisible()) {
                this.dispatchHideMenu(this.menu);
            } else {
                this.menu.doClick();
            }
        }
    }

    @Override
    protected void addPeerNodeListeners() {
        super.addPeerNodeListeners();
        this.peerNode.addEventListener("peerEvent", this.menuHover);
    }

    @Override
    protected void removePeerNodeListeners() {
        super.removePeerNodeListeners();
        this.peerNode.removeEventListener("peerEvent", this.menuHover);
    }

    @Override
    public void destroy() {
        if (this.popupHandler != null) {
            this.popupHandler.destroy();
            this.popupHandler = null;
        }
        super.destroy();
    }
}

