/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.RepaintTableDataModelHandler;
import com.mathworks.matlabserver.jcp.dataHandlers.TableDataModelHandler;
import com.mathworks.matlabserver.jcp.dataHandlers.cellHandlers.MasterCellHandler;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.tableHandlers.AbstractTableHandler;
import com.mathworks.matlabserver.jcp.utils.ObservableRepaintManager;
import com.mathworks.matlabserver.jcp.utils.RepaintListener;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JTableHandler
extends AbstractTableHandler
implements TableColumnModelListener,
ListSelectionListener,
RepaintListener,
PropertyChangeListener,
ComponentListener {
    protected JTable table;
    protected JTable rowHeader = null;
    protected MasterCellHandler columnConverter = new MasterCellHandler();

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parent) {
        this.table = this.getTable(component);
        super.handle(parentHandler, component, parent);
    }

    @Override
    protected void clearSelection() {
        this.table.clearSelection();
    }

    @Override
    protected void setSelection(int row, int col, boolean selected) {
        if (this.table.isCellSelected(row, col) != selected) {
            this.table.changeSelection(row, col, true, false);
        }
    }

    @Override
    protected void setColumnWidth(int columnIndex, int width) {
        this.table.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
    }

    @Override
    protected int getRowHeight() {
        return this.table.getRowHeight();
    }

    @Override
    protected int getColumnHeaderHeight() {
        if (this.table.getTableHeader() == null || !this.table.getTableHeader().isVisible()) {
            return 0;
        }
        return this.table.getTableHeader().getHeight();
    }

    @Override
    protected JTable getTable(Component table) {
        return (JTable)table;
    }

    @Override
    protected void setTableColumns(Map<String, Object> props) {
        TableColumnModel columnModel = this.table.getColumnModel();
        ArrayList<HashMap<String, Object>> columns = new ArrayList<HashMap<String, Object>>(Math.min(this.table.getColumnCount(), columnModel.getColumnCount()));
        for (int i = 0; i < this.table.getColumnCount() && i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            HashMap<String, Object> columnProps = new HashMap<String, Object>();
            columnProps.put("label", column.getHeaderValue());
            columnProps.put("width", column.getWidth());
            columnProps.put("minWidth", column.getMinWidth());
            columnProps.put("maxWidth", column.getMaxWidth());
            this.setColumnTypeProperties(columnProps, i);
            columns.add(columnProps);
        }
        props.put("columns", columns.toArray());
    }

    @Override
    protected void setColumnTypeProperties(Map<String, Object> columnProps, int colIndex) {
        Map<String, Object> props;
        boolean editable;
        TableCellRenderer renderer = null;
        TableCellEditor editor = null;
        TableColumn column = this.table.getColumnModel().getColumn(colIndex);
        if (this.table.getRowCount() > 0 && colIndex < this.table.getModel().getColumnCount()) {
            renderer = this.table.getCellRenderer(0, colIndex);
        } else if (column.getCellRenderer() != null) {
            renderer = column.getCellRenderer();
        }
        if (this.table.getRowCount() > 0 && colIndex < this.table.getModel().getColumnCount()) {
            editor = this.table.getCellEditor(0, colIndex);
        } else if (column.getCellEditor() != null) {
            editor = column.getCellEditor();
        }
        if (renderer != null) {
            columnProps.put("renderer", this.columnConverter.getProperties((JComponent)this.table, renderer, (Object)null));
        }
        boolean bl = editable = this.table.getRowCount() > 0 && this.table.isCellEditable(0, colIndex);
        if (editor != null && editable && (props = this.columnConverter.getProperties((JComponent)this.table, editor, (Object)null)) != null) {
            columnProps.put("editor", props);
        }
        columnProps.put("editable", editable);
    }

    @Override
    protected Object getSelectedIndices() {
        AbstractTableHandler.SELECTION_TYPE type = this.getTableSelectionType();
        switch (type) {
            case Cell: {
                ArrayList<Integer[]> cells_selected = new ArrayList<Integer[]>();
                if (this.table.getColumnCount() > 0 && this.table.getRowCount() > 0 && this.table.getSelectedColumnCount() > 0 && this.table.getSelectedRowCount() > 0) {
                    int[] rowsSelected = this.table.getSelectedRows();
                    int[] colsSelected = this.table.getSelectedColumns();
                    for (int r : rowsSelected) {
                        for (int c : colsSelected) {
                            if (!this.table.isCellSelected(r, c)) continue;
                            cells_selected.add(new Integer[]{r, c});
                        }
                    }
                }
                return cells_selected.toArray();
            }
            case Row: {
                int[] rowsSelected = new int[]{};
                if (this.table.getRowCount() > 0 && this.table.getSelectedRowCount() > 0) {
                    rowsSelected = this.table.getSelectedRows();
                }
                return rowsSelected;
            }
            case Column: {
                int[] colsSelected = new int[]{};
                if (this.table.getColumnCount() > 0 && this.table.getSelectedColumnCount() > 0) {
                    colsSelected = this.table.getSelectedColumns();
                }
                return colsSelected;
            }
        }
        return new int[0];
    }

    @Override
    protected void setTableHeaderAndBorderProperties(Map<String, Object> tableProperties) {
        tableProperties.put("tableHeader", this.getColumnHeaderHeight() > 0);
        tableProperties.put("showCellBorders", this.table.getShowHorizontalLines() && this.table.getShowVerticalLines());
    }

    @Override
    protected DataModelHandler getTableDataHandler() {
        if (this.table.getClass().getSimpleName().equals("BrowserTable") || this.table.getClass().getSimpleName().equals("STable") || this.table.getClass().getSimpleName().equals("MultiEdgeTable")) {
            return new RepaintTableDataModelHandler(this.table);
        }
        return new TableDataModelHandler(this.table);
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.table.getColumnModel().addColumnModelListener(this);
        if (this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().addListSelectionListener(this);
        }
        this.table.addPropertyChangeListener(this);
        if (this.table.getTableHeader() != null) {
            this.table.getTableHeader().addComponentListener(this);
        }
        ObservableRepaintManager.getInstance().addRepaintListener(this.table, this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.table.removePropertyChangeListener(this);
        if (this.table.getTableHeader() != null) {
            this.table.getTableHeader().removeComponentListener(this);
        }
        this.table.getColumnModel().removeColumnModelListener(this);
        if (this.table.getSelectionModel() != null) {
            this.table.getSelectionModel().removeListSelectionListener(this);
        }
    }

    @Override
    public String getComponentName() {
        return this.table.getName();
    }

    @Override
    public String getComponentSwingType() {
        return this.table.getClass().getSimpleName();
    }

    @Override
    public boolean ownsComponent(Component component) {
        return super.ownsComponent(component) || this.table.equals(component);
    }

    @Override
    protected AbstractTableHandler.SELECTION_MODE getTableSelectionMode() {
        if (this.table.getSelectionModel() == null) {
            return AbstractTableHandler.SELECTION_MODE.NONE;
        }
        if (this.table.getSelectionModel().getSelectionMode() == 0) {
            return AbstractTableHandler.SELECTION_MODE.SINGLE;
        }
        return AbstractTableHandler.SELECTION_MODE.EXTENDED;
    }

    @Override
    protected AbstractTableHandler.SELECTION_TYPE getTableSelectionType() {
        return this.table.getCellSelectionEnabled() ? AbstractTableHandler.SELECTION_TYPE.Cell : (this.table.getRowSelectionAllowed() ? AbstractTableHandler.SELECTION_TYPE.Row : (this.table.getColumnSelectionAllowed() ? AbstractTableHandler.SELECTION_TYPE.Column : AbstractTableHandler.SELECTION_TYPE.None));
    }

    @Override
    protected Point getClickedPoint() {
        return this.getClickedPoint(this.table.getSelectedRow(), this.table.getSelectedColumn());
    }

    @Override
    protected Point getClickedPoint(int row, int col) {
        Rectangle rect = this.table.getCellRect(row, col, true);
        Point point = new Point((int)(rect.getX() + 2.0), (int)(rect.getY() + rect.getHeight() / 2.0 + 2.0) - this.getColumnHeaderHeight());
        return SwingUtilities.convertPoint(this.table, point, this.component);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean adjust = e.getValueIsAdjusting();
        if (!adjust && !this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.markDirty();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.markDirty();
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.markDirty();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void componentRepainted(JComponent component) {
        if (!this.updating) {
            this.markDirty();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.markDirty();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.markDirty();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.markDirty();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.markDirty();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.markDirty();
    }
}

