/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers;

import com.mathworks.matlabserver.jcp.dataHandlers.MwtTableDataHandler;
import com.mathworks.matlabserver.jcp.handlers.Handler;
import com.mathworks.matlabserver.jcp.handlers.tableHandlers.AbstractTableHandler;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.CellBoolean;
import com.mathworks.mwt.table.CellImageResource;
import com.mathworks.mwt.table.CellMWCheckbox;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableDataEvent;
import com.mathworks.mwt.table.TableDataListener;
import com.mathworks.mwt.table.TableEvent;
import com.mathworks.mwt.table.TableListener;
import com.mathworks.mwt.table.ValueEvent;
import com.mathworks.mwt.table.ValueListener;
import com.mathworks.peermodel.PeerNode;
import com.mathworks.peermodel.pageddata.DataModelHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class MWTableHandler
extends AbstractTableHandler
implements TableListener,
ValueListener,
TableDataListener {
    private Table table;

    @Override
    public void handle(Handler parentHandler, Component component, PeerNode parentNode, Container parentContainer) {
        this.table = (Table)component;
        super.handle(parentHandler, component, parentNode, parentContainer);
    }

    @Override
    protected Component getTable(Component component) {
        return this.table;
    }

    @Override
    protected void clearSelection() {
        this.table.deselectAll();
    }

    @Override
    protected void setSelection(int row, int col, boolean selected) {
        this.table.select(row, col);
    }

    @Override
    protected void setColumnWidth(int columnIndex, int width) {
        this.table.setColumnWidth(columnIndex, width);
    }

    @Override
    protected int getRowHeight() {
        return this.table.getRowOptions().getDefaultHeight();
    }

    @Override
    protected int getColumnHeaderHeight() {
        return this.table.getColumnOptions().getHeaderHeight();
    }

    @Override
    protected void setTableColumns(Map<String, Object> props) {
        ArrayList<HashMap<String, Object>> columns = new ArrayList<HashMap<String, Object>>(this.table.getData().getWidth());
        for (int i = 0; i < this.table.getData().getWidth(); ++i) {
            HashMap<String, Object> columnProps = new HashMap<String, Object>();
            columnProps.put("label", this.table.getColumnHeaderData(i));
            columnProps.put("width", this.table.getColumnWidth(i));
            if (this.table.getColumnOptions().isResizable()) {
                columnProps.put("minWidth", Math.min(this.table.getColumnWidth(0), this.table.getColumnOptions().getMinWidth(i)));
                columnProps.put("maxWidth", this.table.getColumnOptions().getDefaultWidth() * 2);
            }
            this.setColumnTypeProperties(columnProps, i);
            columns.add(columnProps);
        }
        props.put("columns", columns.toArray());
    }

    @Override
    protected void setColumnTypeProperties(Map<String, Object> columnProps, int colIndex) {
        boolean editable;
        String type = "default";
        boolean bl = editable = this.table.getColumnStyle(colIndex) != null && this.table.getColumnStyle(colIndex).isEditable();
        if (this.table.getData().getHeight() > 0) {
            Cell cell = this.table.getCell(0, colIndex);
            if (cell instanceof CellBoolean || cell instanceof CellMWCheckbox) {
                type = "checkbox";
                editable = true;
            } else if (cell instanceof CellImageResource) {
                type = "label";
            } else if (cell.getClass().getName().contains("ArrayViewCellText")) {
                type = "text";
                editable = true;
            }
        }
        HashMap<String, String> renderer = new HashMap<String, String>();
        renderer.put("type", type);
        columnProps.put("renderer", renderer);
        columnProps.put("editable", editable);
    }

    @Override
    protected AbstractTableHandler.SELECTION_MODE getTableSelectionMode() {
        int mode = this.table.getSelectionOptions().getMode();
        if (mode == 0) {
            return AbstractTableHandler.SELECTION_MODE.NONE;
        }
        if (mode == 1) {
            return AbstractTableHandler.SELECTION_MODE.SINGLE;
        }
        return AbstractTableHandler.SELECTION_MODE.EXTENDED;
    }

    @Override
    protected AbstractTableHandler.SELECTION_TYPE getTableSelectionType() {
        int mode = this.table.getSelectionOptions().getMode();
        int type = this.table.getSelectionOptions().getSelectBy();
        if (mode == 0) {
            return AbstractTableHandler.SELECTION_TYPE.None;
        }
        if (type == 1) {
            return AbstractTableHandler.SELECTION_TYPE.Row;
        }
        if (type == 2) {
            return AbstractTableHandler.SELECTION_TYPE.Column;
        }
        return AbstractTableHandler.SELECTION_TYPE.Cell;
    }

    @Override
    protected Object getSelectedIndices() {
        AbstractTableHandler.SELECTION_TYPE type = this.getTableSelectionType();
        switch (type) {
            case Row: {
                return this.table.getSelectedRows();
            }
            case Column: {
                return this.table.getSelectedColumns();
            }
            case Cell: {
                ArrayList<Integer[]> selectedCells = new ArrayList<Integer[]>();
                int[] rowsSelected = this.table.getSelectedRows();
                int[] colsSelected = this.table.getSelectedColumns();
                for (int r : rowsSelected) {
                    for (int c : colsSelected) {
                        if (!this.table.isSelected(r, c)) continue;
                        selectedCells.add(new Integer[]{r, c});
                    }
                }
                return selectedCells.toArray();
            }
        }
        return new int[0];
    }

    @Override
    protected void setTableHeaderAndBorderProperties(Map<String, Object> tableProperties) {
        tableProperties.put("tableHeader", this.table.getColumnOptions().isHeaderVisible() && this.table.getColumnOptions().getHeaderHeight() > 0 && this.table.getData().getHeight() > 0);
        Style style = this.table.getCellStyle(0, 0);
        tableProperties.put("showCellBorders", this.table.getData().getWidth() > 0 && style != null && (style.isVGridVisible() || style.isHGridVisible()));
        tableProperties.put("showRowHeaders", this.table.getRowOptions().isHeaderVisible());
        if (this.table.getRowOptions().isHeaderVisible()) {
            String[] rows = new String[this.table.getData().getHeight()];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = this.table.getRowHeaderData(i).toString();
            }
            tableProperties.put("rows", rows);
            tableProperties.put("rowHeaderWidth", this.table.getRowOptions().getHeaderWidth());
        }
    }

    @Override
    protected DataModelHandler getTableDataHandler() {
        return new MwtTableDataHandler(this.table);
    }

    @Override
    protected Point getClickedPoint() {
        if (this.table.getData().getWidth() > 0 && this.table.getData().getHeight() > 0) {
            return this.table.getLocation(new Point(this.table.getLastSelectedRow(), 0));
        }
        return new Point(0, 0);
    }

    @Override
    protected Point getClickedPoint(int row, int col) {
        if (this.table.getData().getWidth() > 0 && this.table.getData().getHeight() > 0) {
            Rectangle rect = this.table.getCellBounds(row, col);
            Point point = new Point((int)(rect.getX() + 2.0), (int)(rect.getY() + rect.getHeight() / 2.0 + 2.0) - this.getColumnHeaderHeight());
            return SwingUtilities.convertPoint((Component)this.table, point, this.component);
        }
        return new Point(0, 0);
    }

    @Override
    protected void addEventListeners() {
        super.addEventListeners();
        this.table.addTableListener((TableListener)this);
    }

    @Override
    protected void removeEventListeners() {
        super.removeEventListeners();
        this.table.removeTableListener((ValueListener)this);
        this.table.getData().addDataListener((TableDataListener)this);
    }

    public void valueChanged(ValueEvent valueEvent) {
        this.markDirty();
    }

    public void editCommitted(TableEvent tableEvent) {
        this.markDirty();
    }

    public void editCancelled(TableEvent tableEvent) {
        this.markDirty();
    }

    public void dataChanged(TableDataEvent tableDataEvent) {
    }

    public void dataBoundsChanging(TableDataEvent tableDataEvent) {
    }

    public void dataBoundsChanged(TableDataEvent tableDataEvent) {
        this.markDirty();
    }

    public void rowsAdded(TableDataEvent tableDataEvent) {
        this.markDirty();
    }

    public void rowsRemoved(TableDataEvent tableDataEvent) {
    }
}

