/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.handlers.tableHandlers;

import com.mathworks.peermodel.PeerNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeModelHandler
implements TreeModelListener {
    private JTree tree;
    private TreeModel model = null;
    private PeerNode parentNode;
    private PeerNode rootNode;
    private NodeConverter nodeConverter;

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        Object parent = e.getTreePath().getLastPathComponent();
        PeerNode parentNode = this.getPeerNodeFromPath(e.getPath());
        for (int i : e.getChildIndices()) {
            Object child = this.model.getChild(parent, i);
            this.updateNode(parentNode.getChild(i), child);
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        Object parent = e.getTreePath().getLastPathComponent();
        PeerNode parentNode = this.getPeerNodeFromPath(e.getPath());
        if (parentNode == null) {
            parentNode = this.parentNode;
        }
        for (int i : e.getChildIndices()) {
            Object child = this.model.getChild(parent, i);
            this.addChildNode(child, parentNode, i);
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        PeerNode parentNode = this.getPeerNodeFromPath(e.getPath());
        for (int i : e.getChildIndices()) {
            this.removeChildNode(parentNode, i);
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        int index;
        PeerNode parentNode;
        Object parent = e.getTreePath().getLastPathComponent();
        PeerNode node = this.getPeerNodeFromPath(e.getPath());
        if (node != null) {
            parentNode = node.getParent();
            index = node.getParent().getChildIndex(node);
            node.destroy();
        } else {
            parentNode = this.parentNode;
            index = 0;
        }
        this.addChildNode(parent, parentNode, index);
    }

    public TreeModel getModel() {
        return this.model;
    }

    public void handle(JTree tree, PeerNode parentNode) {
        if (tree != null && tree.getModel() != null && parentNode != null) {
            this.destroy();
            this.tree = tree;
            this.parentNode = parentNode;
            this.model = tree.getModel();
            if (this.model.getRoot() != null) {
                this.rootNode = this.addChildNode(this.model.getRoot(), parentNode, 0);
            }
            this.model.addTreeModelListener(this);
        }
    }

    public void destroy() {
        if (this.model != null && this.rootNode != null) {
            this.rootNode.destroy();
            this.model.removeTreeModelListener(this);
            this.rootNode = null;
            this.model = null;
        }
    }

    public void setNodeConverter(NodeConverter converter) {
        this.nodeConverter = converter;
    }

    private PeerNode addChildNode(Object treeNode, PeerNode parentNode, int index) {
        PeerNode peerNode = parentNode.addChild(this.getNodeType(treeNode), this.getNodeProperties(treeNode), index);
        for (int i = 0; i < this.model.getChildCount(treeNode); ++i) {
            this.addChildNode(this.model.getChild(treeNode, i), peerNode, i);
        }
        return peerNode;
    }

    private void updateNode(PeerNode peerNode, Object treeNode) {
        peerNode.setProperties(this.getNodeProperties(treeNode));
    }

    private void removeChildNode(PeerNode parentNode, int index) {
        PeerNode peerNode = parentNode.getChild(index);
        peerNode.destroy();
    }

    public List<PeerNode> getPeerNodesFromPath(Object[] path) {
        ArrayList<PeerNode> nodes = new ArrayList<PeerNode>();
        if (this.rootNode != null) {
            nodes.add(this.rootNode);
            Object node = path[0];
            for (int i = 1; i < path.length; ++i) {
                Object child = path[i];
                int index = this.model.getIndexOfChild(node, child);
                if (index < 0 || index >= ((PeerNode)nodes.get(nodes.size() - 1)).getNumberOfChildren()) {
                    return new ArrayList<PeerNode>();
                }
                nodes.add(((PeerNode)nodes.get(nodes.size() - 1)).getChild(index));
                node = child;
            }
        }
        return nodes;
    }

    public PeerNode getPeerNodeFromPath(Object[] path) {
        List<PeerNode> nodes = this.getPeerNodesFromPath(path);
        if (nodes.isEmpty()) {
            return null;
        }
        return nodes.get(nodes.size() - 1);
    }

    public TreePath getPathFromPeerNode(PeerNode peerNode) {
        ArrayDeque<PeerNode> peerNodePath = new ArrayDeque<PeerNode>();
        while (peerNode.hasParent() && peerNode != this.rootNode) {
            peerNodePath.push(peerNode);
            peerNode = peerNode.getParent();
        }
        Object node = this.model.getRoot();
        TreePath path = new TreePath(node);
        while (!peerNodePath.isEmpty()) {
            peerNode = (PeerNode)peerNodePath.pop();
            node = this.model.getChild(node, peerNode.getParent().getChildIndex(peerNode));
            path = path.pathByAddingChild(node);
        }
        return path;
    }

    private String getNodeType(Object node) {
        return "TreeNode";
    }

    private Map<String, Object> getNodeProperties(Object node) {
        String label;
        HashMap<String, Object> props = new HashMap<String, Object>();
        boolean selected = false;
        boolean expanded = false;
        boolean leaf = this.model.isLeaf(node);
        if (this.tree.getSelectionPath() != null) {
            boolean bl = selected = this.tree.getSelectionPath().getLastPathComponent() == node;
        }
        if ((label = this.tree.convertValueToText(node, selected, expanded, leaf, 0, true)) == null) {
            label = "";
        }
        props.put("leaf", leaf);
        props.put("label", label);
        if (this.nodeConverter != null) {
            this.nodeConverter.convertNode(node, props);
        }
        return props;
    }

    public static abstract class NodeConverter {
        public abstract void convertNode(Object var1, Map<String, Object> var2);
    }
}

