/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.jcp.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ImageUtils {
    private static Component tempComponent;

    public static BufferedImage getImageFromIcon(Icon icon, Component component) {
        BufferedImage image = new BufferedImage(Math.max(icon.getIconWidth(), 1), Math.max(icon.getIconHeight(), 1), 2);
        if (component == null) {
            component = ImageUtils.getTempComponent();
        }
        icon.paintIcon(component, image.getGraphics(), 0, 0);
        return image;
    }

    private static Component getTempComponent() {
        if (tempComponent == null) {
            tempComponent = new Component(){};
        }
        return tempComponent;
    }

    public static BufferedImage getImageFromComponent(Component component) {
        return ImageUtils.getImageFromComponent(component, null, 2);
    }

    public static BufferedImage getImageFromComponent(Component component, BufferedImage image, int format) {
        int newWidth = Math.max(component.getWidth(), 1);
        int newHeight = Math.max(component.getHeight(), 1);
        if (image == null || newWidth != image.getWidth() || newHeight != image.getHeight()) {
            try {
                image = new BufferedImage(newWidth, newHeight, format);
            }
            catch (OutOfMemoryError e) {
                System.gc();
                System.runFinalization();
                System.gc();
                image = new BufferedImage(newWidth, newHeight, format);
            }
        }
        Graphics gDirty = image.getGraphics();
        try {
            component.paint(gDirty);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return image;
    }
}

