/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.io.UnsupportedConstraintException;

class X500Constraints {
    private static final Object SUPPORTED = new Object();
    private static final Object UNSUPPORTED = new Object();
    private static final Set supportedRequestConstraints;
    private static final Set supportedAnnouncementConstraints;
    private static final Set principalConstraints;
    private final InvocationConstraints distilled;

    private X500Constraints(InvocationConstraints invocationConstraints) {
        this.distilled = invocationConstraints;
    }

    static X500Constraints process(InvocationConstraints invocationConstraints, boolean bl) throws UnsupportedConstraintException {
        if (invocationConstraints == null) {
            invocationConstraints = InvocationConstraints.EMPTY;
        }
        return new X500Constraints(new InvocationConstraints(X500Constraints.distill(invocationConstraints.requirements(), bl, true), X500Constraints.distill(invocationConstraints.preferences(), bl, false)));
    }

    int checkClientPrincipal(X500Principal x500Principal) {
        Iterator iterator = this.distilled.requirements().iterator();
        while (iterator.hasNext()) {
            if (X500Constraints.clientPrincipalSatisfies(x500Principal, (InvocationConstraint)iterator.next())) continue;
            return -1;
        }
        int n = 0;
        Iterator iterator2 = this.distilled.preferences().iterator();
        while (iterator2.hasNext()) {
            if (!X500Constraints.clientPrincipalSatisfies(x500Principal, (InvocationConstraint)iterator2.next())) continue;
            ++n;
        }
        return n;
    }

    int checkServerPrincipal(X500Principal x500Principal) {
        Iterator iterator = this.distilled.requirements().iterator();
        while (iterator.hasNext()) {
            if (X500Constraints.serverPrincipalSatisfies(x500Principal, (InvocationConstraint)iterator.next())) continue;
            return -1;
        }
        int n = 0;
        Iterator iterator2 = this.distilled.preferences().iterator();
        while (iterator2.hasNext()) {
            if (!X500Constraints.serverPrincipalSatisfies(x500Principal, (InvocationConstraint)iterator2.next())) continue;
            ++n;
        }
        return n;
    }

    private static Collection distill(Set set, boolean bl, boolean bl2) throws UnsupportedConstraintException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            InvocationConstraint invocationConstraint = (InvocationConstraint)iterator.next();
            Object object = X500Constraints.distill(invocationConstraint, bl);
            if (object instanceof InvocationConstraint) {
                arrayList.add(object);
                continue;
            }
            if (!bl2 || object != UNSUPPORTED) continue;
            throw new UnsupportedConstraintException("unsupported: " + invocationConstraint);
        }
        return arrayList;
    }

    private static Object distill(InvocationConstraint invocationConstraint, boolean bl) {
        Set set;
        Class<?> clazz = invocationConstraint.getClass();
        Set set2 = set = bl ? supportedRequestConstraints : supportedAnnouncementConstraints;
        if (set.contains(invocationConstraint) || set.contains(clazz)) {
            return SUPPORTED;
        }
        if (principalConstraints.contains(clazz)) {
            return invocationConstraint;
        }
        if (invocationConstraint instanceof ConstraintAlternatives) {
            ConstraintAlternatives constraintAlternatives = (ConstraintAlternatives)invocationConstraint;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = constraintAlternatives.elements().iterator();
            while (iterator.hasNext()) {
                Object object = X500Constraints.distill((InvocationConstraint)iterator.next(), bl);
                if (object == SUPPORTED) {
                    return SUPPORTED;
                }
                if (!(object instanceof InvocationConstraint)) continue;
                arrayList.add(object);
            }
            return arrayList.isEmpty() ? UNSUPPORTED : ConstraintAlternatives.create(arrayList);
        }
        return UNSUPPORTED;
    }

    private static boolean clientPrincipalSatisfies(X500Principal x500Principal, InvocationConstraint invocationConstraint) {
        if (invocationConstraint instanceof ClientMaxPrincipal) {
            return ((ClientMaxPrincipal)invocationConstraint).elements().contains(x500Principal);
        }
        if (invocationConstraint instanceof ClientMaxPrincipalType) {
            Set set = ((ClientMaxPrincipalType)invocationConstraint).elements();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!((Class)iterator.next()).isInstance(x500Principal)) continue;
                return true;
            }
            return false;
        }
        if (invocationConstraint instanceof ClientMinPrincipal) {
            Set set = ((ClientMinPrincipal)invocationConstraint).elements();
            return set.size() == 1 && set.contains(x500Principal);
        }
        if (invocationConstraint instanceof ClientMinPrincipalType) {
            Set set = ((ClientMinPrincipalType)invocationConstraint).elements();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (((Class)iterator.next()).isInstance(x500Principal)) continue;
                return false;
            }
            return true;
        }
        if (invocationConstraint instanceof ConstraintAlternatives) {
            Set set = ((ConstraintAlternatives)invocationConstraint).elements();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!X500Constraints.clientPrincipalSatisfies(x500Principal, (InvocationConstraint)iterator.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean serverPrincipalSatisfies(X500Principal x500Principal, InvocationConstraint invocationConstraint) {
        if (invocationConstraint instanceof ServerMinPrincipal) {
            Set set = ((ServerMinPrincipal)invocationConstraint).elements();
            return set.size() == 1 && set.contains(x500Principal);
        }
        if (invocationConstraint instanceof ConstraintAlternatives) {
            Set set = ((ConstraintAlternatives)invocationConstraint).elements();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!X500Constraints.serverPrincipalSatisfies(x500Principal, (InvocationConstraint)iterator.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static {
        List<Object> list = Arrays.asList(Confidentiality.NO, Delegation.NO, DelegationAbsoluteTime.class, DelegationRelativeTime.class, Integrity.YES);
        supportedRequestConstraints = new HashSet<Object>(list);
        supportedRequestConstraints.add(ClientAuthentication.YES);
        supportedRequestConstraints.add(ServerAuthentication.NO);
        supportedAnnouncementConstraints = new HashSet<Object>(list);
        supportedAnnouncementConstraints.add(ClientAuthentication.NO);
        supportedAnnouncementConstraints.add(ServerAuthentication.YES);
        principalConstraints = new HashSet();
        principalConstraints.add(ClientMaxPrincipal.class);
        principalConstraints.add(ClientMaxPrincipalType.class);
        principalConstraints.add(ClientMinPrincipal.class);
        principalConstraints.add(ClientMinPrincipalType.class);
        principalConstraints.add(ServerMinPrincipal.class);
    }
}

