/*
 * Decompiled with CFR 0.152.
 */
package net.jini.activation;

import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnknownHostException;
import java.rmi.activation.ActivateFailedException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.io.UnsupportedConstraintException;
import net.jini.security.Security;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.TrustEquivalence;

public final class ActivatableInvocationHandler
implements InvocationHandler,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = -428224070630550856L;
    private static final int MAX_RETRIES = 3;
    private static final Logger logger;
    private static final Class[] constructorArgs;
    private final ActivationID id;
    private Remote uproxy;
    private final MethodConstraints clientConstraints;
    private static final Method getPtiMethod;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ActivatableInvocationHandler(ActivationID activationID, Remote remote) {
        if (activationID == null) {
            throw new NullPointerException("id is null");
        }
        this.id = activationID;
        this.uproxy = remote;
        this.clientConstraints = null;
        this.makeConstraintsConsistent();
    }

    private void makeConstraintsConsistent() {
        if (this.uproxy instanceof RemoteMethodControl) {
            MethodConstraints methodConstraints = ((RemoteMethodControl)((Object)this.uproxy)).getConstraints();
            if (this.clientConstraints == null ? methodConstraints != null : !this.clientConstraints.equals(methodConstraints)) {
                this.uproxy = (Remote)((Object)((RemoteMethodControl)((Object)this.uproxy)).setConstraints(this.clientConstraints));
            }
        }
    }

    private ActivatableInvocationHandler(ActivationID activationID, Remote remote, MethodConstraints methodConstraints) {
        this.id = activationID;
        this.uproxy = remote;
        this.clientConstraints = methodConstraints;
    }

    public ActivationID getActivationID() {
        return this.id;
    }

    public synchronized Object getCurrentProxy() {
        return this.uproxy;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Object.class) {
            return this.invokeObjectMethod(object, method, objectArray);
        }
        if (clazz == RemoteMethodControl.class) {
            return this.invokeRemoteMethodControlMethod(object, method, objectArray);
        }
        if (clazz == TrustEquivalence.class) {
            return this.invokeTrustEquivalenceMethod(object, method, objectArray);
        }
        return this.invokeRemoteMethod(object, method, objectArray);
    }

    private Object invokeObjectMethod(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (string.equals("equals")) {
            Object object2 = objectArray[0];
            boolean bl = object == object2 || object2 != null && Util.sameProxyClass(object, object2) && this.equals(Proxy.getInvocationHandler(object2));
            return bl;
        }
        if (string.equals("toString")) {
            return this.proxyToString(object);
        }
        throw new IllegalArgumentException("unexpected Object method: " + method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteMethodControlMethod(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (string.equals("setConstraints")) {
            Remote remote;
            if (Proxy.getInvocationHandler(object) != this) {
                throw new IllegalArgumentException("not proxy for this");
            }
            Object object2 = this;
            synchronized (object2) {
                remote = this.uproxy;
            }
            object2 = (MethodConstraints)objectArray[0];
            if (remote instanceof RemoteMethodControl) {
                remote = (Remote)((Object)((RemoteMethodControl)((Object)remote)).setConstraints((MethodConstraints)object2));
            }
            Class<?> clazz = object.getClass();
            return Proxy.newProxyInstance(ActivatableInvocationHandler.getProxyLoader(clazz), clazz.getInterfaces(), (InvocationHandler)new ActivatableInvocationHandler(this.id, remote, (MethodConstraints)object2));
        }
        if (string.equals("getConstraints")) {
            return this.clientConstraints;
        }
        throw new AssertionError(method);
    }

    private Object invokeTrustEquivalenceMethod(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals("checkTrustEquivalence")) {
            Object object2 = objectArray[0];
            boolean bl = object == object2 || object2 != null && Util.sameProxyClass(object, object2) && this.checkTrustEquivalence(Proxy.getInvocationHandler(object2));
            return bl;
        }
        throw new AssertionError(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeRemoteMethod(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        InvocationConstraints invocationConstraints;
        BasicMethodConstraints basicMethodConstraints = null;
        if (this.clientConstraints != null && (invocationConstraints = this.clientConstraints.getConstraints(method)) != (object2 = invocationConstraints.makeAbsolute())) {
            basicMethodConstraints = new BasicMethodConstraints((InvocationConstraints)object2);
        }
        boolean bl = false;
        Failure failure = null;
        ActivatableInvocationHandler activatableInvocationHandler = this;
        synchronized (activatableInvocationHandler) {
            if (this.uproxy == null) {
                this.activate(bl, object, method);
                bl = true;
            }
            object2 = this.uproxy;
        }
        int n = 3;
        while (--n >= 0) {
            if (logger.isLoggable(Levels.HANDLED) && failure != null) {
                this.logThrow(Levels.HANDLED, "outbound call", "invokeRemoteMethod", method, failure.exception);
            }
            if (this.clientConstraints != null && !(object2 instanceof RemoteMethodControl)) {
                throw new UnsupportedConstraintException("underlying proxy does not implement RemoteMethodControl");
            }
            Object object3 = basicMethodConstraints == null ? object2 : (Remote)((Object)((RemoteMethodControl)object2).setConstraints(basicMethodConstraints));
            Object object4 = this.invokeMethod(object3, method, objectArray);
            if (object4 instanceof Failure) {
                failure = (Failure)object4;
                if (!failure.retry || n <= 0) {
                    break;
                }
            } else {
                return object4;
            }
            ActivatableInvocationHandler activatableInvocationHandler2 = this;
            synchronized (activatableInvocationHandler2) {
                if (this.uproxy == null || object2.equals(this.uproxy)) {
                    this.activate(bl, object, method);
                    if (object2.equals(this.uproxy) && failure.exception instanceof NoSuchObjectException && !bl) {
                        this.activate(true, object, method);
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                object2 = this.uproxy;
            }
        }
        if (logger.isLoggable(Levels.FAILED)) {
            this.logThrow(Levels.FAILED, "outbound call", "invokeRemoteMethod", method, failure.exception);
        }
        throw failure.exception;
    }

    private void logThrow(Level level, String string, String string2, Method method, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string + " {0}.{1} throws");
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(this.getClass().getName());
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(new Object[]{method.getDeclaringClass().getName(), method.getName()});
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeMethod(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            return ActivatableInvocationHandler.invokeMethod0(object, method, objectArray);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return new Failure(noSuchObjectException, true);
        }
        catch (ConnectException connectException) {
            return new Failure(connectException, true);
        }
        catch (UnknownHostException unknownHostException) {
            return new Failure(unknownHostException, true);
        }
        catch (ConnectIOException connectIOException) {
            return new Failure(connectIOException, true);
        }
        catch (MarshalException marshalException) {
            return new Failure(marshalException, false);
        }
        catch (ServerError serverError) {
            return new Failure(serverError, false);
        }
        catch (ServerException serverException) {
            return new Failure(serverException, false);
        }
        catch (RemoteException remoteException) {
            ActivatableInvocationHandler activatableInvocationHandler = this;
            synchronized (activatableInvocationHandler) {
                if (object.equals(this.uproxy)) {
                    this.uproxy = null;
                }
            }
            return new Failure(remoteException, remoteException instanceof ActivateFailedException);
        }
        catch (Exception exception) {
            return new Failure(exception, false);
        }
    }

    private static Object invokeMethod0(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz;
        Class<?> clazz2 = method.getDeclaringClass();
        if (!Modifier.isPublic(clazz2.getModifiers()) && clazz2.isAssignableFrom(clazz = object.getClass()) && Modifier.isPublic(clazz.getModifiers())) {
            try {
                method = clazz.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ActivateFailedException("bad proxy").initCause((Throwable)noSuchMethodException);
            }
        }
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ActivateFailedException("bad proxy").initCause((Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ActivateFailedException("bad proxy").initCause((Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    protected ProxyTrustIterator getProxyTrustIterator() {
        return new ProxyTrustIterator(){
            private int retries = 4;
            private boolean force = false;
            private Remote currProxy = null;
            private Exception fail = null;
            private RemoteException ex = null;
            private boolean advance = true;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized boolean hasNext() {
                if (this.advance) {
                    this.advance = false;
                    if (--this.retries >= 0) {
                        if (this.retries == 3 || this.ex instanceof NoSuchObjectException || this.ex instanceof ConnectException || this.ex instanceof UnknownHostException || this.ex instanceof ConnectIOException) {
                            try {
                                ActivatableInvocationHandler activatableInvocationHandler = ActivatableInvocationHandler.this;
                                synchronized (activatableInvocationHandler) {
                                    if (ActivatableInvocationHandler.this.uproxy == null || ActivatableInvocationHandler.this.uproxy.equals(this.currProxy)) {
                                        ActivatableInvocationHandler.this.activate(this.force, null, getPtiMethod);
                                        if (ActivatableInvocationHandler.this.uproxy.equals(this.currProxy) && this.ex instanceof NoSuchObjectException && !this.force) {
                                            ActivatableInvocationHandler.this.activate(true, null, getPtiMethod);
                                        }
                                        this.force = true;
                                    } else {
                                        this.force = false;
                                    }
                                    this.currProxy = ActivatableInvocationHandler.this.uproxy;
                                }
                            }
                            catch (Exception exception) {
                                this.fail = exception;
                                this.retries = 0;
                            }
                        } else {
                            this.retries = -1;
                            if (!(this.ex == null || this.ex instanceof MarshalException || this.ex instanceof ServerException || this.ex instanceof ServerError)) {
                                ActivatableInvocationHandler activatableInvocationHandler = ActivatableInvocationHandler.this;
                                synchronized (activatableInvocationHandler) {
                                    if (this.currProxy.equals(ActivatableInvocationHandler.this.uproxy)) {
                                        ActivatableInvocationHandler.this.uproxy = null;
                                    }
                                }
                            }
                        }
                    }
                }
                return this.retries >= 0;
            }

            public synchronized Object next() throws RemoteException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.advance = true;
                if (this.fail == null) {
                    return this.currProxy;
                }
                if (this.fail instanceof RemoteException) {
                    throw (RemoteException)this.fail;
                }
                throw (RuntimeException)this.fail;
            }

            public synchronized void setException(RemoteException remoteException) {
                if (remoteException == null) {
                    throw new NullPointerException("exception is null");
                }
                if (this.retries > 3 || !this.advance || this.fail != null) {
                    throw new IllegalStateException();
                }
                this.ex = remoteException;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTrustEquivalence(Object object) {
        Remote remote;
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivatableInvocationHandler) || !(this.id instanceof TrustEquivalence)) {
            return false;
        }
        ActivatableInvocationHandler activatableInvocationHandler = (ActivatableInvocationHandler)object;
        if (!((TrustEquivalence)this.id).checkTrustEquivalence(activatableInvocationHandler.id) || this.clientConstraints != activatableInvocationHandler.clientConstraints && (this.clientConstraints == null || !this.clientConstraints.equals(activatableInvocationHandler.clientConstraints))) {
            return false;
        }
        Object object2 = this;
        synchronized (object2) {
            remote = this.uproxy;
        }
        ActivatableInvocationHandler activatableInvocationHandler2 = activatableInvocationHandler;
        synchronized (activatableInvocationHandler2) {
            object2 = activatableInvocationHandler.uproxy;
        }
        if (remote == null || !(remote instanceof TrustEquivalence) || !((TrustEquivalence)((Object)remote)).checkTrustEquivalence(object2)) {
            activatableInvocationHandler2 = activatableInvocationHandler;
            synchronized (activatableInvocationHandler2) {
                activatableInvocationHandler.uproxy = null;
            }
        }
        return true;
    }

    private void activate(boolean bl, Object object, Method method) throws Exception {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            this.activate0(bl, object);
        }
        catch (Exception exception) {
            if (logger.isLoggable(Levels.FAILED)) {
                this.logThrow(Levels.FAILED, "activating object for call", "activate", method, exception);
            }
            throw exception;
        }
    }

    private void activate0(boolean bl, Object object) throws RemoteException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.uproxy = null;
        try {
            Remote remote;
            if (object != null) {
                try {
                    Security.grant(object.getClass(), this.id.getClass());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if (!Proxy.isProxyClass((remote = this.id.activate(bl)).getClass())) {
                throw new ActivateFailedException("invalid proxy");
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(remote);
            if (!(invocationHandler instanceof ActivatableInvocationHandler)) {
                throw new ActivateFailedException("invalid proxy handler");
            }
            ActivatableInvocationHandler activatableInvocationHandler = (ActivatableInvocationHandler)invocationHandler;
            if (!this.id.equals((Object)activatableInvocationHandler.id)) {
                throw new ActivateFailedException("unexpected activation id");
            }
            Remote remote2 = activatableInvocationHandler.uproxy;
            if (remote2 == null) {
                throw new ActivateFailedException("null underlying proxy");
            }
            if (remote2 instanceof RemoteMethodControl) {
                remote2 = (Remote)((Object)((RemoteMethodControl)((Object)remote2)).setConstraints(this.clientConstraints));
            }
            this.uproxy = remote2;
        }
        catch (RemoteException remoteException) {
            throw new ConnectIOException("activation failed", remoteException);
        }
        catch (UnknownObjectException unknownObjectException) {
            throw new NoSuchObjectException("object not registered");
        }
        catch (ActivationException activationException) {
            throw new ActivateFailedException("activation failed", (Exception)((Object)activationException));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ActivatableInvocationHandler)) {
            return false;
        }
        ActivatableInvocationHandler activatableInvocationHandler = (ActivatableInvocationHandler)object;
        return this.id.equals((Object)activatableInvocationHandler.id) && (this.clientConstraints == activatableInvocationHandler.clientConstraints || this.clientConstraints != null && this.clientConstraints.equals(activatableInvocationHandler.clientConstraints));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "ActivatableInvocationHandler[" + this.id + ", " + this.uproxy + "]";
    }

    private String proxyToString(Object object) {
        Class<?>[] classArray = object.getClass().getInterfaces();
        Class<?> clazz = null;
        int n = classArray.length;
        while (--n >= 0 && classArray[n] != (class$net$jini$core$constraint$RemoteMethodControl == null ? ActivatableInvocationHandler.class$("net.jini.core.constraint.RemoteMethodControl") : class$net$jini$core$constraint$RemoteMethodControl)) {
            clazz = classArray[n];
        }
        if (clazz == null) {
            return "Proxy[" + this + "]";
        }
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        return "Proxy[" + string + "," + this + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.id == null) {
            throw new InvalidObjectException("id is null");
        }
        this.makeConstraintsConsistent();
    }

    private static ClassLoader getProxyLoader(final Class clazz) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    static {
        $assertionsDisabled = !ActivatableInvocationHandler.class.desiredAssertionStatus();
        logger = Logger.getLogger("net.jini.activation.ActivatableInvocationHandler");
        constructorArgs = new Class[]{InvocationHandler.class};
        try {
            getPtiMethod = ActivatableInvocationHandler.class.getDeclaredMethod("getProxyTrustIterator", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    private static class Failure {
        final Throwable exception;
        final boolean retry;

        Failure(Throwable throwable, boolean bl) {
            this.exception = throwable;
            this.retry = bl;
        }
    }
}

