/*
 * Decompiled with CFR 0.152.
 */
package net.jini.constraint;

import [Lnet.jini.constraint.BasicMethodConstraints;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;

public final class BasicMethodConstraints
implements MethodConstraints,
Serializable {
    private static final long serialVersionUID = 1432234194703790047L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descs", BasicMethodConstraints.MethodDesc;.class, true)};
    private final MethodDesc[] descs;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Class;
    static /* synthetic */ Class class$net$jini$core$constraint$InvocationConstraints;

    public BasicMethodConstraints(MethodDesc[] methodDescArray) {
        this.descs = (MethodDesc[])methodDescArray.clone();
        this.check();
    }

    private void check() {
        if (this.descs.length == 0) {
            throw new IllegalArgumentException("must have at least one descriptor");
        }
        for (int i = 0; i < this.descs.length; ++i) {
            Object object;
            int n;
            MethodDesc methodDesc = this.descs[i];
            String string = methodDesc.name;
            if (string == null) {
                if (i >= this.descs.length - 1) continue;
                throw new IllegalArgumentException("default descriptor must be last");
            }
            if (string.charAt(0) == '*') {
                n = string.length() + 1;
                for (int j = 0; j < i; ++j) {
                    object = this.descs[j];
                    String string2 = ((MethodDesc)object).name;
                    if (string2.charAt(0) != '*' || !string2.regionMatches(1, string, n - string2.length(), string2.length() - 1)) continue;
                    BasicMethodConstraints.check((MethodDesc)object, methodDesc);
                }
                continue;
            }
            if (string.charAt(string.length() - 1) == '*') {
                for (n = 0; n < i; ++n) {
                    MethodDesc methodDesc2 = this.descs[n];
                    object = methodDesc2.name;
                    int n2 = ((String)object).length() - 1;
                    if (((String)object).charAt(n2) != '*' || !((String)object).regionMatches(0, string, 0, n2)) continue;
                    BasicMethodConstraints.check(methodDesc2, methodDesc);
                }
                continue;
            }
            for (n = 0; n < i; ++n) {
                MethodDesc methodDesc3 = this.descs[n];
                object = methodDesc3.name;
                int n3 = ((String)object).length() - 1;
                if (((String)object).charAt(0) == '*') {
                    if (!string.regionMatches(string.length() - n3, (String)object, 1, n3)) continue;
                    BasicMethodConstraints.check(methodDesc3, methodDesc);
                    continue;
                }
                if (((String)object).charAt(n3) == '*') {
                    if (!string.regionMatches(0, (String)object, 0, n3)) continue;
                    BasicMethodConstraints.check(methodDesc3, methodDesc);
                    continue;
                }
                if (!((String)object).equals(string)) continue;
                BasicMethodConstraints.check(methodDesc3, methodDesc);
            }
        }
    }

    private static void check(MethodDesc methodDesc, MethodDesc methodDesc2) {
        if (methodDesc.types == null || Arrays.equals(methodDesc.types, methodDesc2.types)) {
            StringBuffer stringBuffer = new StringBuffer();
            methodDesc.toString(stringBuffer, false);
            stringBuffer.append(" cannot precede ");
            methodDesc2.toString(stringBuffer, false);
            throw new IllegalArgumentException(stringBuffer.toString());
        }
    }

    public BasicMethodConstraints(InvocationConstraints invocationConstraints) {
        this.descs = new MethodDesc[]{new MethodDesc(invocationConstraints)};
    }

    public InvocationConstraints getConstraints(Method method) {
        String string = method.getName();
        Class<?>[] classArray = null;
        InvocationConstraints invocationConstraints = null;
        block0: for (int i = 0; i < this.descs.length; ++i) {
            int n;
            MethodDesc methodDesc = this.descs[i];
            String string2 = methodDesc.name;
            if (string2 == null) {
                invocationConstraints = methodDesc.constraints;
                break;
            }
            if (methodDesc.types != null) {
                if (!string.equals(string2)) continue;
                if (classArray == null) {
                    classArray = method.getParameterTypes();
                }
                if (classArray.length != methodDesc.types.length) continue;
                n = classArray.length;
                while (--n >= 0) {
                    if (classArray[n] == methodDesc.types[n]) continue;
                    continue block0;
                }
                invocationConstraints = methodDesc.constraints;
                break;
            }
            n = string2.length() - 1;
            if (string2.charAt(0) == '*') {
                if (!string.regionMatches(string.length() - n, string2, 1, n)) continue;
                invocationConstraints = methodDesc.constraints;
                break;
            }
            if (string2.charAt(n) == '*') {
                if (!string.regionMatches(0, string2, 0, n)) continue;
                invocationConstraints = methodDesc.constraints;
                break;
            }
            if (!string.equals(string2)) continue;
            invocationConstraints = methodDesc.constraints;
            break;
        }
        if (invocationConstraints == null) {
            invocationConstraints = InvocationConstraints.EMPTY;
        }
        return invocationConstraints;
    }

    public Iterator possibleConstraints() {
        return new Iterator(){
            private int i;
            private boolean empty;
            {
                this.i = BasicMethodConstraints.this.descs.length;
                this.empty = ((BasicMethodConstraints)BasicMethodConstraints.this).descs[this.i - 1].name != null;
            }

            public boolean hasNext() {
                return this.i > 0 || this.empty;
            }

            public Object next() {
                if (this.i == 0) {
                    if (this.empty) {
                        this.empty = false;
                        return InvocationConstraints.EMPTY;
                    }
                    throw new NoSuchElementException("no more elements");
                }
                InvocationConstraints invocationConstraints = ((BasicMethodConstraints)BasicMethodConstraints.this).descs[--this.i].constraints;
                if (invocationConstraints == null) {
                    invocationConstraints = InvocationConstraints.EMPTY;
                }
                return invocationConstraints;
            }

            public void remove() {
                throw new UnsupportedOperationException("immutable object");
            }
        };
    }

    public MethodDesc[] getMethodDescs() {
        return (MethodDesc[])this.descs.clone();
    }

    public int hashCode() {
        return BasicMethodConstraints.hash(this.descs);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("BasicMethodConstraints{");
        for (int i = 0; i < this.descs.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            this.descs[i].toString(stringBuffer, true);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof BasicMethodConstraints && Arrays.equals(this.descs, ((BasicMethodConstraints)object).descs);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.check();
        }
        catch (RuntimeException runtimeException) {
            BasicMethodConstraints.rethrow(runtimeException);
        }
    }

    private static int hash(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            n += objectArray[n2].hashCode();
        }
        return n;
    }

    private static void rethrow(RuntimeException runtimeException) throws InvalidObjectException {
        if (runtimeException instanceof NullPointerException || runtimeException instanceof IllegalArgumentException) {
            InvalidObjectException invalidObjectException = new InvalidObjectException(runtimeException.getMessage());
            invalidObjectException.initCause(runtimeException);
            throw invalidObjectException;
        }
        throw runtimeException;
    }

    public static final class MethodDesc
    implements Serializable {
        private static final long serialVersionUID = 6773269226844208999L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = BasicMethodConstraints.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("types", array$Ljava$lang$Class == null ? (array$Ljava$lang$Class = BasicMethodConstraints.class$("[Ljava.lang.Class;")) : array$Ljava$lang$Class, true), new ObjectStreamField("constraints", class$net$jini$core$constraint$InvocationConstraints == null ? (class$net$jini$core$constraint$InvocationConstraints = BasicMethodConstraints.class$("net.jini.core.constraint.InvocationConstraints")) : class$net$jini$core$constraint$InvocationConstraints)};
        final String name;
        final Class[] types;
        final InvocationConstraints constraints;

        public MethodDesc(String string, Class[] classArray, InvocationConstraints invocationConstraints) {
            this.name = string;
            this.types = (Class[])classArray.clone();
            if (invocationConstraints != null && invocationConstraints.isEmpty()) {
                invocationConstraints = null;
            }
            this.constraints = invocationConstraints;
            this.check();
        }

        public MethodDesc(String string, InvocationConstraints invocationConstraints) {
            this.name = string;
            this.types = null;
            if (invocationConstraints != null && invocationConstraints.isEmpty()) {
                invocationConstraints = null;
            }
            this.constraints = invocationConstraints;
            this.check();
        }

        private void check() {
            boolean bl = this.types == null;
            int n = this.name.length();
            if (n == 0) {
                throw new IllegalArgumentException("method name cannot be empty");
            }
            char c = this.name.charAt(0);
            if (!(Character.isJavaIdentifierStart(c) || bl && c == '*' && n > 1)) {
                throw new IllegalArgumentException("invalid method name");
            }
            if (bl && c != '*' && this.name.charAt(n - 1) == '*') {
                --n;
            }
            while (--n >= 1) {
                if (Character.isJavaIdentifierPart(this.name.charAt(n))) continue;
                throw new IllegalArgumentException("invalid method name");
            }
            if (this.types != null) {
                int n2 = this.types.length;
                while (--n2 >= 0) {
                    if (this.types[n2] != null) continue;
                    throw new NullPointerException("class cannot be null");
                }
            }
        }

        public MethodDesc(InvocationConstraints invocationConstraints) {
            this.name = null;
            this.types = null;
            if (invocationConstraints != null && invocationConstraints.isEmpty()) {
                invocationConstraints = null;
            }
            this.constraints = invocationConstraints;
        }

        public String getName() {
            return this.name;
        }

        public Class[] getParameterTypes() {
            return this.types == null ? null : (Class[])this.types.clone();
        }

        public InvocationConstraints getConstraints() {
            return this.constraints == null ? InvocationConstraints.EMPTY : this.constraints;
        }

        public int hashCode() {
            int n = 0;
            if (this.name != null) {
                n += this.name.hashCode();
            }
            if (this.types != null) {
                n += BasicMethodConstraints.hash(this.types);
            }
            if (this.constraints != null) {
                n += this.constraints.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MethodDesc)) {
                return false;
            }
            MethodDesc methodDesc = (MethodDesc)object;
            return (this.name == null ? methodDesc.name == null : this.name.equals(methodDesc.name)) && Arrays.equals(this.types, methodDesc.types) && (this.constraints == null ? methodDesc.constraints == null : this.constraints.equals(methodDesc.constraints));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("MethodDesc[");
            this.toString(stringBuffer, true);
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        void toString(StringBuffer stringBuffer, boolean bl) {
            stringBuffer.append(this.name == null ? "default" : this.name);
            if (this.types != null) {
                stringBuffer.append('(');
                for (int i = 0; i < this.types.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.types[i].getName());
                }
                stringBuffer.append(')');
            }
            if (bl) {
                stringBuffer.append(" => ").append(this.constraints);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.name == null) {
                if (this.types != null) {
                    throw new InvalidObjectException("cannot have types with null name");
                }
            } else {
                try {
                    this.check();
                }
                catch (RuntimeException runtimeException) {
                    BasicMethodConstraints.rethrow(runtimeException);
                }
            }
            if (this.constraints != null && this.constraints.isEmpty()) {
                throw new InvalidObjectException("constraints cannot be empty");
            }
        }
    }
}

