/*
 * Decompiled with CFR 0.152.
 */
package net.jini.iiop;

import java.lang.ref.WeakReference;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import net.jini.export.Exporter;
import org.omg.CORBA.ORB;

public final class IiopExporter
implements Exporter {
    private static final Logger logger = Logger.getLogger("net.jini.iiop.IiopExporter");
    private ORB orb;
    private WeakReference ref;

    public IiopExporter() {
    }

    public IiopExporter(ORB oRB) {
        this.orb = oRB;
    }

    public synchronized Remote export(Remote remote) throws ExportException {
        if (remote == null) {
            throw new NullPointerException();
        }
        if (this.ref != null) {
            throw new IllegalStateException("object already exported via this exporter");
        }
        if (IiopExporter.getTieClass(remote.getClass()) == null) {
            throw new ExportException("tie class unavailable");
        }
        this.ref = new WeakReference<Remote>(remote);
        try {
            PortableRemoteObject.exportObject((Remote)remote);
            Remote remote2 = PortableRemoteObject.toStub((Remote)remote);
            if (this.orb != null) {
                ((Stub)remote2).connect(this.orb);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "export of {0} via {1} returns proxy {2}", new Object[]{remote, this, remote2});
            }
            return remote2;
        }
        catch (ExportException exportException) {
            throw exportException;
        }
        catch (RemoteException remoteException) {
            throw new ExportException("export failed", remoteException);
        }
    }

    public synchronized boolean unexport(boolean bl) {
        if (this.ref == null) {
            throw new IllegalStateException("an object has not been exported via this exporter");
        }
        Remote remote = (Remote)this.ref.get();
        if (remote != null) {
            try {
                PortableRemoteObject.unexportObject((Remote)remote);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "unexport on {0} returns {1}", new Object[]{this, Boolean.TRUE});
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        return true;
    }

    public String toString() {
        return this.orb != null ? "IiopExporter[" + this.orb + "]" : "IiopExporter[]";
    }

    private static Class getTieClass(Class clazz) {
        String string = clazz.getName();
        int n = string.indexOf(36);
        if (n < 0) {
            n = string.lastIndexOf(46);
        }
        String string2 = n > 0 ? string.substring(0, n + 1) + "_" + string.substring(n + 1) + "_Tie" : "_" + string + "_Tie";
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string2);
        if (string2.startsWith("java.") || string2.startsWith("com.sun.") || string2.startsWith("net.jini.") || string2.startsWith("jini.") || string2.startsWith("javax.")) {
            arrayList.add("org.omg.stub." + string2);
        }
        ClassLoader classLoader = clazz.getClassLoader();
        String string3 = Util.getCodebase((Class)clazz);
        Class clazz2 = arrayList.iterator();
        while (clazz2.hasNext()) {
            string2 = (String)clazz2.next();
            try {
                return Util.loadClass((String)string2, (String)string3, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (classLoader == null) continue;
                try {
                    return classLoader.loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
        }
        clazz2 = clazz.getSuperclass();
        return clazz2 != null && clazz2 != PortableRemoteObject.class && clazz2 != Object.class ? IiopExporter.getTieClass(clazz2) : null;
    }
}

