/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.logging.Levels;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.jeri.ssl.FilterX509TrustManager;
import net.jini.jeri.ssl.SubjectCredentials;

abstract class AuthManager
extends FilterX509TrustManager
implements X509KeyManager {
    private final WeakReference subjectRef;
    final boolean subjectIsReadOnly;
    private final Set permittedLocalPrincipals;

    AuthManager(Subject subject, Set set, Set set2) throws NoSuchAlgorithmException {
        super(set2);
        this.subjectRef = new WeakReference<Subject>(subject);
        this.subjectIsReadOnly = subject == null || subject.isReadOnly();
        this.permittedLocalPrincipals = set == null ? null : new HashSet(set);
    }

    abstract X500PrivateCredential getPrivateCredential(X509Certificate var1);

    abstract Logger getLogger();

    Subject getSubject() {
        return (Subject)this.subjectRef.get();
    }

    String[] getAliases(String string, Principal[] principalArray) {
        List list = SubjectCredentials.getCertificateChains(this.getSubject());
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = null;
        int n = list.size();
        while (--n >= 0) {
            Logger logger;
            Exception exception;
            CertPath certPath = (CertPath)list.get(n);
            try {
                if (this.checkChain(certPath, string, principalArray) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(list.size());
                }
                arrayList.add(SubjectCredentials.getCertificateName(AuthManager.firstX509Cert(certPath)));
                continue;
            }
            catch (GeneralSecurityException generalSecurityException) {
                exception = generalSecurityException;
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
            if (!(logger = this.getLogger()).isLoggable(Levels.HANDLED)) continue;
            AuthManager.logThrow(logger, Levels.HANDLED, class$net$jini$jeri$ssl$AuthManager == null ? AuthManager.class$("net.jini.jeri.ssl.AuthManager") : class$net$jini$jeri$ssl$AuthManager, "getAliases", "get aliases for key type {0}\nand issuers {1}\ncaught exception", new Object[]{string, AuthManager.toString(principalArray)}, exception);
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    X500PrivateCredential chooseCredential(String string, Principal[] principalArray) throws GeneralSecurityException {
        Serializable serializable;
        List list = SubjectCredentials.getCertificateChains(this.getSubject());
        if (list == null) {
            return null;
        }
        ArrayList<GeneralSecurityException> arrayList = null;
        int n = list.size();
        while (--n >= 0) {
            Exception exception;
            Object object;
            serializable = (CertPath)list.get(n);
            try {
                object = this.checkChain((CertPath)serializable, string, principalArray);
                if (object == null) continue;
                return object;
            }
            catch (GeneralSecurityException generalSecurityException) {
                exception = generalSecurityException;
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<GeneralSecurityException>();
            }
            arrayList.add((GeneralSecurityException)exception);
            object = this.getLogger();
            if (!((Logger)object).isLoggable(Levels.HANDLED)) continue;
            AuthManager.logThrow((Logger)object, Levels.HANDLED, class$net$jini$jeri$ssl$AuthManager == null ? AuthManager.class$("net.jini.jeri.ssl.AuthManager") : class$net$jini$jeri$ssl$AuthManager, "chooseCredential", "choose credential for key type {0}\nand issuers {1}\ncaught exception", new Object[]{string, AuthManager.toString(principalArray)}, exception);
        }
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() > 1) {
            n = arrayList.size();
            while (--n >= 0) {
                serializable = (Exception)arrayList.get(n);
                if (serializable instanceof SecurityException) continue;
                throw new GeneralSecurityException(((Object)arrayList).toString());
            }
            throw new SecurityException(((Object)arrayList).toString());
        }
        if (arrayList.get(0) instanceof SecurityException) {
            throw (SecurityException)arrayList.get(0);
        }
        throw (GeneralSecurityException)arrayList.get(0);
    }

    private X500PrivateCredential checkChain(CertPath certPath, String string, Principal[] principalArray) throws GeneralSecurityException {
        X509Certificate x509Certificate = AuthManager.firstX509Cert(certPath);
        String string2 = x509Certificate.getPublicKey().getAlgorithm();
        if (!string2.equals(string)) {
            return null;
        }
        Subject subject = this.getSubject();
        X500Principal x500Principal = SubjectCredentials.getPrincipal(subject, x509Certificate);
        if (x500Principal == null) {
            throw new GeneralSecurityException("Principal not found: " + x509Certificate.getSubjectDN());
        }
        if (this.permittedLocalPrincipals != null && !this.permittedLocalPrincipals.contains(x500Principal)) {
            throw new GeneralSecurityException("Local principal not permitted: " + x509Certificate.getSubjectDN());
        }
        X500Principal[] x500PrincipalArray = null;
        if (principalArray != null) {
            x500PrincipalArray = new X500Principal[principalArray.length];
            int n = principalArray.length;
            while (--n >= 0) {
                x500PrincipalArray[n] = principalArray[n] instanceof X500Principal ? (X500Principal)principalArray[n] : new X500Principal(principalArray[n].getName());
            }
        }
        AuthManager.checkValidity(certPath, x500PrincipalArray);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null && blArray.length > 0 && !blArray[0]) {
            throw new CertificateException("Certificate not permitted for digital signatures: " + x509Certificate);
        }
        X500PrivateCredential x500PrivateCredential = this.getPrivateCredential(x509Certificate);
        if (x500PrivateCredential == null) {
            throw new KeyException("Private key not found for certificate: " + x509Certificate);
        }
        return x500PrivateCredential;
    }

    static long certificatesValidUntil(CertPath certPath) {
        long l = Long.MAX_VALUE;
        List<? extends Certificate> list = certPath.getCertificates();
        int n = list.size();
        while (--n >= 0) {
            X509Certificate x509Certificate = (X509Certificate)list.get(n);
            long l2 = x509Certificate.getNotAfter().getTime();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    static long certificatesValidUntil(X509Certificate[] x509CertificateArray) {
        long l = Long.MAX_VALUE;
        int n = x509CertificateArray.length;
        while (--n >= 0) {
            X509Certificate x509Certificate = x509CertificateArray[n];
            long l2 = x509Certificate.getNotAfter().getTime();
            if (l2 >= l) continue;
            l = l2;
        }
        return l;
    }

    boolean equalPrivateCredentials(X500PrivateCredential x500PrivateCredential, X500PrivateCredential x500PrivateCredential2) {
        if (x500PrivateCredential == null || x500PrivateCredential2 == null) {
            return false;
        }
        X509Certificate x509Certificate = x500PrivateCredential.getCertificate();
        X509Certificate x509Certificate2 = x500PrivateCredential2.getCertificate();
        if (x509Certificate == null || x509Certificate2 == null || !AuthManager.safeEquals(x509Certificate.getSubjectDN(), x509Certificate2.getSubjectDN())) {
            return false;
        }
        PrivateKey privateKey = x500PrivateCredential.getPrivateKey();
        return privateKey != null && privateKey.equals(x500PrivateCredential2.getPrivateKey());
    }

    public X509Certificate[] getCertificateChain(String string) {
        CertPath certPath = SubjectCredentials.getCertificateChain(this.getSubject(), string);
        List<? extends Certificate> list = certPath.getCertificates();
        return list.toArray(new X509Certificate[list.size()]);
    }

    public PrivateKey getPrivateKey(String string) {
        block4: {
            CertPath certPath = SubjectCredentials.getCertificateChain(this.getSubject(), string);
            if (certPath != null) {
                try {
                    X500PrivateCredential x500PrivateCredential = this.getPrivateCredential(AuthManager.firstX509Cert(certPath));
                    if (x500PrivateCredential != null) {
                        return x500PrivateCredential.getPrivateKey();
                    }
                }
                catch (SecurityException securityException) {
                    Logger logger = this.getLogger();
                    if (!logger.isLoggable(Levels.HANDLED)) break block4;
                    AuthManager.logThrow(logger, Levels.HANDLED, AuthManager.class, "getPrivateKey", "get private key for alias {0}\ncaught exception", new Object[]{string}, securityException);
                }
            }
        }
        return null;
    }
}

