/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webproxy;

import com.mathworks.webproxy.ProxyConfigurationVisitor;
import com.mathworks.webproxy.SystemProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;

abstract class AbstractSystemProxyConfiguration
implements SystemProxyConfiguration {
    private final SystemProxySettings systemProxySettings;
    private static final String PORT_HOST_SEPARATOR = ":";
    private static final String PROXY_SERVER_SEPARATOR = ";";

    AbstractSystemProxyConfiguration(SystemProxySettings systemProxySettings) {
        this.systemProxySettings = systemProxySettings;
    }

    protected abstract boolean isEnabled(SystemProxySettings var1);

    protected abstract String parseHostAndPort(String var1, URL var2) throws IllegalArgumentException;

    protected abstract String getProxyServers(URL var1, SystemProxySettings var2);

    protected abstract Proxy getProxyWhenInvalidPortSpecified(String var1, URL var2);

    protected abstract Proxy getProxyWhenNoPortSpecified(String var1, URL var2);

    @Override
    public final boolean accept(ProxyConfigurationVisitor proxyConfigurationVisitor) {
        if (this.isEnabled(this.systemProxySettings)) {
            proxyConfigurationVisitor.visit(this);
            return true;
        }
        return false;
    }

    @Override
    public final Proxy findProxyForURL(URL uRL) {
        String string = this.getProxyServers(uRL, this.systemProxySettings);
        if (AbstractSystemProxyConfiguration.atLeastOneProxyServerDefined(string)) {
            for (String string2 : string.split(PROXY_SERVER_SEPARATOR)) {
                try {
                    String string3 = this.parseHostAndPort(string2.trim(), uRL);
                    return this.getProxyForHostAndPort(string3, uRL);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return Proxy.NO_PROXY;
    }

    private Proxy getProxyForHostAndPort(String string, URL uRL) {
        if (string.contains(PORT_HOST_SEPARATOR)) {
            int n;
            String[] stringArray = string.split(PORT_HOST_SEPARATOR);
            String string2 = stringArray[0];
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                return this.getProxyWhenInvalidPortSpecified(string2, uRL);
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string2, n));
        }
        return this.getProxyWhenNoPortSpecified(string, uRL);
    }

    private static boolean atLeastOneProxyServerDefined(String string) {
        return string != null && !string.isEmpty();
    }
}

